/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.adb.wireless.PairDevicesUsingWiFiService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.devicemanager.Devices;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceAsyncSupplier;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceChangeListener;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceDetailsPanel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTable;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableModel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalTabPersistentStateComponent;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhysicalDevicePanel
extends DevicePanel {
    @NotNull
    private final Disposable myParent;
    @NotNull
    private final Function<Project, PairDevicesUsingWiFiService> myPairDevicesUsingWiFiServiceGetInstance;
    @NotNull
    private final WearPairingManager myManager;
    @NotNull
    private final Supplier<PhysicalTabPersistentStateComponent> myPhysicalTabPersistentStateComponentGetInstance;
    @NotNull
    private final BiFunction<PhysicalDeviceTableModel, Project, Disposable> myNewPhysicalDeviceChangeListener;
    @NotNull
    private final BiFunction<PhysicalDevice, Project, DetailsPanel> myNewPhysicalDeviceDetailsPanel;
    @Nullable
    private AbstractButton myPairUsingWiFiButton;
    @Nullable
    private Component mySeparator;
    @Nullable
    private AbstractButton myHelpButton;

    public PhysicalDevicePanel(@Nullable Project project, @NotNull Disposable parent2) {
        this(project, parent2, PairDevicesUsingWiFiService::getInstance, WearPairingManager.getInstance(), PhysicalTabPersistentStateComponent::getInstance, PhysicalDeviceChangeListener::new, PhysicalDeviceDetailsPanel::new, new PhysicalDeviceAsyncSupplier(project), PhysicalDevicePanel::newSetDevices);
    }

    @VisibleForTesting
    PhysicalDevicePanel(@Nullable Project project, @NotNull Disposable parent2, @NotNull Function<Project, PairDevicesUsingWiFiService> pairDevicesUsingWiFiServiceGetInstance, @NotNull WearPairingManager manager, @NotNull Supplier<PhysicalTabPersistentStateComponent> physicalTabPersistentStateComponentGetInstance, @NotNull BiFunction<PhysicalDeviceTableModel, Project, Disposable> newPhysicalDeviceChangeListener, @NotNull BiFunction<PhysicalDevice, Project, DetailsPanel> newPhysicalDeviceDetailsPanel, @NotNull PhysicalDeviceAsyncSupplier supplier2, @NotNull Function<PhysicalDevicePanel, FutureCallback<List<PhysicalDevice>>> newSetDevices) {
        super(project);
        this.myParent = parent2;
        this.myPairDevicesUsingWiFiServiceGetInstance = pairDevicesUsingWiFiServiceGetInstance;
        this.myManager = manager;
        this.myPhysicalTabPersistentStateComponentGetInstance = physicalTabPersistentStateComponentGetInstance;
        this.myNewPhysicalDeviceChangeListener = newPhysicalDeviceChangeListener;
        this.myNewPhysicalDeviceDetailsPanel = newPhysicalDeviceDetailsPanel;
        this.initPairUsingWiFiButton();
        this.initSeparator();
        this.initHelpButton();
        this.initTable();
        this.initScrollPane();
        this.initDetailsPanelPanel();
        this.layOut();
        FutureUtils.addCallback(supplier2.get(), (Executor)EdtExecutorService.getInstance(), newSetDevices.apply(this));
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    @VisibleForTesting
    @NotNull
    static FutureCallback<List<PhysicalDevice>> newSetDevices(@NotNull PhysicalDevicePanel panel2) {
        return new DeviceManagerFutureCallback<List<PhysicalDevice>>(PhysicalDevicePanel.class, devices2 -> {
            assert (devices2 != null);
            panel2.setDevices(panel2.addOfflineDevices((List<PhysicalDevice>)devices2));
        });
    }

    private void initPairUsingWiFiButton() {
        if (this.myProject == null) {
            return;
        }
        PairDevicesUsingWiFiService service = this.myPairDevicesUsingWiFiServiceGetInstance.apply(this.myProject);
        if (!service.isFeatureEnabled()) {
            return;
        }
        this.myPairUsingWiFiButton = new JButton("Pair using Wi-Fi");
        this.myPairUsingWiFiButton.addActionListener(event2 -> service.createPairingDialogController().showDialog());
    }

    private void initSeparator() {
        if (this.myPairUsingWiFiButton == null) {
            return;
        }
        JBDimension size = new JBDimension(3, 20);
        this.mySeparator = new JSeparator(1);
        this.mySeparator.setPreferredSize((Dimension)size);
        this.mySeparator.setMaximumSize((Dimension)size);
    }

    private void initHelpButton() {
        this.myHelpButton = new CommonButton(AllIcons.Actions.Help);
        this.myHelpButton.addActionListener(event2 -> BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/device-manager/physical"));
    }

    @Override
    @NotNull
    protected JTable newTable() {
        return new PhysicalDeviceTable(this, this.myManager);
    }

    @NotNull
    private List<PhysicalDevice> addOfflineDevices(@NotNull List<PhysicalDevice> onlineDevices) {
        Collection<PhysicalDevice> persistedDevices = this.myPhysicalTabPersistentStateComponentGetInstance.get().get();
        ArrayList<PhysicalDevice> devices2 = new ArrayList<PhysicalDevice>(onlineDevices.size() + persistedDevices.size());
        devices2.addAll(onlineDevices);
        persistedDevices.stream().filter(persistedDevice -> Devices.indexOf(onlineDevices, persistedDevice.getKey()) == -1).forEach(devices2::add);
        return devices2;
    }

    private void setDevices(@NotNull List<PhysicalDevice> devices2) {
        PhysicalDeviceTableModel model2 = this.getTable().getModel();
        model2.addTableModelListener(event2 -> this.myPhysicalTabPersistentStateComponentGetInstance.get().set(model2.getDevices()));
        model2.setDevices(devices2);
        Disposer.register((Disposable)this.myParent, (Disposable)this.myNewPhysicalDeviceChangeListener.apply(model2, this.myProject));
    }

    @Override
    @NotNull
    protected DetailsPanel newDetailsPanel() {
        Optional<DetailsPanel> panel2 = this.getTable().getSelectedDevice().map(device2 -> this.myNewPhysicalDeviceDetailsPanel.apply((PhysicalDevice)device2, this.myProject));
        return panel2.orElseGet(() -> super.newDetailsPanel());
    }

    @Nullable
    @VisibleForTesting
    AbstractButton getPairUsingWiFiButton() {
        return this.myPairUsingWiFiButton;
    }

    @NotNull
    PhysicalDeviceTable getTable() {
        return (PhysicalDeviceTable)((Object)this.myTable);
    }

    private void layOut() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        GroupLayout.SequentialGroup toolbarHorizontalGroup = layout.createSequentialGroup();
        if (this.myPairUsingWiFiButton != null) {
            ((GroupLayout.Group)toolbarHorizontalGroup).addGap(JBUIScale.scale((int)5)).addComponent(this.myPairUsingWiFiButton).addGap(JBUIScale.scale((int)4)).addComponent(this.mySeparator);
        }
        ((GroupLayout.Group)toolbarHorizontalGroup).addComponent(this.myHelpButton);
        GroupLayout.ParallelGroup toolbarVerticalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        if (this.myPairUsingWiFiButton != null) {
            ((GroupLayout.Group)toolbarVerticalGroup).addComponent(this.myPairUsingWiFiButton).addComponent(this.mySeparator);
        }
        ((GroupLayout.Group)toolbarVerticalGroup).addComponent(this.myHelpButton);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addGroup(toolbarHorizontalGroup).addComponent((Component)((Object)this.myDetailsPanelPanel));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addGroup(toolbarVerticalGroup).addComponent((Component)((Object)this.myDetailsPanelPanel));
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }
}

