/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.InfoSection;
import com.android.tools.idea.devicemanager.PairedDevicesPanel;
import com.android.tools.idea.devicemanager.ScreenDiagram;
import com.android.tools.idea.devicemanager.physicaltab.AsyncDetailsBuilder;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.concurrent.Executor;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDeviceDetailsPanel
extends DetailsPanel {
    private final boolean myOnline;
    private ListenableFuture<PhysicalDevice> myFuture;
    private NewInfoSectionCallback<SummarySection> myNewSummarySectionCallback;

    PhysicalDeviceDetailsPanel(@NotNull PhysicalDevice device2, @Nullable Project project) {
        this(device2, new AsyncDetailsBuilder(project, device2), WearPairingManager.getInstance());
    }

    @VisibleForTesting
    PhysicalDeviceDetailsPanel(@NotNull PhysicalDevice device2, @NotNull AsyncDetailsBuilder builder2, @NotNull WearPairingManager manager) {
        this(device2, builder2, manager, PhysicalDeviceDetailsPanel::newSummarySectionCallback);
    }

    @VisibleForTesting
    PhysicalDeviceDetailsPanel(@NotNull PhysicalDevice device2, @NotNull AsyncDetailsBuilder builder2, @NotNull WearPairingManager manager, @NotNull NewInfoSectionCallback<SummarySection> newSummarySectionCallback) {
        super(device2.getName(), device2.isOnline() ? null : "Details unavailable for offline devices");
        this.myOnline = device2.isOnline();
        if (this.myOnline) {
            this.myFuture = builder2.buildAsync();
            this.myNewSummarySectionCallback = newSummarySectionCallback;
            Futures.addCallback(this.myFuture, this.newScreenDiagramCallback(), (Executor)EdtExecutorService.getInstance());
            InfoSection.newPairedDeviceSection(device2, manager).ifPresent(this.myInfoSections::add);
            if (((Boolean)StudioFlags.PAIRED_DEVICES_TAB_ENABLED.get()).booleanValue() && device2.getType().equals((Object)DeviceType.PHONE)) {
                this.myPairedDevicesPanel = new PairedDevicesPanel(device2.getKey(), this, builder2.getProject(), manager);
            }
        }
        this.init();
    }

    @Override
    protected void initSummarySection() {
        if (!this.myOnline) {
            return;
        }
        SummarySection summarySection = new SummarySection();
        Futures.addCallback(this.myFuture, this.myNewSummarySectionCallback.apply(summarySection), (Executor)EdtExecutorService.getInstance());
        this.mySummarySection = summarySection;
    }

    @VisibleForTesting
    @NotNull
    static FutureCallback<PhysicalDevice> newSummarySectionCallback(@NotNull SummarySection section) {
        return new DeviceManagerFutureCallback<PhysicalDevice>(PhysicalDeviceDetailsPanel.class, device2 -> {
            InfoSection.setText(section.myApiLevelLabel, device2.getAndroidVersion().getApiString());
            InfoSection.setText(section.myPowerLabel, device2.getPower());
            InfoSection.setText(section.myResolutionLabel, device2.getResolution());
            InfoSection.setText(section.myDpLabel, device2.getDp());
            InfoSection.setText(section.myAbiListLabel, device2.getAbis());
            InfoSection.setText(section.myAvailableStorageLabel, device2.getStorageDevice());
        });
    }

    @NotNull
    private FutureCallback<PhysicalDevice> newScreenDiagramCallback() {
        return new DeviceManagerFutureCallback<PhysicalDevice>(PhysicalDeviceDetailsPanel.class, device2 -> {
            if (device2.getDp() != null) {
                this.myScreenDiagram = new ScreenDiagram((Device)device2);
                this.setInfoSectionPanelLayout();
            }
        });
    }

    @NotNull
    @VisibleForTesting
    SummarySection getSummarySection() {
        assert (this.mySummarySection != null);
        return (SummarySection)((Object)this.mySummarySection);
    }

    @VisibleForTesting
    static interface NewInfoSectionCallback<S> {
        @NotNull
        public FutureCallback<PhysicalDevice> apply(@NotNull S var1);
    }

    @VisibleForTesting
    static final class SummarySection
    extends InfoSection {
        @VisibleForTesting
        @NotNull
        final JLabel myApiLevelLabel = this.addNameAndValueLabels("API level");
        @NotNull
        private final JLabel myPowerLabel = this.addNameAndValueLabels("Power");
        @VisibleForTesting
        @NotNull
        final JLabel myResolutionLabel = this.addNameAndValueLabels("Resolution");
        @VisibleForTesting
        @NotNull
        final JLabel myDpLabel = this.addNameAndValueLabels("dp");
        @VisibleForTesting
        @NotNull
        final JLabel myAbiListLabel = this.addNameAndValueLabels("ABI list");
        @NotNull
        private final JLabel myAvailableStorageLabel = this.addNameAndValueLabels("Available storage");

        private SummarySection() {
            super("Summary");
            this.setLayout();
        }
    }
}

