/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.tools.idea.devicemanager.DeviceManagerAndroidDebugBridge;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.physicaltab.BuilderService;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableModel;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class PhysicalDeviceChangeListener
implements Disposable,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private static final Pattern RE_LOCALHOST_SN = Pattern.compile("localhost:(\\d+)");
    @NotNull
    private final DeviceManagerAndroidDebugBridge myBridge;
    @NotNull
    private final ListeningExecutorService myEdtExecutorService;
    @NotNull
    private final Supplier<BuilderService> myBuilderServiceGetInstance;
    @NotNull
    private final FutureCallback<PhysicalDevice> myCallback;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<String> myFirebaseDeviceTracker;

    @UiThread
    PhysicalDeviceChangeListener(@NotNull PhysicalDeviceTableModel model2, @NotNull Project project) {
        this(new DeviceManagerAndroidDebugBridge(), BuilderService::getInstance, PhysicalDeviceChangeListener.newAddOrSet(model2), project);
    }

    @UiThread
    @VisibleForTesting
    PhysicalDeviceChangeListener(@NotNull DeviceManagerAndroidDebugBridge bridge, @NotNull Supplier<BuilderService> builderServiceGetInstance, @NotNull FutureCallback<PhysicalDevice> callback2, @NotNull Project project) {
        this.myBridge = bridge;
        this.myEdtExecutorService = MoreExecutors.listeningDecorator((ExecutorService)EdtExecutorService.getInstance());
        this.myBuilderServiceGetInstance = builderServiceGetInstance;
        this.myCallback = callback2;
        this.myProject = project;
        this.myFirebaseDeviceTracker = new HashSet<String>();
        bridge.addDeviceChangeListener(this);
    }

    @UiThread
    @VisibleForTesting
    @NotNull
    static FutureCallback<PhysicalDevice> newAddOrSet(@NotNull PhysicalDeviceTableModel model2) {
        return new DeviceManagerFutureCallback<PhysicalDevice>(PhysicalDeviceChangeListener.class, model2::addOrSet);
    }

    @UiThread
    public void dispose() {
        this.myBridge.removeDeviceChangeListener(this);
    }

    @WorkerThread
    public void deviceConnected(@NotNull IDevice device2) {
        if (device2.isEmulator()) {
            return;
        }
        if (this.isFirebaseDevice(device2)) {
            this.myFirebaseDeviceTracker.add(device2.getSerialNumber());
            return;
        }
        Logger.getInstance(PhysicalDeviceChangeListener.class).info(device2 + " connected");
        this.buildPhysicalDevice(device2);
    }

    @WorkerThread
    public void deviceDisconnected(@NotNull IDevice device2) {
        if (device2.isEmulator()) {
            return;
        }
        if (this.myFirebaseDeviceTracker.remove(device2.getSerialNumber())) {
            return;
        }
        Logger.getInstance(PhysicalDeviceChangeListener.class).info(device2 + " disconnected");
        this.buildPhysicalDevice(device2);
    }

    @WorkerThread
    public void deviceChanged(@NotNull IDevice device2, int mask) {
        if (device2.isEmulator()) {
            return;
        }
        if ((mask & 1) == 0) {
            return;
        }
        if (this.myFirebaseDeviceTracker.contains(device2.getSerialNumber())) {
            return;
        }
        Logger.getInstance(PhysicalDeviceChangeListener.class).info(device2 + " state changed to " + device2.getState());
        this.buildPhysicalDevice(device2);
    }

    @WorkerThread
    private void buildPhysicalDevice(@NotNull IDevice device2) {
        FluentFuture.from((ListenableFuture)this.myEdtExecutorService.submit(this.myBuilderServiceGetInstance::get)).transformAsync(builderService -> Objects.requireNonNull(builderService).build(device2), (Executor)this.myEdtExecutorService).addCallback(this.myCallback, (Executor)this.myEdtExecutorService);
    }

    private boolean isFirebaseDevice(@NotNull IDevice device2) {
        DeviceProvisioner deviceProvisioner = ((DeviceProvisionerService)this.myProject.getService(DeviceProvisionerService.class)).getDeviceProvisioner();
        return ((List)deviceProvisioner.getDevices().getValue()).stream().anyMatch(deviceHandle -> {
            if (RE_LOCALHOST_SN.matcher(device2.getSerialNumber()).matches()) {
                String port = device2.getSerialNumber().split(":")[1];
                return port.equals(deviceHandle.getState().getProperties().getDisambiguator());
            }
            return false;
        });
    }
}

