/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.device.Resolution;
import com.android.tools.idea.devicemanager.ConnectionType;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.StorageDevice;
import com.android.tools.idea.devicemanager.physicaltab.Battery;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhysicalDevice
extends Device {
    @NotNull
    private final String myNameOverride;
    @NotNull
    private final ImmutableCollection<ConnectionType> myConnectionTypes;
    @Nullable
    private final Battery myPower;

    private PhysicalDevice(@NotNull Builder builder2) {
        super(builder2);
        this.myNameOverride = builder2.myNameOverride;
        this.myConnectionTypes = ImmutableSet.copyOf(builder2.myConnectionTypes);
        this.myPower = builder2.myPower;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.myType.getPhysicalIcon();
    }

    @NotNull
    String getNameOverride() {
        return this.myNameOverride;
    }

    @Override
    public boolean isOnline() {
        return !this.myConnectionTypes.isEmpty();
    }

    @NotNull
    Collection<ConnectionType> getConnectionTypes() {
        return this.myConnectionTypes;
    }

    @Nullable
    Battery getPower() {
        return this.myPower;
    }

    public int hashCode() {
        int hashCode = this.myKey.hashCode();
        hashCode = 31 * hashCode + this.myType.hashCode();
        hashCode = 31 * hashCode + this.myName.hashCode();
        hashCode = 31 * hashCode + this.myNameOverride.hashCode();
        hashCode = 31 * hashCode + this.myTarget.hashCode();
        hashCode = 31 * hashCode + this.myAndroidVersion.hashCode();
        hashCode = 31 * hashCode + this.myConnectionTypes.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myPower);
        hashCode = 31 * hashCode + Objects.hashCode(this.myResolution);
        hashCode = 31 * hashCode + this.myDensity;
        hashCode = 31 * hashCode + this.myAbis.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myStorageDevice);
        return hashCode;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof PhysicalDevice)) {
            return false;
        }
        PhysicalDevice device2 = (PhysicalDevice)object;
        return this.myKey.equals(device2.myKey) && this.myType.equals((Object)device2.myType) && this.myName.equals(device2.myName) && this.myNameOverride.equals(device2.myNameOverride) && this.myTarget.equals(device2.myTarget) && this.myAndroidVersion.equals((Object)device2.myAndroidVersion) && this.myConnectionTypes.equals(device2.myConnectionTypes) && Objects.equals(this.myPower, device2.myPower) && Objects.equals(this.myResolution, device2.myResolution) && this.myDensity == device2.myDensity && this.myAbis.equals(device2.myAbis) && Objects.equals(this.myStorageDevice, device2.myStorageDevice);
    }

    public static final class Builder
    extends Device.Builder {
        @NotNull
        private String myNameOverride = "";
        @NotNull
        private final Collection<ConnectionType> myConnectionTypes = EnumSet.noneOf(ConnectionType.class);
        @Nullable
        private Battery myPower;

        @NotNull
        public Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        Builder setType(@NotNull DeviceType type) {
            this.myType = type;
            return this;
        }

        @NotNull
        public Builder setName(@NotNull String name2) {
            this.myName = name2;
            return this;
        }

        @NotNull
        Builder setNameOverride(@NotNull String nameOverride) {
            this.myNameOverride = nameOverride;
            return this;
        }

        @NotNull
        public Builder setTarget(@NotNull String target2) {
            this.myTarget = target2;
            return this;
        }

        @NotNull
        public Builder setAndroidVersion(@NotNull AndroidVersion androidVersion) {
            this.myAndroidVersion = androidVersion;
            return this;
        }

        @NotNull
        public Builder addConnectionType(@NotNull ConnectionType connectionType) {
            this.myConnectionTypes.add(connectionType);
            return this;
        }

        @NotNull
        Builder addAllConnectionTypes(@NotNull Collection<ConnectionType> connectionTypes) {
            this.myConnectionTypes.addAll(connectionTypes);
            return this;
        }

        @NotNull
        Builder setPower(@Nullable Battery power) {
            this.myPower = power;
            return this;
        }

        @NotNull
        Builder setResolution(@Nullable Resolution resolution2) {
            this.myResolution = resolution2;
            return this;
        }

        @NotNull
        Builder setDensity(int density) {
            this.myDensity = density;
            return this;
        }

        @NotNull
        Builder addAllAbis(@NotNull Collection<String> abis) {
            this.myAbis.addAll(abis);
            return this;
        }

        @NotNull
        Builder setStorageDevice(@Nullable StorageDevice storageDevice) {
            this.myStorageDevice = storageDevice;
            return this;
        }

        @Override
        @NotNull
        public PhysicalDevice build() {
            return new PhysicalDevice(this);
        }
    }
}

