/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.ConnectionType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomainName
extends Key {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("adb-(.*)-.*\\._adb-tls-connect\\._tcp\\.?");
    @NotNull
    private final String myValue;

    DomainName(@NotNull String value2) {
        assert (PATTERN.matcher(value2).matches());
        this.myValue = value2;
    }

    @Override
    @NotNull
    public ConnectionType getConnectionType() {
        return ConnectionType.WI_FI;
    }

    @Override
    @NotNull
    public SerialNumber getSerialNumber() {
        Matcher matcher = PATTERN.matcher(this.myValue);
        if (!matcher.matches()) {
            throw new AssertionError((Object)this.myValue);
        }
        return new SerialNumber(matcher.group(1));
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    public int hashCode() {
        return this.myValue.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof DomainName && this.myValue.equals(((DomainName)object).myValue);
    }

    @NotNull
    public String toString() {
        return this.myValue;
    }
}

