/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.Patterns;
import com.google.common.annotations.VisibleForTesting;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.util.NoUnit;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Battery {
    @NotNull
    private static final Pattern AC = Pattern.compile(" {2}AC powered: (\\w+)");
    @NotNull
    private static final Pattern USB = Pattern.compile(" {2}USB powered: (\\w+)");
    @NotNull
    private static final Pattern WIRELESS = Pattern.compile(" {2}Wireless powered: (\\w+)");
    @NotNull
    private static final Pattern LEVEL = Pattern.compile(" {2}level: (\\d+)");
    @NotNull
    private static final Pattern SCALE = Pattern.compile(" {2}scale: (\\d+)");
    @NotNull
    private static final LocalizedNumberFormatter FORMATTER = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.US).unit(NoUnit.PERCENT);
    @NotNull
    private final ChargingType myChargingType;
    private final int myLevel;

    @VisibleForTesting
    Battery(@NotNull ChargingType chargingType, int level) {
        this.myChargingType = chargingType;
        this.myLevel = level;
    }

    @NotNull
    static Optional<Battery> newBattery(@NotNull List<String> output) {
        Optional<Boolean> ac = Battery.parseBoolean(AC, output.get(1));
        Optional<Boolean> usb = Battery.parseBoolean(USB, output.get(2));
        Optional<Boolean> wireless = Battery.parseBoolean(WIRELESS, output.get(3));
        OptionalInt level = Patterns.parseInt(LEVEL, output.get(10));
        OptionalInt scale = Patterns.parseInt(SCALE, output.get(11));
        if (!(ac.isPresent() && usb.isPresent() && wireless.isPresent() && level.isPresent() && scale.isPresent())) {
            return Optional.empty();
        }
        return Optional.of(new Battery(ChargingType.valueOf(ac.get(), usb.get(), wireless.get()), 100 * level.getAsInt() / scale.getAsInt()));
    }

    @NotNull
    private static Optional<Boolean> parseBoolean(@NotNull Pattern pattern, @NotNull String string) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            Logger.getInstance(Battery.class).warn(string);
            return Optional.empty();
        }
        return Optional.of(Boolean.parseBoolean(matcher.group(1)));
    }

    public int hashCode() {
        return 31 * this.myChargingType.hashCode() + this.myLevel;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Battery)) {
            return false;
        }
        Battery battery = (Battery)object;
        return this.myChargingType.equals((Object)battery.myChargingType) && this.myLevel == battery.myLevel;
    }

    @NotNull
    public String toString() {
        switch (this.myChargingType) {
            case NOT_CHARGING: {
                return "Battery " + FORMATTER.format((long)this.myLevel);
            }
            case WIRELESS: {
                return "Wireless";
            }
        }
        return this.myChargingType.toString();
    }

    @VisibleForTesting
    static enum ChargingType {
        NOT_CHARGING,
        AC,
        USB,
        WIRELESS;


        @NotNull
        private static ChargingType valueOf(boolean ac, boolean usb, boolean wireless) {
            if (ac) {
                return AC;
            }
            if (usb) {
                return USB;
            }
            if (wireless) {
                return WIRELESS;
            }
            return NOT_CHARGING;
        }
    }
}

