/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.Targets;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

final class AsyncPhysicalDeviceBuilder {
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final Key myKey;
    @NotNull
    private final ListenableFuture<AndroidVersion> myVersionFuture;
    @NotNull
    private final ListenableFuture<DeviceType> myTypeFuture;
    @NotNull
    private final ListenableFuture<String> myModelFuture;
    @NotNull
    private final ListenableFuture<String> myManufacturerFuture;

    @UiThread
    AsyncPhysicalDeviceBuilder(@NotNull IDevice device2, @NotNull Key key) {
        this.myDevice = device2;
        this.myKey = key;
        this.myVersionFuture = DeviceManagerFutures.appExecutorServiceSubmit(() -> ((IDevice)device2).getVersion());
        this.myTypeFuture = DeviceManagerFutures.appExecutorServiceSubmit(this::getType);
        this.myModelFuture = device2.getSystemProperty("ro.product.model");
        this.myManufacturerFuture = device2.getSystemProperty("ro.product.manufacturer");
    }

    @WorkerThread
    private DeviceType getType() {
        String string = this.myDevice.getProperty("ro.build.characteristics");
        if (string == null) {
            return DeviceType.PHONE;
        }
        List<String> collection2 = Arrays.asList(string.split(","));
        if (collection2.contains(IDevice.HardwareFeature.WATCH.getCharacteristic())) {
            return DeviceType.WEAR_OS;
        }
        if (collection2.contains(IDevice.HardwareFeature.TV.getCharacteristic())) {
            return DeviceType.TV;
        }
        if (collection2.contains(IDevice.HardwareFeature.AUTOMOTIVE.getCharacteristic())) {
            return DeviceType.AUTOMOTIVE;
        }
        return DeviceType.PHONE;
    }

    @UiThread
    @NotNull
    ListenableFuture<PhysicalDevice> buildAsync() {
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{this.myVersionFuture, this.myTypeFuture, this.myModelFuture, this.myManufacturerFuture}).call(this::build, (Executor)EdtExecutorService.getInstance());
    }

    @UiThread
    @NotNull
    private PhysicalDevice build() {
        AndroidVersion version2 = DeviceManagerFutures.getDoneOrElse(this.myVersionFuture, AndroidVersion.DEFAULT);
        PhysicalDevice.Builder builder2 = new PhysicalDevice.Builder().setKey(this.myKey).setType(DeviceManagerFutures.getDoneOrElse(this.myTypeFuture, DeviceType.PHONE)).setName(DeviceNameProperties.getName((String)FutureUtils.getDoneOrNull(this.myModelFuture), (String)FutureUtils.getDoneOrNull(this.myManufacturerFuture))).setTarget(Targets.toString(version2)).setAndroidVersion(version2);
        if (this.myDevice.isOnline()) {
            builder2.addConnectionType(this.myKey.getConnectionType());
        }
        return builder2.build();
    }
}

