/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.device.Resolution;
import com.android.tools.idea.devicemanager.AdbShellCommandExecutor;
import com.android.tools.idea.devicemanager.DeviceManagerAndroidDebugBridge;
import com.android.tools.idea.devicemanager.StorageDevice;
import com.android.tools.idea.devicemanager.physicaltab.Battery;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AsyncDetailsBuilder {
    @Nullable
    private final Project myProject;
    @NotNull
    private final PhysicalDevice myDevice;
    @NotNull
    private final DeviceManagerAndroidDebugBridge myBridge;
    @NotNull
    private final AdbShellCommandExecutor myExecutor;

    AsyncDetailsBuilder(@Nullable Project project, @NotNull PhysicalDevice device2) {
        this(project, device2, new DeviceManagerAndroidDebugBridge(), new AdbShellCommandExecutor());
    }

    @VisibleForTesting
    AsyncDetailsBuilder(@Nullable Project project, @NotNull PhysicalDevice device2, @NotNull DeviceManagerAndroidDebugBridge bridge, @NotNull AdbShellCommandExecutor executor2) {
        this.myProject = project;
        this.myDevice = device2;
        this.myBridge = bridge;
        this.myExecutor = executor2;
    }

    @NotNull
    ListenableFuture<PhysicalDevice> buildAsync() {
        ExecutorService executor2 = AppExecutorUtil.getAppExecutorService();
        return FluentFuture.from(this.myBridge.getDevices(this.myProject)).transform(this::findDevice, (Executor)executor2).transform(this::build, (Executor)executor2);
    }

    @NotNull
    private IDevice findDevice(@NotNull Collection<IDevice> devices2) {
        String key = this.myDevice.getKey().toString();
        Optional<IDevice> optionalDevice = devices2.stream().filter(device2 -> device2.getSerialNumber().equals(key)).findFirst();
        return optionalDevice.orElseThrow(AssertionError::new);
    }

    @NotNull
    private PhysicalDevice build(@NotNull IDevice device2) {
        return new PhysicalDevice.Builder().setKey(this.myDevice.getKey()).setName(this.myDevice.getName()).setTarget(this.myDevice.getTarget()).setAndroidVersion(this.myDevice.getAndroidVersion()).setPower(this.myExecutor.execute(device2, "dumpsys battery").flatMap(Battery::newBattery).orElse(null)).setResolution(this.myExecutor.execute(device2, "wm size").map(Resolution::parseWmSizeOutput).orElse(null)).setDensity(device2.getDensity()).addAllAbis(device2.getAbis()).setStorageDevice(this.myExecutor.execute(device2, "df /data").flatMap(StorageDevice::newStorageDevice).orElse(null)).build();
    }

    @Nullable
    Project getProject() {
        return this.myProject;
    }
}

