/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.Patterns;
import com.google.common.annotations.VisibleForTesting;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.util.MeasureUnit;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StorageDevice {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile(".+\\s+\\d+\\s+\\d+\\s+(\\d+)\\s+.+\\s+.+");
    @NotNull
    private static final LocalizedNumberFormatter FORMATTER = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.US).unit(MeasureUnit.MEGABYTE);
    private final int myAvailableSpace;

    @VisibleForTesting
    public StorageDevice(int availableSpace) {
        this.myAvailableSpace = availableSpace;
    }

    @NotNull
    public static Optional<StorageDevice> newStorageDevice(@NotNull List<String> output) {
        return Patterns.parseInt(PATTERN, output.get(1)).stream().map(availableSpace -> availableSpace / 1024).mapToObj(StorageDevice::new).findFirst();
    }

    public int hashCode() {
        return this.myAvailableSpace;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof StorageDevice && this.myAvailableSpace == ((StorageDevice)object).myAvailableSpace;
    }

    @NotNull
    public String toString() {
        return FORMATTER.format((long)this.myAvailableSpace).toString();
    }
}

