/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.devicemanager.IconButtonTableCellEditor;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wearpairing.AndroidWearPairingBundle;
import com.android.tools.idea.wearpairing.WearDevicePairingWizard;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.android.tools.idea.wearpairing.WearPairingManagerKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public abstract class PopUpMenuButtonTableCellEditor
extends IconButtonTableCellEditor {
    @NotNull
    protected final DevicePanel myPanel;
    @NotNull
    private final WearPairingManager myManager;
    protected Device myDevice;

    protected PopUpMenuButtonTableCellEditor(@NotNull DevicePanel panel2, @NotNull WearPairingManager manager) {
        super(PopUpMenuValue.INSTANCE, AllIcons.Actions.More);
        this.myPanel = panel2;
        this.myManager = manager;
        this.myButton.addActionListener(event2 -> {
            JBPopupMenu menu = new JBPopupMenu();
            this.newItems().forEach(((JPopupMenu)menu)::add);
            menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeInvisible(@NotNull PopupMenuEvent event2) {
                    PopUpMenuButtonTableCellEditor.this.fireEditingCanceled();
                }
            });
            menu.show(this.myButton, 0, this.myButton.getHeight());
        });
    }

    @VisibleForTesting
    @NotNull
    public abstract List<JComponent> newItems();

    @NotNull
    protected final JComponent newPairWearableItem(@NotNull DeviceManagerEvent.EventKind kind) {
        JBMenuItem item2 = new JBMenuItem("Pair Wearable");
        item2.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(kind).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            new WearDevicePairingWizard().show(this.myPanel.getProject(), this.myDevice.getKey().toString());
        });
        return item2;
    }

    @NotNull
    protected final Optional<JComponent> newViewPairedDevicesItem(@NotNull DeviceManagerEvent.EventKind kind) {
        String key = this.myDevice.getKey().toString();
        List<WearPairingManager.PhoneWearPair> pairs = this.myManager.getPairsForDevice(key);
        if (pairs.isEmpty()) {
            return Optional.empty();
        }
        boolean enabled2 = (Boolean)StudioFlags.PAIRED_DEVICES_TAB_ENABLED.get();
        JBMenuItem item2 = new JBMenuItem(enabled2 ? "View Paired Device(s)" : "Unpair Device");
        item2.addActionListener(arg_0 -> this.lambda$newViewPairedDevicesItem$2(kind, enabled2, pairs, key, (AbstractButton)item2, arg_0));
        return Optional.of(item2);
    }

    private /* synthetic */ void lambda$newViewPairedDevicesItem$2(DeviceManagerEvent.EventKind kind, boolean enabled2, List pairs, String key, AbstractButton item2, ActionEvent actionEvent) {
        DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(kind).build();
        DeviceManagerUsageTracker.log(deviceManagerEvent);
        if (enabled2) {
            this.myPanel.viewDetails(1);
        } else {
            String name2 = ((WearPairingManager.PhoneWearPair)pairs.get(0)).getPeerDevice(key).getDisplayName();
            item2.setToolTipText(AndroidWearPairingBundle.message("wear.assistant.device.list.forget.connection", name2));
            WearPairingManagerKt.removeAllPairedDevicesAsync(this.myManager, key, true);
        }
    }
}

