/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceIconButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.DeviceManagerPairingDeviceTableCellRenderer;
import com.android.tools.idea.devicemanager.DeviceTable;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.Pairing;
import com.android.tools.idea.devicemanager.PairingTableModel;
import com.android.tools.idea.devicemanager.Status;
import com.android.tools.idea.devicemanager.StatusTableCellRenderer;
import com.android.tools.idea.devicemanager.Tables;
import com.android.tools.idea.wearpairing.WearDevicePairingWizard;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import java.util.Optional;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PairingTable
extends DeviceTable<Device> {
    @NotNull
    private final Object myKey;
    @Nullable
    private final Project myProject;

    PairingTable(@NotNull Key key, @Nullable Project project, @NotNull WearPairingManager manager) {
        super(new PairingTableModel(), Device.class);
        this.myKey = key;
        this.myProject = project;
        this.setDefaultRenderer(DeviceType.class, new DeviceIconButtonTableCellRenderer<Device>(this));
        this.setDefaultRenderer(Device.class, new DeviceManagerPairingDeviceTableCellRenderer(manager));
        this.setDefaultRenderer(Status.class, new StatusTableCellRenderer());
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.getEmptyText().appendLine("Device is not paired to companion device.").appendLine("Pair wearable", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, event2 -> this.pairWearable());
        this.tableHeader.setReorderingAllowed(false);
        this.tableHeader.setResizingAllowed(false);
    }

    private void pairWearable() {
        new WearDevicePairingWizard().show(this.myProject, this.myKey.toString());
    }

    private int deviceIconViewColumnIndex() {
        return this.convertColumnIndexToView(0);
    }

    @Override
    protected int deviceViewColumnIndex() {
        return this.convertColumnIndexToView(1);
    }

    private int statusViewColumnIndex() {
        return this.convertColumnIndexToView(2);
    }

    @NotNull
    Optional<Pairing> getSelectedPairing() {
        int viewRowIndex = this.getSelectedRow();
        if (viewRowIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(this.getModel().getPairings().get(this.convertRowIndexToModel(viewRowIndex)));
    }

    public void doLayout() {
        Tables.setWidths(this.columnModel.getColumn(this.deviceIconViewColumnIndex()), DeviceIconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), DeviceType.class));
        this.columnModel.getColumn(this.deviceViewColumnIndex()).setMinWidth(JBUIScale.scale((int)65));
        Tables.setWidths(this.columnModel.getColumn(this.statusViewColumnIndex()), Tables.getPreferredColumnWidth((JTable)((Object)this), this.statusViewColumnIndex(), JBUIScale.scale((int)65)), JBUIScale.scale((int)20));
        super.doLayout();
    }

    @NotNull
    public PairingTableModel getModel() {
        return (PairingTableModel)this.dataModel;
    }
}

