/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfoSection
extends JBPanel<InfoSection> {
    @NotNull
    private final JLabel myHeadingLabel;
    @NotNull
    private final List<JLabel> myNameLabels;
    @NotNull
    private final List<JLabel> myValueLabels;

    public InfoSection(@NotNull String heading) {
        super(null);
        this.myHeadingLabel = DetailsPanel.newHeadingLabel(heading);
        this.myNameLabels = new ArrayList<JLabel>();
        this.myValueLabels = new ArrayList<JLabel>();
        this.setOpaque(false);
    }

    @NotNull
    public final JLabel addNameAndValueLabels(@NotNull String name2) {
        JBLabel nameLabel = new JBLabel(name2);
        nameLabel.setForeground(StandardColors.TEXT_COLOR);
        this.myNameLabels.add((JLabel)nameLabel);
        JBLabel valueLabel = new JBLabel();
        this.myValueLabels.add((JLabel)valueLabel);
        return valueLabel;
    }

    public final void setLayout() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        layout.linkSize((Component[])this.myNameLabels.toArray(Component[]::new));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addComponent(this.myHeadingLabel);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.myHeadingLabel);
        Streams.forEachPair(this.myNameLabels.stream(), this.myValueLabels.stream(), (nameLabel, valueLabel) -> {
            horizontalGroup.addGroup(layout.createSequentialGroup().addComponent((Component)nameLabel).addComponent((Component)valueLabel));
            verticalGroup.addGroup(layout.createParallelGroup().addComponent((Component)nameLabel).addComponent((Component)valueLabel));
        });
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }

    @NotNull
    public static Optional<InfoSection> newPairedDeviceSection(@NotNull Device device2, @NotNull WearPairingManager manager) {
        if (((Boolean)StudioFlags.PAIRED_DEVICES_TAB_ENABLED.get()).booleanValue()) {
            return Optional.empty();
        }
        String key = device2.getKey().toString();
        List<WearPairingManager.PhoneWearPair> pairList = manager.getPairsForDevice(key);
        if (pairList.isEmpty()) {
            return Optional.empty();
        }
        WearPairingManager.PhoneWearPair pair = pairList.get(0);
        InfoSection section = new InfoSection("Paired device");
        InfoSection.setText(section.addNameAndValueLabels("Paired with"), pair.getPeerDevice(key).getDisplayName());
        InfoSection.setText(section.addNameAndValueLabels("Status"), switch (pair.getPairingStatus()) {
            case WearPairingManager.PairingState.OFFLINE -> "Offline";
            case WearPairingManager.PairingState.CONNECTING -> "Connecting";
            case WearPairingManager.PairingState.CONNECTED -> "Connected";
            case WearPairingManager.PairingState.PAIRING_FAILED -> "Error pairing";
            default -> throw new AssertionError((Object)pair.getPairingStatus());
        });
        section.setLayout();
        return Optional.of(section);
    }

    public static void setText(@NotNull JLabel label, @Nullable Object value2) {
        if (value2 == null) {
            return;
        }
        label.setText(value2.toString());
    }

    public static void setText(@NotNull JLabel label, @NotNull Iterable<String> values) {
        label.setText(String.join((CharSequence)", ", values));
    }

    @VisibleForTesting
    @NotNull
    public final Object getNames() {
        return InfoSection.getText(this.myNameLabels);
    }

    @VisibleForTesting
    @NotNull
    public final Object getValues() {
        return InfoSection.getText(this.myValueLabels);
    }

    @VisibleForTesting
    @NotNull
    private static Object getText(@NotNull Collection<JLabel> labels) {
        return labels.stream().map(JLabel::getText).collect(Collectors.toList());
    }

    @NotNull
    public final String toString() {
        Formatter formatter = new Formatter();
        formatter.format("%s%n", this.myHeadingLabel.getText());
        OptionalInt maxLength = this.myNameLabels.stream().map(JLabel::getText).mapToInt(CharSequence::length).max();
        String format = "%-" + maxLength.orElse(1) + "s %s%n";
        IntStream.range(0, this.myNameLabels.size()).forEach(i -> {
            String value2 = this.myValueLabels.get(i).getText();
            if (value2.isEmpty()) {
                formatter.format("%s%n", this.myNameLabels.get(i).getText());
            } else {
                formatter.format(format, this.myNameLabels.get(i).getText(), value2);
            }
        });
        return formatter.toString();
    }
}

