/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.TableCellRenderers;
import com.android.tools.idea.devicemanager.Tables;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wearpairing.AndroidWearPairingBundle;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Optional;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceTableCellRenderer<D extends Device>
implements TableCellRenderer {
    @NotNull
    private final Class<D> myValueClass;
    @NotNull
    private final WearPairingManager myManager;
    @NotNull
    private final JLabel myNameLabel;
    @NotNull
    private final JLabel myStateLabel;
    @NotNull
    private final JLabel myLine2Label;
    @NotNull
    private final JLabel myPairedLabel;
    @NotNull
    private final JComponent myPanel;

    protected DeviceTableCellRenderer(@NotNull Class<D> valueClass) {
        this(valueClass, WearPairingManager.getInstance());
    }

    protected DeviceTableCellRenderer(@NotNull Class<D> valueClass, @NotNull WearPairingManager manager) {
        this.myValueClass = valueClass;
        this.myManager = manager;
        this.myNameLabel = new JBLabel();
        this.myStateLabel = new JBLabel();
        this.myLine2Label = new JBLabel();
        this.myPairedLabel = new JBLabel();
        this.myPanel = new JBPanel(null);
        GroupLayout layout = new GroupLayout(this.myPanel);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myNameLabel, 0, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myStateLabel)).addComponent(this.myLine2Label, 0, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.myPairedLabel).addGap(JBUIScale.scale((int)4));
        GroupLayout.ParallelGroup verticalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myNameLabel).addComponent(this.myStateLabel)).addComponent(this.myLine2Label).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.myPairedLabel);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.myPanel.setLayout(layout);
    }

    @Override
    @NotNull
    public final Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
        Device device2 = (Device)this.myValueClass.cast(value2);
        Color foreground = Tables.getForeground(table2, selected);
        this.myNameLabel.setForeground(foreground);
        this.myNameLabel.setText(this.getName(device2));
        this.myStateLabel.setForeground(foreground);
        TableCellRenderers.setIcon(this.myStateLabel, this.getStateIcon(device2), selected);
        this.myLine2Label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myLine2Label.setForeground(DeviceTableCellRenderer.brighten(foreground));
        this.myLine2Label.setText(this.getLine2(device2));
        this.myPairedLabel.setForeground(foreground);
        if (((Boolean)StudioFlags.WEAR_OS_VIRTUAL_DEVICE_PAIRING_ASSISTANT_ENABLED.get()).booleanValue()) {
            Optional<Icon> icon2 = this.getPairedLabelIcon(device2);
            TableCellRenderers.setIcon(this.myPairedLabel, icon2.orElse(null), selected);
            this.myPairedLabel.setVisible(icon2.isPresent());
            this.myPanel.setToolTipText(this.getPairedTooltip(device2));
        }
        this.myPanel.setBackground(Tables.getBackground(table2, selected));
        this.myPanel.setBorder(Tables.getBorder(selected, focused));
        return this.myPanel;
    }

    @NotNull
    private String getPairedTooltip(@NotNull Device device2) {
        List<WearPairingManager.PhoneWearPair> pairList = this.myManager.getPairsForDevice(device2.getKey().toString());
        if (pairList.isEmpty()) {
            return "";
        }
        StringBuilder result2 = new StringBuilder("<html>");
        for (WearPairingManager.PhoneWearPair pair : pairList) {
            if (pair.getPairingStatus().equals((Object)WearPairingManager.PairingState.CONNECTED)) {
                result2.append(AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.status.connected", pair.getPeerDevice(device2.getKey().toString()).getDisplayName()));
                continue;
            }
            result2.append(AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.status.paired", pair.getPeerDevice(device2.getKey().toString()).getDisplayName()));
        }
        return result2.append("</html>").toString();
    }

    @NotNull
    protected String getName(@NotNull D device2) {
        return ((Device)device2).getName();
    }

    @Nullable
    protected Icon getStateIcon(@NotNull D device2) {
        return ((Device)device2).isOnline() ? StudioIcons.Avd.STATUS_DECORATOR_ONLINE : null;
    }

    @NotNull
    protected String getLine2(@NotNull D device2) {
        return ((Device)device2).getTarget();
    }

    @NotNull
    private static Color brighten(@NotNull Color color) {
        int red = Math.min(color.getRed() + 50, 255);
        int green = Math.min(color.getGreen() + 50, 255);
        int blue = Math.min(color.getBlue() + 50, 255);
        return new JBColor(new Color(red, green, blue), color.darker());
    }

    @NotNull
    Optional<Icon> getPairedLabelIcon(@NotNull Device device2) {
        List<WearPairingManager.PhoneWearPair> pairList = this.myManager.getPairsForDevice(device2.getKey().toString());
        if (pairList.isEmpty()) {
            return Optional.empty();
        }
        for (WearPairingManager.PhoneWearPair pair : pairList) {
            if (!pair.getPairingStatus().equals((Object)WearPairingManager.PairingState.CONNECTED)) continue;
            return Optional.of(StudioIcons.DeviceExplorer.DEVICE_PAIRED_AND_CONNECTED);
        }
        return Optional.of(StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN);
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getStateLabel() {
        return this.myStateLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getLine2Label() {
        return this.myLine2Label;
    }

    @VisibleForTesting
    @NotNull
    final JLabel getPairedLabel() {
        return this.myPairedLabel;
    }
}

