/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.DetailsPanelPanel;
import com.android.tools.idea.devicemanager.ViewDetailsListSelectionListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DevicePanel
extends JBPanel<DevicePanel>
implements Disposable {
    @Nullable
    protected final Project myProject;
    protected JTable myTable;
    private JComponent myScrollPane;
    protected DetailsPanelPanel myDetailsPanelPanel;

    protected DevicePanel(@Nullable Project project) {
        super(null);
        this.myProject = project;
    }

    protected final void initTable() {
        this.myTable = this.newTable();
        this.myTable.getSelectionModel().addListSelectionListener(new ViewDetailsListSelectionListener(this));
    }

    @NotNull
    protected abstract JTable newTable();

    protected final void initScrollPane() {
        this.myScrollPane = new JBScrollPane((Component)this.myTable);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event2) {
                int viewRowIndex = DevicePanel.this.myTable.getSelectedRow();
                if (viewRowIndex != -1) {
                    DevicePanel.this.myTable.scrollRectToVisible(DevicePanel.this.myTable.getCellRect(viewRowIndex, 0, true));
                }
            }
        });
    }

    protected final void initDetailsPanelPanel() {
        this.myDetailsPanelPanel = new DetailsPanelPanel(this.myScrollPane);
        Disposer.register((Disposable)this, (Disposable)this.myDetailsPanelPanel);
    }

    public void dispose() {
    }

    @Nullable
    public final Project getProject() {
        return this.myProject;
    }

    public final boolean hasDetails() {
        return this.myDetailsPanelPanel.getSplitter().isPresent();
    }

    public final void viewDetails() {
        this.viewDetails(0);
    }

    public final void viewDetails(int index2) {
        DetailsPanel panel2 = this.newDetailsPanel();
        panel2.getCloseButton().addActionListener(event2 -> this.myDetailsPanelPanel.removeSplitter());
        panel2.getTabbedPane().ifPresent(pane -> pane.setSelectedIndex(index2));
        this.myDetailsPanelPanel.viewDetails(panel2);
        switch (index2) {
            case 0: {
                panel2.requestFocusInWindow();
                break;
            }
            case 1: {
                panel2.getPairedDevicesPanel().orElseThrow().getTable().requestFocusInWindow();
                break;
            }
            default: {
                assert (false) : index2;
                break;
            }
        }
    }

    @NotNull
    protected DetailsPanel newDetailsPanel() {
        DetailsPanel panel2 = new DetailsPanel("Device Details", "Select a device to view device details");
        panel2.init();
        return panel2;
    }
}

