/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.Status;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceManagerPairingDevice
extends Device {
    @NotNull
    private final Icon myIcon;
    private final boolean myOnline;
    @NotNull
    private final Status myStatus;

    private DeviceManagerPairingDevice(@NotNull Builder builder2) {
        super(builder2);
        assert (builder2.myIcon != null);
        this.myIcon = builder2.myIcon;
        this.myOnline = builder2.myOnline;
        assert (builder2.myStatus != null);
        this.myStatus = builder2.myStatus;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isOnline() {
        return this.myOnline;
    }

    @NotNull
    Status getStatus() {
        return this.myStatus;
    }

    public int hashCode() {
        int hashCode = this.myKey.hashCode();
        hashCode = 31 * hashCode + this.myType.hashCode();
        hashCode = 31 * hashCode + this.myIcon.hashCode();
        hashCode = 31 * hashCode + this.myName.hashCode();
        hashCode = 31 * hashCode + Boolean.hashCode(this.myOnline);
        hashCode = 31 * hashCode + this.myTarget.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myStatus);
        hashCode = 31 * hashCode + this.myAndroidVersion.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myResolution);
        hashCode = 31 * hashCode + this.myDensity;
        hashCode = 31 * hashCode + this.myAbis.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myStorageDevice);
        return hashCode;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof DeviceManagerPairingDevice)) {
            return false;
        }
        DeviceManagerPairingDevice device2 = (DeviceManagerPairingDevice)object;
        return this.myKey.equals(device2.myKey) && this.myType.equals((Object)device2.myType) && this.myIcon.equals(device2.myIcon) && this.myName.equals(device2.myName) && this.myOnline == device2.myOnline && this.myTarget.equals(device2.myTarget) && Objects.equals(this.myStatus, device2.myStatus) && this.myAndroidVersion.equals((Object)device2.myAndroidVersion) && Objects.equals(this.myResolution, device2.myResolution) && this.myDensity == device2.myDensity && this.myAbis.equals(device2.myAbis) && Objects.equals(this.myStorageDevice, device2.myStorageDevice);
    }

    static final class Builder
    extends Device.Builder {
        @Nullable
        private Icon myIcon;
        private boolean myOnline;
        @Nullable
        private Status myStatus;

        Builder() {
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        Builder setType(@NotNull DeviceType type) {
            this.myType = type;
            return this;
        }

        @NotNull
        Builder setIcon(@NotNull Icon icon2) {
            this.myIcon = icon2;
            return this;
        }

        @NotNull
        Builder setName(@NotNull String name2) {
            this.myName = name2;
            return this;
        }

        @NotNull
        Builder setOnline(boolean online) {
            this.myOnline = online;
            return this;
        }

        @NotNull
        Builder setTarget(@NotNull String target2) {
            this.myTarget = target2;
            return this;
        }

        @NotNull
        Builder setStatus(@NotNull Status status2) {
            this.myStatus = status2;
            return this;
        }

        @NotNull
        Builder setAndroidVersion(@NotNull AndroidVersion androidVersion) {
            this.myAndroidVersion = androidVersion;
            return this;
        }

        @Override
        @NotNull
        protected DeviceManagerPairingDevice build() {
            return new DeviceManagerPairingDevice(this);
        }
    }
}

