/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DeviceManagerFutures {
    private DeviceManagerFutures() {
    }

    @NotNull
    public static <V> ListenableFuture<V> appExecutorServiceSubmit(@NotNull Callable<V> callable) {
        return Futures.submit(callable, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public static ListenableFuture<Void> appExecutorServiceSubmit(@NotNull Runnable runnable2) {
        return Futures.submit((Runnable)runnable2, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public static <V> V getDoneOrElse(@NotNull Future<V> future2, @NotNull V defaultValue) {
        assert (future2.isDone());
        try {
            return future2.get();
        }
        catch (CancellationException | ExecutionException exception) {
            return defaultValue;
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)exception);
        }
    }

    @NotNull
    public static <V> ListenableFuture<List<V>> successfulAsList(@NotNull Iterable<ListenableFuture<V>> futures, @NotNull Executor executor2) {
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), DeviceManagerFutures::filterSuccessful, (Executor)executor2);
    }

    @NotNull
    private static <V> List<V> filterSuccessful(@NotNull Collection<V> values) {
        List nonnullValues = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (nonnullValues.size() != values.size()) {
            Logger.getInstance(DeviceManagerFutures.class).warn("Some of the input futures failed");
        }
        return nonnullValues;
    }
}

