/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AvdData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceManagerAndroidDebugBridge {
    @NotNull
    private final GetDebugBridge myGetDebugBridge;

    public DeviceManagerAndroidDebugBridge() {
        this(DeviceManagerAndroidDebugBridge::getDebugBridge);
    }

    @VisibleForTesting
    DeviceManagerAndroidDebugBridge(@NotNull GetDebugBridge getDebugBridge) {
        this.myGetDebugBridge = getDebugBridge;
    }

    @NotNull
    private static ListenableFuture<AndroidDebugBridge> getDebugBridge(@Nullable Project project) {
        ListenableFuture<File> future2 = DeviceManagerFutures.appExecutorServiceSubmit(() -> AndroidSdkUtils.findAdb((Project)project).adbPath);
        return Futures.transformAsync(future2, AdbService.getInstance()::getDebugBridge, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public ListenableFuture<IDevice> findDevice(@Nullable Project project, @NotNull Key key) {
        return Futures.transformAsync(this.getDevices(project), devices2 -> DeviceManagerAndroidDebugBridge.findDevice(devices2, key), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static ListenableFuture<IDevice> findDevice(@NotNull List<IDevice> devices2, @NotNull Key key) {
        Iterable futures = devices2.stream().map(IDevice::getAvdData).collect(Collectors.toList());
        ExecutorService executor2 = AppExecutorUtil.getAppExecutorService();
        return Futures.transform((ListenableFuture)Futures.successfulAsList((Iterable)futures), avds -> DeviceManagerAndroidDebugBridge.findDevice(key, avds, devices2), (Executor)executor2);
    }

    @Nullable
    private static IDevice findDevice(@NotNull Key key, @NotNull List<AvdData> avds, @NotNull List<IDevice> devices2) {
        String string = key.toString();
        int size = avds.size();
        for (int i = 0; i < size; ++i) {
            AvdData avd = avds.get(i);
            if (avd == null || !Objects.equals(avd.getPath(), string)) continue;
            return devices2.get(i);
        }
        return null;
    }

    @UiThread
    @NotNull
    public ListenableFuture<List<IDevice>> getDevices(@Nullable Project project) {
        ExecutorService executor2 = AppExecutorUtil.getAppExecutorService();
        return Futures.transform(this.myGetDebugBridge.apply(project), DeviceManagerAndroidDebugBridge::getDevices, (Executor)executor2);
    }

    @WorkerThread
    @NotNull
    private static List<IDevice> getDevices(@NotNull AndroidDebugBridge bridge) {
        if (!bridge.isConnected()) {
            throw new IllegalArgumentException();
        }
        List<IDevice> devices2 = Arrays.asList(bridge.getDevices());
        if (bridge.hasInitialDeviceList()) {
            Logger.getInstance(DeviceManagerAndroidDebugBridge.class).info(devices2.toString());
        } else {
            Logger.getInstance(DeviceManagerAndroidDebugBridge.class).warn("ADB does not have the initial device list");
        }
        return devices2;
    }

    @UiThread
    public void addDeviceChangeListener(@NotNull AndroidDebugBridge.IDeviceChangeListener listener2) {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener2);
    }

    @UiThread
    public void removeDeviceChangeListener(@NotNull AndroidDebugBridge.IDeviceChangeListener listener2) {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener2);
    }

    @VisibleForTesting
    static interface GetDebugBridge {
        @NotNull
        public ListenableFuture<AndroidDebugBridge> apply(@Nullable Project var1);
    }
}

