/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.sdk.AndroidSdkPathStore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

final class DeviceManagerAction
extends DumbAwareAction {
    DeviceManagerAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event2) {
        Presentation presentation = event2.getPresentation();
        presentation.setVisible(true);
        switch (event2.getPlace()) {
            case "toolbar": {
                presentation.setIcon(null);
                presentation.setText("Add Device Definition...");
                break;
            }
            case "unknown": {
                presentation.setIcon(StudioIcons.Shell.Toolbar.DEVICE_MANAGER);
                presentation.setText("Open Device Manager");
                break;
            }
            default: {
                presentation.setIcon(StudioIcons.Shell.Toolbar.DEVICE_MANAGER);
                presentation.setText("Device Manager");
            }
        }
        presentation.setDescription("Opens the device manager which manages virtual and physical devices");
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(AndroidSdkPathStore.getInstance().getAndroidSdkPath() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        ToolWindow deviceManager = ToolWindowManager.getInstance((Project)project).getToolWindow("Device Manager");
        if (deviceManager != null) {
            deviceManager.show(null);
        }
    }
}

