/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.DetailsPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DetailsPanelPanel
extends JBPanel<DetailsPanelPanel>
implements Disposable {
    @NotNull
    private final JComponent myScrollPane;
    @Nullable
    private Disposable myDetailsPanel;
    @Nullable
    private Splitter mySplitter;

    DetailsPanelPanel(@NotNull JComponent scrollPane2) {
        super((LayoutManager)new BorderLayout());
        this.myScrollPane = scrollPane2;
        this.add(scrollPane2);
    }

    public void dispose() {
        if (this.myDetailsPanel != null) {
            Disposer.dispose((Disposable)this.myDetailsPanel);
        }
    }

    void viewDetails(@NotNull DetailsPanel detailsPanel2) {
        if (this.mySplitter != null) {
            assert (this.myDetailsPanel != null);
            Disposer.dispose((Disposable)this.myDetailsPanel);
            this.myDetailsPanel = detailsPanel2;
            this.mySplitter.setSecondComponent((JComponent)((Object)detailsPanel2));
            return;
        }
        this.myDetailsPanel = detailsPanel2;
        this.remove(this.myScrollPane);
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.getDivider().setBorder(JBUI.Borders.customLineTop((Color)JBColor.border()));
        this.mySplitter.setFirstComponent(this.myScrollPane);
        this.mySplitter.setSecondComponent((JComponent)((Object)detailsPanel2));
        this.add((Component)this.mySplitter);
        this.revalidate();
    }

    public void removeSplitter() {
        this.remove((Component)this.mySplitter);
        this.mySplitter = null;
        assert (this.myDetailsPanel != null);
        Disposer.dispose((Disposable)this.myDetailsPanel);
        this.myDetailsPanel = null;
        this.add(this.myScrollPane);
        this.revalidate();
    }

    @NotNull
    @VisibleForTesting
    Optional<Object> getDetailsPanel() {
        return Optional.ofNullable(this.myDetailsPanel);
    }

    @NotNull
    Optional<Splitter> getSplitter() {
        return Optional.ofNullable(this.mySplitter);
    }
}

