/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.device.explorer.DeviceExplorerService;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.DeviceTable;
import com.android.tools.idea.devicemanager.IconButtonTableCellEditor;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorer;
import com.android.tools.idea.flags.StudioFlags;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActivateDeviceFileExplorerWindowButtonTableCellEditor<D extends Device>
extends IconButtonTableCellEditor {
    private Device myDevice;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DeviceTable<D> myTable;

    public ActivateDeviceFileExplorerWindowButtonTableCellEditor(@Nullable Project project, @NotNull DeviceTable<D> table2, @NotNull DeviceManagerEvent.EventKind kind) {
        super(ActivateDeviceFileExplorerWindowValue.INSTANCE, AllIcons.Actions.MenuOpen, (Boolean)StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get() != false ? "Open this device in the Device Explorer." : "Open this device in the Device File Explorer.");
        this.myProject = project;
        this.myTable = table2;
        this.myButton.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(kind).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            assert (project != null);
            this.openAndShowDeviceLater();
            this.fireEditingCanceled();
        });
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myDevice = this.myTable.getDeviceAt(viewRowIndex);
        return this.myButton;
    }

    private void openAndShowDeviceLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject != null && !this.myProject.isDisposed()) {
                if (this.myDevice instanceof VirtualDevice) {
                    if (((Boolean)StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get()).booleanValue()) {
                        DeviceExplorerService.openAndShowDevice(this.myProject, ((VirtualDevice)this.myDevice).getAvdInfo());
                    } else {
                        DeviceExplorer.openAndShowDevice(this.myProject, ((VirtualDevice)this.myDevice).getAvdInfo());
                    }
                } else if (this.myDevice instanceof PhysicalDevice) {
                    if (((Boolean)StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get()).booleanValue()) {
                        DeviceExplorerService.openAndShowDevice(this.myProject, this.myDevice.getKey().toString());
                    } else {
                        DeviceExplorer.openAndShowDevice(this.myProject, this.myDevice.getKey().toString());
                    }
                } else assert (false);
            }
        });
    }
}

