/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.ui;

import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerPanel;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerView;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewListener;
import com.android.tools.idea.deviceprovisioner.DeviceHandleRenderer;
import com.android.tools.idea.deviceprovisioner.DeviceHandleRendererKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\u0015H\u0002J\b\u0010'\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020\u0015H\u0002J\u0011\u0010)\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0011\u0010+\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewImpl;", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerView;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;", "toolWindowID", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;Ljava/lang/String;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "listeners", "", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewListener;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "panel", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerPanel;", "addListener", "", "listener", "addTab", "tab", "title", "getDeviceCombo", "Ljavax/swing/JComboBox;", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "getTabPane", "Ljavax/swing/JTabbedPane;", "removeListener", "reportError", "message", "t", "", "reportErrorGeneric", "setup", "showActiveDeviceScreen", "showNoDeviceScreen", "showPanel", "trackActiveDeviceChanges", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackDeviceListChanges", "DeviceNameRenderer", "intellij.android.device-explorer"})
public final class DeviceExplorerViewImpl
implements DeviceExplorerView {
    @NotNull
    private final DeviceExplorerModel model;
    @NotNull
    private final String toolWindowID;
    @NotNull
    private final List<DeviceExplorerViewListener> listeners;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final DeviceExplorerPanel panel;

    public DeviceExplorerViewImpl(@NotNull Project project, @NotNull DeviceExplorerModel model2, @NotNull String toolWindowID) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindowID, (String)"toolWindowID");
        this.model = model2;
        this.toolWindowID = toolWindowID;
        this.listeners = new ArrayList();
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        this.panel = new DeviceExplorerPanel();
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.loadingPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void setup() {
        this.loadingPanel.add((Component)this.panel.getComponent(), (Object)"Center");
        this.panel.getDeviceCombo().setRenderer((ListCellRenderer)((Object)new DeviceNameRenderer()));
        this.panel.getDeviceCombo().addActionListener(new ActionListener(this){
            final /* synthetic */ DeviceExplorerViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Object sel = DeviceExplorerViewImpl.access$getPanel$p(this.this$0).getDeviceCombo().getSelectedItem();
                if (sel instanceof DeviceHandle) {
                    DeviceExplorerViewImpl.access$getListeners$p(this.this$0).forEach(new Consumer(sel){
                        final /* synthetic */ Object $sel;
                        {
                            this.$sel = $sel;
                        }

                        public final void accept(DeviceExplorerViewListener it) {
                            Object object = this.$sel;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sel");
                            it.deviceSelected((DeviceHandle)object);
                        }
                    });
                } else {
                    DeviceExplorerViewImpl.access$getListeners$p(this.this$0).forEach((Consumer)setup.2.INSTANCE);
                }
            }
        });
        this.showPanel();
    }

    @Override
    public void addTab(@NotNull JComponent tab, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.panel.getTabPane().addTab(title, tab);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object trackDeviceListChanges(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof trackDeviceListChanges.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerViewImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.trackDeviceListChanges((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                devicesInComboBox = new LinkedHashSet<E>();
                $continuation.label = 1;
                v0 = this.model.getDevices().collect(new FlowCollector(devicesInComboBox, this){
                    final /* synthetic */ Set<DeviceHandle> $devicesInComboBox;
                    final /* synthetic */ DeviceExplorerViewImpl this$0;
                    {
                        this.$devicesInComboBox = $devicesInComboBox;
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object emit(@NotNull List<? extends DeviceHandle> newDevices, @NotNull Continuation<? super Unit> $completion) {
                        void $this$forEach$iv;
                        Iterable iterable = SetsKt.minus(this.$devicesInComboBox, (Iterable)CollectionsKt.toSet((Iterable)newDevices));
                        Set<DeviceHandle> set = this.$devicesInComboBox;
                        DeviceExplorerViewImpl deviceExplorerViewImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            DeviceHandle it = (DeviceHandle)element$iv;
                            boolean bl = false;
                            set.remove(it);
                            DeviceExplorerViewImpl.access$getPanel$p(deviceExplorerViewImpl).getDeviceCombo().removeItem(it);
                        }
                        for (DeviceHandle deviceHandle : newDevices) {
                            if (!this.$devicesInComboBox.add(deviceHandle)) continue;
                            DeviceExplorerViewImpl.access$getPanel$p(this.this$0).getDeviceCombo().addItem(deviceHandle);
                        }
                        DeviceExplorerViewImpl.access$showPanel(this.this$0);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object trackActiveDeviceChanges(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof trackActiveDeviceChanges.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerViewImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.trackActiveDeviceChanges((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.model.getActiveDevice().collect(new FlowCollector(this){
                    final /* synthetic */ DeviceExplorerViewImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @Nullable
                    public final Object emit(@Nullable DeviceHandle it, @NotNull Continuation<? super Unit> $completion) {
                        DeviceExplorerViewImpl.access$getPanel$p(this.this$0).getDeviceCombo().setSelectedItem(it);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void reportErrorGeneric(@NotNull String message2, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.reportError(message2, t);
    }

    private final void reportError(String message2, Throwable t) {
        if (t instanceof CancellationException) {
            return;
        }
        String updatedMessage = t.getMessage() != null ? message2 + ": " + t.getMessage() : message2;
        Notification notification = new Notification(this.toolWindowID, this.toolWindowID, updatedMessage, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(new Runnable(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
            }

            public final void run() {
                Notifications.Bus.notify((Notification)this.$notification);
            }
        });
    }

    private final void showPanel() {
        if (this.panel.getDeviceCombo().getItemCount() == 0) {
            this.showNoDeviceScreen();
        } else {
            this.showActiveDeviceScreen();
        }
    }

    private final void showActiveDeviceScreen() {
        this.panel.showTabs();
    }

    private final void showNoDeviceScreen() {
        this.panel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", AndroidIcons.Explorer.DevicesLineup, false);
    }

    @TestOnly
    @NotNull
    public final JComboBox<DeviceHandle> getDeviceCombo() {
        JComboBox<DeviceHandle> jComboBox = this.panel.getDeviceCombo();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"panel.deviceCombo");
        return jComboBox;
    }

    @TestOnly
    @NotNull
    public final JTabbedPane getTabPane() {
        JTabbedPane jTabbedPane = this.panel.getTabPane();
        Intrinsics.checkNotNullExpressionValue((Object)jTabbedPane, (String)"panel.tabPane");
        return jTabbedPane;
    }

    public static final /* synthetic */ DeviceExplorerPanel access$getPanel$p(DeviceExplorerViewImpl $this) {
        return $this.panel;
    }

    public static final /* synthetic */ List access$getListeners$p(DeviceExplorerViewImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$showPanel(DeviceExplorerViewImpl $this) {
        $this.showPanel();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewImpl$DeviceNameRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.android.device-explorer"})
    private static final class DeviceNameRenderer
    extends ColoredListCellRenderer<DeviceHandle> {
        protected void customizeCellRenderer(@NotNull JList<? extends DeviceHandle> list2, @Nullable DeviceHandle value2, int index2, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value2 == null) {
                this.append("No Connected Devices", SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            ColoredTextContainer coloredTextContainer = (ColoredTextContainer)this;
            ListModel<? extends DeviceHandle> listModel = list2.getModel();
            Intrinsics.checkNotNullExpressionValue(listModel, (String)"list.model");
            DeviceHandleRenderer.renderDevice(coloredTextContainer, value2, DeviceHandleRendererKt.toIterable(listModel));
        }
    }
}

