/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.ui;

import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerPanel {
    private JComboBox myDeviceCombo;
    private JPanel myComponent;
    private JPanel errorPanel;
    private JLabel errorText;
    private JTabbedPane tabPane;

    public DeviceExplorerPanel() {
        this.$$$setupUI$$$();
        this.errorPanel.setBackground(UIUtil.getTreeBackground());
        this.errorText.setFont((Font)AdtUiUtils.EMPTY_TOOL_WINDOW_FONT);
        this.errorText.setForeground(NamedColorUtil.getInactiveTextColor());
    }

    @NotNull
    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComboBox<DeviceHandle> getDeviceCombo() {
        return this.myDeviceCombo;
    }

    @NotNull
    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void showTabs() {
        this.myDeviceCombo.setVisible(true);
        this.tabPane.setVisible(true);
        this.errorPanel.setVisible(false);
        this.errorText.setText("");
    }

    public void showMessageLayer(@NotNull String message2, @Nullable Icon icon2, boolean showDeviceList) {
        this.showMessageLayerWorker(message2, NamedColorUtil.getInactiveTextColor(), icon2, showDeviceList);
    }

    private void showMessageLayerWorker(@NotNull String message2, @NotNull Color color, @Nullable Icon icon2, boolean showDeviceList) {
        this.errorText.setForeground(color);
        this.errorText.setIcon(icon2);
        this.myDeviceCombo.setVisible(showDeviceList);
        String htmlText = String.format("<html><div style='text-align: center;'>%s</div></html>", StringUtil.escapeXml((String)message2));
        this.errorText.setText(htmlText);
        this.errorPanel.setVisible(true);
        this.tabPane.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTabbedPane jTabbedPane;
        JLabel jLabel;
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myComponent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 1, 1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myDeviceCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.errorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setVisible(false);
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(120, 10, 0, 10), null, 0, 0, null, null));
        this.errorText = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setMaximumSize(new Dimension(0, 0));
        jLabel.setMinimumSize(new Dimension(0, 0));
        jLabel.setPreferredSize(new Dimension(0, 0));
        jLabel.setText("");
        jLabel.setVerticalAlignment(1);
        jLabel.setVerticalTextPosition(3);
        jPanel.add((Component)jLabel, "Center");
        this.tabPane = jTabbedPane = new JTabbedPane();
        jPanel4.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

