/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor.ui;

import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorViewListener;
import com.android.tools.idea.device.explorer.monitor.ui.ComponentPopupMenu;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorActionsListener;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorPanel;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorView;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.explorer.monitor.ui.ProcessListTableBuilder;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.DebugMenuItem;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.ForceStopMenuItem;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.KillMenuItem;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.MenuContext;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.RefreshMenuItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\u0016H\u0002J\b\u0010&\u001a\u00020\u0016H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorViewImpl;", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorView;", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorActionsListener;", "model", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorModel;", "table", "Lcom/intellij/ui/table/JBTable;", "(Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorModel;Lcom/intellij/ui/table/JBTable;)V", "listeners", "", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorViewListener;", "numOfSelectedNodes", "", "getNumOfSelectedNodes", "()I", "panel", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorPanel;", "panelComponent", "Ljavax/swing/JComponent;", "getPanelComponent", "()Ljavax/swing/JComponent;", "addListener", "", "listener", "createToolbar", "createToolbarSubSection", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createTreePopupMenu", "debugNodes", "forceStopNodes", "getModelRows", "", "viewRows", "killNodes", "refreshNodes", "removeListener", "setUpTable", "setup", "intellij.android.device-explorer-monitor"})
public final class DeviceMonitorViewImpl
implements DeviceMonitorView,
DeviceMonitorActionsListener {
    @NotNull
    private final JBTable table;
    @NotNull
    private final DeviceMonitorPanel panel;
    @NotNull
    private final List<DeviceMonitorViewListener> listeners;

    public DeviceMonitorViewImpl(@NotNull DeviceMonitorModel model2, @NotNull JBTable table2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
        this.panel = new DeviceMonitorPanel();
        this.listeners = new ArrayList();
    }

    public /* synthetic */ DeviceMonitorViewImpl(DeviceMonitorModel deviceMonitorModel, JBTable jBTable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jBTable = new ProcessListTableBuilder().build(deviceMonitorModel.getTableModel());
        }
        this(deviceMonitorModel, jBTable);
    }

    @Override
    @NotNull
    public JComponent getPanelComponent() {
        JPanel jPanel = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"panel.component");
        return jPanel;
    }

    @Override
    public void setup() {
        this.setUpTable();
        this.createTreePopupMenu();
        this.createToolbar();
    }

    @Override
    public void addListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public int getNumOfSelectedNodes() {
        return this.table.getSelectedRowCount();
    }

    @Override
    public void refreshNodes() {
        this.listeners.forEach(refreshNodes.1.INSTANCE);
    }

    @Override
    public void killNodes() {
        this.listeners.forEach(new Consumer(this){
            final /* synthetic */ DeviceMonitorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(DeviceMonitorViewListener it) {
                int[] nArray = DeviceMonitorViewImpl.access$getTable$p(this.this$0).getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
                it.killNodesInvoked(DeviceMonitorViewImpl.access$getModelRows(this.this$0, nArray));
            }
        });
    }

    @Override
    public void forceStopNodes() {
        this.listeners.forEach(new Consumer(this){
            final /* synthetic */ DeviceMonitorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(DeviceMonitorViewListener it) {
                int[] nArray = DeviceMonitorViewImpl.access$getTable$p(this.this$0).getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
                it.forceStopNodesInvoked(DeviceMonitorViewImpl.access$getModelRows(this.this$0, nArray));
            }
        });
    }

    @Override
    public void debugNodes() {
        this.listeners.forEach(new Consumer(this){
            final /* synthetic */ DeviceMonitorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(DeviceMonitorViewListener it) {
                int[] nArray = DeviceMonitorViewImpl.access$getTable$p(this.this$0).getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
                it.debugNodes(DeviceMonitorViewImpl.access$getModelRows(this.this$0, nArray));
            }
        });
    }

    private final void setUpTable() {
        this.panel.getProcessTablePane().getViewport().add((Component)this.table);
    }

    private final void createTreePopupMenu() {
        ComponentPopupMenu componentPopupMenu;
        ComponentPopupMenu $this$createTreePopupMenu_u24lambda_u240 = componentPopupMenu = new ComponentPopupMenu((JComponent)this.table);
        boolean bl = false;
        $this$createTreePopupMenu_u24lambda_u240.addItem(new KillMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new ForceStopMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new DebugMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.install();
    }

    /*
     * WARNING - void declaration
     */
    private final void createToolbar() {
        void $this$createToolbar_u24lambda_u241;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup();
        DeviceMonitorViewImpl deviceMonitorViewImpl = this;
        boolean bl = false;
        $this$createToolbar_u24lambda_u241.add(new KillMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u241.add(new ForceStopMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u241.add(new DebugMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u241.add(new RefreshMenuItem(this).getAction());
        deviceMonitorViewImpl.createToolbarSubSection(defaultActionGroup);
    }

    private final void createToolbarSubSection(DefaultActionGroup group2) {
        ActionToolbar actionToolbar;
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar $this$createToolbarSubSection_u24lambda_u242 = actionToolbar = actionManager.createActionToolbar("Device Monitor Toolbar", (ActionGroup)group2, true);
        boolean bl = false;
        $this$createToolbarSubSection_u24lambda_u242.setTargetComponent((JComponent)this.panel.getProcessTablePane());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"actionManager.createActi\u2026el.processTablePane\n    }");
        ActionToolbar actionToolbar3 = actionToolbar2;
        this.panel.getToolbar().add((Component)actionToolbar3.getComponent(), "West");
    }

    private final int[] getModelRows(int[] viewRows) {
        int n = 0;
        int n2 = viewRows.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = this.table.convertRowIndexToModel(viewRows[n3]);
        }
        return nArray;
    }

    public static final /* synthetic */ int[] access$getModelRows(DeviceMonitorViewImpl $this, int[] viewRows) {
        return $this.getModelRows(viewRows);
    }

    public static final /* synthetic */ JBTable access$getTable$p(DeviceMonitorViewImpl $this) {
        return $this.table;
    }
}

