/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor.ui;

import com.android.tools.idea.device.explorer.monitor.processes.ProcessInfo;
import com.android.tools.idea.device.explorer.monitor.processes.ProcessInfoKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\rJ\u0014\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J\u0014\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorTableModel;", "Ljavax/swing/table/AbstractTableModel;", "()V", "columns", "", "Ljavax/swing/table/TableColumn;", "rows", "Lcom/android/tools/idea/device/explorer/monitor/processes/ProcessInfo;", "clearProcesses", "", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "", "getRowCount", "getValueAt", "", "rowIndex", "getValueForRow", "removeOldColumnsAndAddColumns", "list", "", "updateProcessRows", "newRows", "ProcessInfoNameComparator", "intellij.android.device-explorer-monitor"})
public final class DeviceMonitorTableModel
extends AbstractTableModel {
    @NotNull
    private final List<ProcessInfo> rows = new ArrayList();
    @NotNull
    private final List<TableColumn> columns = new ArrayList();

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    @NotNull
    public String getColumnName(int columnIndex) {
        Object object = this.columns.get(columnIndex).getHeaderValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return ProcessInfo.class;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex);
    }

    @NotNull
    public final ProcessInfo getValueForRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public final void clearProcesses() {
        int rowsToDelete = this.rows.size();
        if (rowsToDelete > 0) {
            this.rows.clear();
            this.fireTableRowsDeleted(0, rowsToDelete - 1);
        }
    }

    public final void updateProcessRows(@NotNull List<ProcessInfo> newRows) {
        Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
        if (newRows.isEmpty()) {
            this.clearProcesses();
        } else if (this.rows.isEmpty()) {
            this.rows.addAll(CollectionsKt.sortedWith((Iterable)newRows, (Comparator)ProcessInfoNameComparator.INSTANCE));
            this.fireTableRowsInserted(0, this.rows.size() - 1);
        } else {
            List newSortedRows = CollectionsKt.sortedWith((Iterable)newRows, (Comparator)ProcessInfoNameComparator.INSTANCE);
            int currentRowIndex = 0;
            int newRowIndex = 0;
            while (currentRowIndex < this.rows.size() && newRowIndex < newSortedRows.size()) {
                ProcessInfo newProcessInfo;
                ProcessInfo oldProcessInfo = this.rows.get(currentRowIndex);
                if (ProcessInfoNameComparator.INSTANCE.compare(oldProcessInfo, newProcessInfo = (ProcessInfo)newSortedRows.get(newRowIndex)) == 0) {
                    if (!Intrinsics.areEqual((Object)oldProcessInfo, (Object)newProcessInfo)) {
                        this.rows.set(currentRowIndex, (ProcessInfo)newSortedRows.get(newRowIndex));
                        this.fireTableRowsUpdated(currentRowIndex, currentRowIndex);
                    }
                    ++currentRowIndex;
                    ++newRowIndex;
                    continue;
                }
                if (ProcessInfoNameComparator.INSTANCE.compare(oldProcessInfo, newProcessInfo) < 0) {
                    this.rows.remove(currentRowIndex);
                    this.fireTableRowsDeleted(currentRowIndex, currentRowIndex);
                    continue;
                }
                this.rows.add(currentRowIndex, newProcessInfo);
                this.fireTableRowsInserted(currentRowIndex, currentRowIndex);
                ++currentRowIndex;
                ++newRowIndex;
            }
            while (currentRowIndex < this.rows.size()) {
                this.rows.remove(currentRowIndex);
                this.fireTableRowsDeleted(currentRowIndex, currentRowIndex);
            }
            while (newRowIndex < newSortedRows.size()) {
                this.rows.add((ProcessInfo)newSortedRows.get(newRowIndex));
                this.fireTableRowsInserted(newRowIndex, newRowIndex);
                ++newRowIndex;
            }
        }
    }

    public final void removeOldColumnsAndAddColumns(@NotNull List<? extends TableColumn> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.columns.clear();
        this.columns.addAll((Collection<TableColumn>)list2);
        this.fireTableStructureChanged();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0001\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorTableModel$ProcessInfoNameComparator;", "Ljava/util/Comparator;", "Lcom/android/tools/idea/device/explorer/monitor/processes/ProcessInfo;", "Lkotlin/Comparator;", "()V", "compare", "", "p0", "p1", "ProcessInfoNonNullComparator", "intellij.android.device-explorer-monitor"})
    public static final class ProcessInfoNameComparator
    implements Comparator<ProcessInfo> {
        @NotNull
        public static final ProcessInfoNameComparator INSTANCE = new ProcessInfoNameComparator();
        private final /* synthetic */ Comparator<ProcessInfo> $$delegate_0;

        private ProcessInfoNameComparator() {
            this.$$delegate_0 = ComparisonsKt.nullsFirst((Comparator)new ProcessInfoNonNullComparator());
        }

        @Override
        public int compare(@Nullable ProcessInfo p0, @Nullable ProcessInfo p1) {
            return this.$$delegate_0.compare(p0, p1);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorTableModel$ProcessInfoNameComparator$ProcessInfoNonNullComparator;", "Ljava/util/Comparator;", "Lcom/android/tools/idea/device/explorer/monitor/processes/ProcessInfo;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.android.device-explorer-monitor"})
        private static final class ProcessInfoNonNullComparator
        implements Comparator<ProcessInfo> {
            @Override
            public int compare(@NotNull ProcessInfo o1, @NotNull ProcessInfo o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return ProcessInfoKt.isPidOnly(o1) && ProcessInfoKt.isPidOnly(o2) ? Intrinsics.compare((int)o1.getPid(), (int)o2.getPid()) : (ProcessInfoKt.isPidOnly(o1) ? 1 : (ProcessInfoKt.isPidOnly(o2) ? -1 : ProcessInfoKt.getSafeProcessName(o1).compareTo(ProcessInfoKt.getSafeProcessName(o2))));
            }
        }
    }
}

