/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.ui;

import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeUtil {
    @NotNull
    public static Stream<TreeNode> getChildren(@NotNull TreeNode node) {
        final Enumeration<? extends TreeNode> e = node.children();
        return StreamSupport.stream(Spliterators.spliterator(new Iterator<TreeNode>(){

            @Override
            public TreeNode next() {
                return (TreeNode)e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, (long)node.getChildCount(), 16), false);
    }

    @Nullable
    public static <V extends DefaultMutableTreeNode> TreePath getCommonPath(@NotNull List<V> treeNodes) {
        if (treeNodes.isEmpty()) {
            return null;
        }
        TreePath[] paths = (TreePath[])treeNodes.stream().map(DefaultMutableTreeNode::getPath).map(TreePath::new).toArray(TreePath[]::new);
        return TreePathUtil.findCommonAncestor((TreePath[])paths);
    }

    public static int binarySearch(@NotNull TreeNode parent2, @NotNull TreeNode key, @NotNull Comparator<TreeNode> comparator2) {
        return com.intellij.util.ui.tree.TreeUtil.indexedBinarySearch((TreeNode)parent2, (TreeNode)key, comparator2);
    }

    @NotNull
    public static <T extends MutableTreeNode, U> List<T> updateChildrenNodes(@NotNull DefaultTreeModel treeModel, @NotNull T parentNode, @NotNull List<U> newEntries, @NotNull UpdateChildrenOps<T, U> ops) {
        if (newEntries.isEmpty()) {
            TreeUtil.removeAllChildren(parentNode);
            treeModel.nodeStructureChanged(parentNode);
            return new ArrayList();
        }
        if (parentNode.getChildCount() == 0) {
            List nodes2 = ContainerUtil.map(newEntries, ops::mapEntry);
            TreeUtil.removeAllChildren(parentNode);
            TreeUtil.setAllowsChildren(parentNode);
            nodes2.forEach(x -> parentNode.insert((MutableTreeNode)x, parentNode.getChildCount()));
            treeModel.nodeStructureChanged(parentNode);
            return nodes2;
        }
        ArrayList<T> addedNodes = new ArrayList<T>();
        int childIndex = 0;
        int childCount = parentNode.getChildCount();
        int newEntryIndex = 0;
        int newEntryCount = newEntries.size();
        while (newEntryIndex < newEntries.size() || childIndex < parentNode.getChildCount()) {
            assert (childIndex == newEntryIndex);
            if (childIndex >= childCount) {
                T newEntryNode = ops.mapEntry(newEntries.get(newEntryIndex));
                addedNodes.add(newEntryNode);
                TreeUtil.setAllowsChildren(parentNode);
                treeModel.insertNodeInto((MutableTreeNode)newEntryNode, parentNode, childIndex);
                ++newEntryIndex;
                ++childIndex;
                ++childCount;
                continue;
            }
            if (newEntryIndex >= newEntryCount) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            T childNode = ops.getChildNode(parentNode, childIndex);
            if (childNode == null) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            int compareResult = ops.compareNodeWithEntry(childNode, newEntries.get(newEntryIndex));
            if (compareResult == 0) {
                ops.updateNode(childNode, newEntries.get(newEntryIndex));
                treeModel.nodeChanged((TreeNode)childNode);
                ++childIndex;
                ++newEntryIndex;
                continue;
            }
            if (compareResult < 0) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            assert (compareResult > 0);
            int nextIndex = TreeUtil.findIndexOfNextEntry(newEntries, newEntryIndex + 1, childNode, ops);
            assert (nextIndex >= newEntryIndex + 1);
            assert (nextIndex <= newEntries.size());
            while (newEntryIndex < nextIndex) {
                T newChildNode = ops.mapEntry(newEntries.get(newEntryIndex));
                addedNodes.add(newChildNode);
                treeModel.insertNodeInto((MutableTreeNode)newChildNode, parentNode, childIndex);
                ++childIndex;
                ++childCount;
                ++newEntryIndex;
            }
        }
        assert (childIndex == newEntryIndex);
        assert (childCount == newEntryCount);
        return addedNodes;
    }

    private static <T extends MutableTreeNode, U> int findIndexOfNextEntry(@NotNull List<U> entries2, int beginIndex, @NotNull T treeNode, @NotNull UpdateChildrenOps<T, U> ops) {
        for (int i = beginIndex; i < entries2.size(); ++i) {
            if (ops.compareNodeWithEntry(treeNode, entries2.get(i)) > 0) continue;
            return i;
        }
        return entries2.size();
    }

    private static void removeAllChildren(@NotNull MutableTreeNode node) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
    }

    private static void setAllowsChildren(@NotNull MutableTreeNode node) {
        if (node instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)node).setAllowsChildren(true);
        }
    }

    public static interface UpdateChildrenOps<T extends MutableTreeNode, U> {
        @Nullable
        public T getChildNode(@NotNull T var1, int var2);

        @NotNull
        public T mapEntry(@NotNull U var1);

        public int compareNodeWithEntry(@NotNull T var1, @NotNull U var2);

        public void updateNode(@NotNull T var1, @NotNull U var2);
    }
}

