/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.ui;

import com.android.tools.idea.device.explorer.files.DeviceExplorerModelListener;
import com.android.tools.idea.device.explorer.files.DeviceExplorerViewListener;
import com.android.tools.idea.device.explorer.files.DeviceExplorerViewProgressListener;
import com.android.tools.idea.device.explorer.files.DeviceFileEntryNode;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileSystem;
import com.android.tools.idea.device.explorer.files.ui.ComponentPopupMenu;
import com.android.tools.idea.device.explorer.files.ui.DeviceExplorerPanel;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerActionListener;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerViewImpl;
import com.android.tools.idea.device.explorer.files.ui.menu.item.CopyPathMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.DeleteNodesMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.MenuContext;
import com.android.tools.idea.device.explorer.files.ui.menu.item.NewDirectoryMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.NewFileMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.OpenMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.SaveAsMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.SynchronizeNodesMenuItem;
import com.android.tools.idea.device.explorer.files.ui.menu.item.UploadFilesMenuItem;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b*\u0004,258\u0018\u00002\u00020\u0001:\u0002^_B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0011H\u0007J\b\u0010'\u001a\u00020(H\u0007J\n\u0010)\u001a\u0004\u0018\u00010*H\u0007J\u0015\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u000fH\u0007J\u0015\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u0002052\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00106J\r\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020\u0019H\u0002J\u0016\u0010;\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J \u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020D2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020G2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020DH\u0016J \u0010H\u001a\u00020\u00192\u0006\u0010#\u001a\u00020!2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010I\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010J\u001a\u00020\u00192\u0006\u0010F\u001a\u00020G2\u0006\u0010B\u001a\u00020\u0007H\u0016J\u0018\u0010K\u001a\u00020\u00192\u0006\u0010#\u001a\u00020!2\u0006\u0010B\u001a\u00020\u0007H\u0016J\b\u0010L\u001a\u00020\u0019H\u0016J\u0010\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020\u0019H\u0016J\u0010\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020\u0007H\u0016J\u0010\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u00020\u0019H\u0016J\b\u0010W\u001a\u00020\u0019H\u0016J\b\u0010X\u001a\u00020\u0019H\u0002J\b\u0010Y\u001a\u00020\u0019H\u0016J\b\u0010Z\u001a\u00020\u0019H\u0016J\b\u0010[\u001a\u00020\u0019H\u0016J\b\u0010\\\u001a\u00020\u0019H\u0016J\b\u0010]\u001a\u00020\u0019H\u0016R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerView;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;", "toolWindowID", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;Ljava/lang/String;)V", "fileExplorerActionListener", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$DeviceFileExplorerActionListenerImpl;", "listeners", "", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerViewListener;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "panel", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceExplorerPanel;", "progressListeners", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerViewProgressListener;", "treeLoadingCount", "", "treePopupMenu", "Lcom/android/tools/idea/device/explorer/files/ui/ComponentPopupMenu;", "addListener", "", "listener", "addProgressListener", "createToolBar", "createTreePopupMenu", "decrementTreeLoading", "expandNode", "treeNode", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "expandTreeNode", "node", "getComponent", "Ljavax/swing/JComponent;", "getDeviceExplorerPanel", "getFileTree", "Ljavax/swing/JTree;", "getFileTreeActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getKeyListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getKeyListener$1", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getKeyListener$1;", "getLoadingPanel", "getMouseListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getMouseListener$1", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getMouseListener$1;", "getTransferHandler", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTransferHandler$1", "(Lcom/intellij/ui/treeStructure/Tree;)Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTransferHandler$1;", "getTreeWillExpandListener", "com/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTreeWillExpandListener$1", "()Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$getTreeWillExpandListener$1;", "incrementTreeLoading", "openSelectedNodes", "paths", "", "Ljavax/swing/tree/TreePath;", "removeListener", "removeProgressListener", "reportError", "message", "t", "", "reportErrorRelatedToDevice", "fileSystem", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;", "reportErrorRelatedToNode", "reportMessage", "reportMessageRelatedToDevice", "reportMessageRelatedToNode", "setProgressErrorColor", "setProgressIndeterminate", "indeterminate", "", "setProgressOkColor", "setProgressText", "text", "setProgressValue", "fraction", "", "setProgressWarningColor", "setup", "setupPanel", "showNoDeviceScreen", "startProgress", "startTreeBusyIndicator", "stopProgress", "stopTreeBusyIndicator", "DeviceFileExplorerActionListenerImpl", "ModelListener", "intellij.android.device-explorer-files"})
public final class DeviceFileExplorerViewImpl
implements DeviceFileExplorerView {
    @NotNull
    private final String toolWindowID;
    @NotNull
    private final List<DeviceExplorerViewListener> listeners;
    @NotNull
    private final List<DeviceExplorerViewProgressListener> progressListeners;
    @NotNull
    private final DeviceExplorerPanel panel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @Nullable
    private ComponentPopupMenu treePopupMenu;
    private int treeLoadingCount;
    @NotNull
    private DeviceFileExplorerActionListenerImpl fileExplorerActionListener;

    public DeviceFileExplorerViewImpl(@NotNull Project project, @NotNull DeviceFileExplorerModel model2, @NotNull String toolWindowID) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindowID, (String)"toolWindowID");
        this.toolWindowID = toolWindowID;
        this.listeners = new ArrayList();
        this.progressListeners = new ArrayList();
        this.panel = new DeviceExplorerPanel();
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        this.fileExplorerActionListener = new DeviceFileExplorerActionListenerImpl();
        model2.addListener(new ModelListener());
        this.panel.setCancelActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                progressListeners.forEach(1.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.loadingPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void addProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.progressListeners.add(listener2);
    }

    @Override
    public void removeProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.progressListeners.remove(listener2);
    }

    @Override
    public void setup() {
        this.setupPanel();
    }

    @Override
    public void reportErrorRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String messageToReport = t.getMessage() != null ? message2 + ": " + t.getMessage() : message2;
        this.panel.showErrorMessageLayer(messageToReport);
    }

    @Override
    public void reportErrorRelatedToNode(@NotNull DeviceFileEntryNode node, @NotNull String message2, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.reportError(message2, t, this.toolWindowID);
    }

    @Override
    public void reportMessageRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.panel.showMessageLayer(message2);
    }

    @Override
    public void reportMessageRelatedToNode(@NotNull DeviceFileEntryNode node, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.reportMessage(message2, this.toolWindowID);
    }

    @Override
    public void showNoDeviceScreen() {
        this.panel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", AndroidIcons.Explorer.DevicesLineup);
    }

    @Override
    public void startTreeBusyIndicator() {
        this.incrementTreeLoading();
    }

    @Override
    public void stopTreeBusyIndicator() {
        this.decrementTreeLoading();
    }

    @Override
    public void expandNode(@NotNull DeviceFileEntryNode treeNode) {
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        this.panel.getTree().expandPath(new TreePath(treeNode.getPath()));
    }

    @Override
    public void startProgress() {
        this.panel.getProgressPanel().start();
    }

    @Override
    public void setProgressIndeterminate(boolean indeterminate) {
        this.panel.getProgressPanel().setIndeterminate(indeterminate);
    }

    @Override
    public void setProgressValue(double fraction) {
        this.panel.getProgressPanel().setProgress(fraction);
    }

    @Override
    public void setProgressOkColor() {
        this.panel.getProgressPanel().setOkStatusColor();
    }

    @Override
    public void setProgressWarningColor() {
        this.panel.getProgressPanel().setWarningStatusColor();
    }

    @Override
    public void setProgressErrorColor() {
        this.panel.getProgressPanel().setErrorStatusColor();
    }

    @Override
    public void setProgressText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.panel.getProgressPanel().setText(text2);
    }

    @Override
    public void stopProgress() {
        this.panel.getProgressPanel().stop();
    }

    @TestOnly
    @NotNull
    public final JTree getFileTree() {
        Tree tree2 = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"panel.tree");
        return (JTree)tree2;
    }

    @TestOnly
    @Nullable
    public final ActionGroup getFileTreeActionGroup() {
        ComponentPopupMenu componentPopupMenu = this.treePopupMenu;
        return componentPopupMenu != null ? componentPopupMenu.getActionGroup() : null;
    }

    @TestOnly
    @NotNull
    public final JBLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    @TestOnly
    @NotNull
    public final DeviceExplorerPanel getDeviceExplorerPanel() {
        return this.panel;
    }

    private final void reportMessage(String message2, String toolWindowID) {
        Notification notification = new Notification(toolWindowID, toolWindowID, message2, NotificationType.INFORMATION);
        ApplicationManager.getApplication().invokeLater(new Runnable(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
            }

            public final void run() {
                Notifications.Bus.notify((Notification)this.$notification);
            }
        });
    }

    private final void reportError(String message2, Throwable t, String toolWindowID) {
        if (t instanceof CancellationException) {
            return;
        }
        String messageToReport = t.getMessage() != null ? message2 + ": " + t.getMessage() : message2;
        Notification notification = new Notification(toolWindowID, toolWindowID, messageToReport, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(new Runnable(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
            }

            public final void run() {
                Notifications.Bus.notify((Notification)this.$notification);
            }
        });
    }

    private final void setupPanel() {
        this.loadingPanel.add((Component)this.panel.getComponent(), (Object)"Center");
        Tree tree2 = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"panel.tree");
        Tree tree3 = tree2;
        tree3.addTreeWillExpandListener((TreeWillExpandListener)this.getTreeWillExpandListener());
        tree3.addMouseListener((MouseListener)this.getMouseListener(tree3));
        tree3.addKeyListener((KeyListener)this.getKeyListener(tree3));
        tree3.setTransferHandler((TransferHandler)this.getTransferHandler(tree3));
        tree3.setDragEnabled(!GraphicsEnvironment.isHeadless());
        this.createTreePopupMenu();
        this.createToolBar();
    }

    private final getTreeWillExpandListener.1 getTreeWillExpandListener() {
        return new TreeWillExpandListener(this){
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeWillExpand(@NotNull TreeExpansionEvent event2) throws ExpandVetoException {
                block0: {
                    DeviceFileEntryNode node;
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    DeviceFileEntryNode deviceFileEntryNode = node = DeviceFileEntryNode.fromNode(event2.getPath().getLastPathComponent());
                    if (deviceFileEntryNode == null) break block0;
                    DeviceFileEntryNode deviceFileEntryNode2 = deviceFileEntryNode;
                    DeviceFileExplorerViewImpl deviceFileExplorerViewImpl = this.this$0;
                    DeviceFileEntryNode it = deviceFileEntryNode2;
                    boolean bl = false;
                    DeviceFileExplorerViewImpl.access$expandTreeNode(deviceFileExplorerViewImpl, it);
                }
            }

            public void treeWillCollapse(@NotNull TreeExpansionEvent event2) throws ExpandVetoException {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            }
        };
    }

    private final getMouseListener.1 getMouseListener(Tree tree2) {
        return new MouseAdapter(tree2, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    int selRow = this.$tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = this.$tree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1 && selPath != null) {
                        DeviceFileExplorerViewImpl.access$openSelectedNodes(this.this$0, CollectionsKt.listOf((Object)selPath));
                    }
                }
            }
        };
    }

    private final getKeyListener.1 getKeyListener(Tree tree2) {
        return new KeyAdapter(tree2, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                TreePath[] paths;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (10 == e.getKeyCode() && (paths = this.$tree.getSelectionPaths()) != null) {
                    TreePath[] treePathArray = paths;
                    DeviceFileExplorerViewImpl.access$openSelectedNodes(this.this$0, CollectionsKt.listOf((Object[])Arrays.copyOf(treePathArray, treePathArray.length)));
                }
            }
        };
    }

    private final getTransferHandler.1 getTransferHandler(Tree tree2) {
        return new TransferHandler(tree2, this){
            final /* synthetic */ Tree $tree;
            final /* synthetic */ DeviceFileExplorerViewImpl this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)support, (String)"support");
                Transferable t = support.getTransferable();
                List list2 = FileCopyPasteUtil.getFiles((Transferable)t);
                if (list2 == null) {
                    return false;
                }
                List files2 = list2;
                Point point = support.getDropLocation().getDropPoint();
                TreePath treePath = this.$tree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (treePath == null) {
                    return false;
                }
                TreePath treePath2 = treePath;
                DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(treePath2.getLastPathComponent());
                if (node != null && node.getEntry().isDirectory()) {
                    DeviceFileExplorerViewImpl.access$getListeners$p(this.this$0).forEach(new Consumer(node, files2){
                        final /* synthetic */ DeviceFileEntryNode $node;
                        final /* synthetic */ List<Path> $files;
                        {
                            this.$node = $node;
                            this.$files = $files;
                        }

                        public final void accept(DeviceExplorerViewListener it) {
                            it.uploadFilesInvoked(this.$node, this.$files);
                        }
                    });
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public boolean canImport(@NotNull JComponent comp, @NotNull DataFlavor[] transferFlavors) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
                return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])transferFlavors);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void createTreePopupMenu() {
        void $this$createTreePopupMenu_u24lambda_u240;
        ComponentPopupMenu componentPopupMenu;
        ComponentPopupMenu componentPopupMenu2 = componentPopupMenu = new ComponentPopupMenu((JComponent)this.panel.getTree());
        DeviceFileExplorerViewImpl deviceFileExplorerViewImpl = this;
        boolean bl = false;
        ComponentPopupMenu fileMenu = $this$createTreePopupMenu_u24lambda_u240.addPopup("New");
        fileMenu.addItem(new NewFileMenuItem(this.fileExplorerActionListener));
        fileMenu.addItem(new NewDirectoryMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addSeparator();
        $this$createTreePopupMenu_u24lambda_u240.addItem(new OpenMenuItem(this.fileExplorerActionListener));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new SaveAsMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new UploadFilesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new DeleteNodesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addSeparator();
        $this$createTreePopupMenu_u24lambda_u240.addItem(new SynchronizeNodesMenuItem(this.fileExplorerActionListener, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u240.addItem(new CopyPathMenuItem(this.fileExplorerActionListener));
        $this$createTreePopupMenu_u24lambda_u240.install();
        deviceFileExplorerViewImpl.treePopupMenu = componentPopupMenu;
    }

    private final void createToolBar() {
        DefaultActionGroup defaultActionGroup;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup $this$createToolBar_u24lambda_u241 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$createToolBar_u24lambda_u241.add(new NewDirectoryMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u241.add(new SaveAsMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u241.add(new UploadFilesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u241.add(new DeleteNodesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        $this$createToolBar_u24lambda_u241.add(new SynchronizeNodesMenuItem(this.fileExplorerActionListener, MenuContext.Toolbar).getAction());
        DefaultActionGroup actionGroup2 = defaultActionGroup;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Device File Explorer Toolbar", (ActionGroup)actionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"actionManager.createActi\u2026lbar\", actionGroup, true)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this.panel.getTree());
        this.panel.getToolbarPanel().add((Component)actionToolbar2.getComponent(), "West");
    }

    private final void openSelectedNodes(List<? extends TreePath> paths) {
        List nodes2 = paths.stream().map(openSelectedNodes.nodes.1.INSTANCE).filter(openSelectedNodes.nodes.2.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(nodes2, (String)"nodes");
        this.fileExplorerActionListener.openNodes(nodes2);
    }

    private final void expandTreeNode(DeviceFileEntryNode node) {
        this.listeners.forEach(new Consumer(node){
            final /* synthetic */ DeviceFileEntryNode $node;
            {
                this.$node = $node;
            }

            public final void accept(DeviceExplorerViewListener it) {
                it.treeNodeExpanding(this.$node);
            }
        });
    }

    private final void incrementTreeLoading() {
        if (this.treeLoadingCount == 0) {
            this.panel.getTree().setPaintBusy(true);
        }
        int n = this.treeLoadingCount;
        this.treeLoadingCount = n + 1;
    }

    private final void decrementTreeLoading() {
        int n = this.treeLoadingCount;
        this.treeLoadingCount = n + -1;
        if (this.treeLoadingCount == 0) {
            this.panel.getTree().setPaintBusy(false);
        }
    }

    public static final /* synthetic */ void access$openSelectedNodes(DeviceFileExplorerViewImpl $this, List paths) {
        $this.openSelectedNodes(paths);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u0010\u0011\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$DeviceFileExplorerActionListenerImpl;", "Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerActionListener;", "(Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;)V", "selectedNodes", "", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "getSelectedNodes", "()Ljava/util/List;", "copyNodePaths", "", "nodes", "deleteNodes", "newDirectory", "node", "newFile", "openNodes", "saveNodesAs", "synchronizeNodes", "uploadFile", "intellij.android.device-explorer-files"})
    private final class DeviceFileExplorerActionListenerImpl
    implements DeviceFileExplorerActionListener {
        @Override
        @Nullable
        public List<DeviceFileEntryNode> getSelectedNodes() {
            TreePath[] paths = DeviceFileExplorerViewImpl.this.panel.getTree().getSelectionPaths();
            if (paths != null) {
                TreePath[] it = paths;
                boolean bl = false;
                List<DeviceFileEntryNode> nodes2 = Arrays.stream(paths).map(selectedNodes.1.nodes.1.INSTANCE).filter(selectedNodes.1.nodes.2.INSTANCE).collect(Collectors.toList());
                return nodes2.isEmpty() ? null : nodes2;
            }
            return null;
        }

        @Override
        public void copyNodePaths(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(nodes2){
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$nodes = $nodes;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.copyNodePathsInvoked(this.$nodes);
                }
            });
        }

        @Override
        public void openNodes(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(nodes2){
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$nodes = $nodes;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.openNodesInEditorInvoked(this.$nodes);
                }
            });
        }

        @Override
        public void saveNodesAs(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(nodes2){
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$nodes = $nodes;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.saveNodesAsInvoked(this.$nodes);
                }
            });
        }

        @Override
        public void deleteNodes(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(nodes2){
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$nodes = $nodes;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.deleteNodesInvoked(this.$nodes);
                }
            });
        }

        @Override
        public void synchronizeNodes(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(nodes2){
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$nodes = $nodes;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.synchronizeNodesInvoked(this.$nodes);
                }
            });
        }

        @Override
        public void newFile(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(node){
                final /* synthetic */ DeviceFileEntryNode $node;
                {
                    this.$node = $node;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.newFileInvoked(this.$node);
                }
            });
        }

        @Override
        public void newDirectory(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(node){
                final /* synthetic */ DeviceFileEntryNode $node;
                {
                    this.$node = $node;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.newDirectoryInvoked(this.$node);
                }
            });
        }

        @Override
        public void uploadFile(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeviceFileExplorerViewImpl.this.listeners.forEach(new Consumer(node){
                final /* synthetic */ DeviceFileEntryNode $node;
                {
                    this.$node = $node;
                }

                public final void accept(DeviceExplorerViewListener it) {
                    it.uploadFilesInvoked(this.$node);
                }
            });
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl$ModelListener;", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerModelListener;", "(Lcom/android/tools/idea/device/explorer/files/ui/DeviceFileExplorerViewImpl;)V", "setRootFolder", "", "model", "Ljavax/swing/tree/DefaultTreeModel;", "treeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "treeModelChanged", "newTreeModel", "newTreeSelectionModel", "intellij.android.device-explorer-files"})
    private final class ModelListener
    implements DeviceExplorerModelListener {
        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            this.setRootFolder(newTreeModel, newTreeSelectionModel);
        }

        public final void setRootFolder(@Nullable DefaultTreeModel model2, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
            Tree tree2 = DeviceFileExplorerViewImpl.this.panel.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"panel.tree");
            Tree tree3 = tree2;
            tree3.setModel((TreeModel)model2);
            tree3.setSelectionModel((TreeSelectionModel)treeSelectionModel);
            if (model2 != null) {
                DeviceFileExplorerViewImpl.this.panel.showTree();
                DeviceFileEntryNode rootNode = DeviceFileEntryNode.fromNode(model2.getRoot());
                if (rootNode != null) {
                    tree3.setRootVisible(false);
                    DeviceFileExplorerViewImpl.this.expandTreeNode(rootNode);
                } else {
                    tree3.setRootVisible(true);
                }
            }
        }
    }
}

