/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.tools.idea.device.explorer.files.adbimpl.AdbPathUtil;
import org.jetbrains.annotations.NotNull;

public class AdbShellCommandBuilder {
    @NotNull
    private final StringBuilder myCommand = new StringBuilder();
    private boolean mySuRootPrefix;
    private String myRunAsPackage;

    public String toString() {
        return this.build();
    }

    @NotNull
    public String build() {
        if (this.mySuRootPrefix && this.myRunAsPackage != null) {
            throw new IllegalStateException("Either so or run-as are supported, not both.");
        }
        String cmd = this.myCommand.toString();
        if (this.mySuRootPrefix || this.myRunAsPackage != null) {
            cmd = cmd.replaceAll("'", "'\"\\'\"'");
        }
        if (this.mySuRootPrefix) {
            return "su 0 sh -c '" + cmd + "'";
        }
        if (this.myRunAsPackage != null) {
            return "run-as " + this.myRunAsPackage + " sh -c '" + cmd + "'";
        }
        return cmd;
    }

    @NotNull
    public AdbShellCommandBuilder withText(@NotNull String text2) {
        this.myCommand.append(text2);
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withSuRootPrefix() {
        this.mySuRootPrefix = true;
        return this;
    }

    public AdbShellCommandBuilder withRunAs(@NotNull String packageName2) {
        this.myRunAsPackage = packageName2;
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withEscapedPath(@NotNull String path2) {
        this.myCommand.append(AdbPathUtil.getEscapedPath(path2));
        return this;
    }

    @NotNull
    public AdbShellCommandBuilder withDirectoryEscapedPath(@NotNull String path2) {
        if (!((String)(path2 = AdbPathUtil.getEscapedPath((String)path2))).endsWith("/")) {
            path2 = (String)path2 + "/";
        }
        this.myCommand.append((String)path2);
        return this;
    }
}

