/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.ddmlib.FileListingService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AdbPathUtil {
    @NotNull
    public static final String FILE_SEPARATOR = "/";
    @NotNull
    public static final String DEVICE_TEMP_DIRECTORY = "/data/local/tmp";

    @NotNull
    public static String getFileName(@NotNull String path2) {
        return PathUtilRt.getFileName((String)path2);
    }

    @NotNull
    public static String getParentPath(@NotNull String path2) {
        if (StringUtil.isEmpty((String)path2)) {
            return "";
        }
        int end = path2.lastIndexOf(FILE_SEPARATOR);
        if (end == path2.length() - 1) {
            end = path2.lastIndexOf(FILE_SEPARATOR, end - 1);
        }
        switch (end) {
            case -1: {
                return "";
            }
            case 0: {
                return FILE_SEPARATOR;
            }
        }
        return path2.substring(0, end);
    }

    @NotNull
    public static String resolve(@NotNull String basePath, @NotNull String other) {
        if (AdbPathUtil.isEmpty(other)) {
            return basePath;
        }
        if (AdbPathUtil.isAbsolute(other)) {
            return other;
        }
        if (AdbPathUtil.isSuffixed(basePath)) {
            return basePath + other;
        }
        return basePath + FILE_SEPARATOR + other;
    }

    @NotNull
    public static String getEscapedPath(@NotNull String path2) {
        if (FILE_SEPARATOR.equals(path2)) {
            return path2;
        }
        return AdbPathUtil.getSegments(path2).stream().map(x -> FILE_SEPARATOR + FileListingService.FileEntry.escape((String)x)).collect(Collectors.joining());
    }

    @NotNull
    public static List<String> getSegments(@NotNull String path2) {
        if (StringUtil.isEmpty((String)path2) || FILE_SEPARATOR.equals(path2)) {
            return new ArrayList<String>();
        }
        return StringUtil.split((String)path2, (String)FILE_SEPARATOR);
    }

    private static boolean isEmpty(@NotNull String path2) {
        return StringUtil.isEmpty((String)path2);
    }

    private static boolean isAbsolute(@NotNull String path2) {
        return path2.startsWith(FILE_SEPARATOR);
    }

    private static boolean isSuffixed(@NotNull String path2) {
        return path2.endsWith(FILE_SEPARATOR);
    }
}

