/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.ddmlib.FileListingService;
import com.android.tools.idea.device.explorer.files.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.device.explorer.files.adbimpl.AdbPathUtil;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"getName", "", "result", "Ljava/util/regex/MatchResult;", "escaping", "", "processLsOutputLine", "Lcom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingEntry;", "line", "parentEntry", "intellij.android.device-explorer-files"})
@SourceDebugExtension(value={"SMAP\nAdbFileListing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbFileListing.kt\ncom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,184:1\n37#2,2:185\n*S KotlinDebug\n*F\n+ 1 AdbFileListing.kt\ncom/android/tools/idea/device/explorer/files/adbimpl/AdbFileListingKt\n*L\n150#1:185,2\n*E\n"})
public final class AdbFileListingKt {
    /*
     * WARNING - void declaration
     */
    private static final AdbFileListingEntry processLsOutputLine(String line2, boolean escaping, AdbFileListingEntry parentEntry) {
        if (((CharSequence)line2).length() == 0) {
            return null;
        }
        Matcher m = FileListingService.LS_L_PATTERN.matcher(line2);
        if (!m.matches()) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
        String name2 = AdbFileListingKt.getName(m, escaping);
        if (Intrinsics.areEqual((Object)name2, (Object)".") || Intrinsics.areEqual((Object)name2, (Object)"..")) {
            return null;
        }
        String permissions = m.group(1);
        String owner = m.group(2);
        String group2 = m.group(3);
        String size = m.group(4);
        String date = m.group(5);
        String time2 = m.group(6);
        Object info2 = null;
        AdbFileListingEntry.EntryKind objectType = AdbFileListingEntry.EntryKind.OTHER;
        char c = permissions.charAt(0);
        if (c == '-') {
            objectType = AdbFileListingEntry.EntryKind.FILE;
        } else if (c == 'b') {
            objectType = AdbFileListingEntry.EntryKind.BLOCK;
        } else if (c == 'c') {
            objectType = AdbFileListingEntry.EntryKind.CHARACTER;
        } else if (c == 'd') {
            objectType = AdbFileListingEntry.EntryKind.DIRECTORY;
        } else if (c == 'l') {
            objectType = AdbFileListingEntry.EntryKind.SYMBOLIC_LINK;
        } else if (c == 's') {
            objectType = AdbFileListingEntry.EntryKind.SOCKET;
        } else if (c == 'p') {
            objectType = AdbFileListingEntry.EntryKind.FIFO;
        }
        if (objectType == AdbFileListingEntry.EntryKind.SYMBOLIC_LINK) {
            void $this$toTypedArray$iv;
            Object object = name2;
            Regex regex = new Regex("\\s->\\s");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] segments = thisCollection$iv.toArray(new String[0]);
            if (segments.length == 2) {
                name2 = segments[0];
                info2 = segments[1];
            }
            info2 = "-> " + info2;
        }
        String string = AdbPathUtil.resolve(parentEntry.getFullPath(), name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolve(parentEntry.fullPath, name)");
        String path2 = string;
        return new AdbFileListingEntry(path2, objectType, permissions, owner, group2, date, time2, size, (String)info2);
    }

    private static final String getName(MatchResult result2, boolean escaping) {
        String string;
        String name2 = result2.group(7);
        if (escaping) {
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
            string = StringsKt.replace$default((String)name2, (String)"\\", (String)"", (boolean)false, (int)4, null);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
            string = name2;
        }
        return string;
    }

    public static final /* synthetic */ AdbFileListingEntry access$processLsOutputLine(String line2, boolean escaping, AdbFileListingEntry parentEntry) {
        return AdbFileListingKt.processLsOutputLine(line2, escaping, parentEntry);
    }
}

