/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files;

import com.android.tools.idea.device.explorer.files.DeviceExplorerModelListener;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceFileExplorerModel {
    @NotNull
    private final List<DeviceExplorerModelListener> myListeners = new ArrayList<DeviceExplorerModelListener>();
    @NotNull
    private final List<DeviceFileSystem> myDevices = new ArrayList<DeviceFileSystem>();
    @Nullable
    private DeviceFileSystem myActiveDevice;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private DefaultTreeSelectionModel myTreeSelectionModel;

    @NotNull
    public List<DeviceFileSystem> getDevices() {
        return this.myDevices;
    }

    @Nullable
    public DeviceFileSystem getActiveDevice() {
        return this.myActiveDevice;
    }

    public void setActiveDevice(@Nullable DeviceFileSystem activeDevice) {
        this.myActiveDevice = activeDevice;
        this.setActiveDeviceTreeModel(activeDevice, null, null);
    }

    @Nullable
    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myTreeSelectionModel;
    }

    public void addListener(@NotNull DeviceExplorerModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DeviceExplorerModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void setActiveDeviceTreeModel(@Nullable DeviceFileSystem device2, @Nullable DefaultTreeModel treeModel, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        if (!Objects.equals(this.myActiveDevice, device2)) {
            return;
        }
        if (Objects.equals(this.myTreeModel, treeModel)) {
            return;
        }
        this.myTreeModel = treeModel;
        this.myTreeSelectionModel = treeSelectionModel;
        this.myListeners.forEach(x -> x.treeModelChanged(treeModel, treeSelectionModel));
    }
}

