/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.device.explorer.files.CoroutineContextUtilKt;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFilesUtils;
import com.android.tools.idea.device.explorer.files.DeviceExplorerViewListener;
import com.android.tools.idea.device.explorer.files.DeviceFileEntryNode;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerController;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerControllerImpl;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.ErrorNode;
import com.android.tools.idea.device.explorer.files.FileTransferOperationTracker;
import com.android.tools.idea.device.explorer.files.FileTransferSummary;
import com.android.tools.idea.device.explorer.files.FileTransferWorkEstimate;
import com.android.tools.idea.device.explorer.files.FileTransferWorkEstimator;
import com.android.tools.idea.device.explorer.files.FileTransferWorkEstimatorProgress;
import com.android.tools.idea.device.explorer.files.LongRunningOperationTracker;
import com.android.tools.idea.device.explorer.files.MyLoadingNode;
import com.android.tools.idea.device.explorer.files.adbimpl.AdbPathUtil;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileEntry;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileSystem;
import com.android.tools.idea.device.explorer.files.fs.DeviceState;
import com.android.tools.idea.device.explorer.files.fs.DownloadProgress;
import com.android.tools.idea.device.explorer.files.fs.FileTransferProgress;
import com.android.tools.idea.device.explorer.files.ui.TreeUtil;
import com.android.utils.FileUtils;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceExplorerEvent;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.time.TimeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 Q2\u00020\u00012\u00020\u0002:\u0004QRSTB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020'H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u000200H\u0016J\u0006\u00101\u001a\u00020)J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\u0015H\u0002J\b\u00104\u001a\u00020'H\u0002J\b\u00105\u001a\u00020'H\u0002J\u0012\u00106\u001a\u00020'2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0019\u00109\u001a\u00020'2\u0006\u0010:\u001a\u000208H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020'H\u0002J\b\u0010=\u001a\u00020'H\u0016J\u0018\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010B\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0018\u0010C\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010D\u001a\u00020)H\u0002J\u0010\u0010E\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010F\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010G\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0018\u0010H\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010D\u001a\u00020)H\u0002J\u0010\u0010I\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010J\u001a\u00020'2\u0006\u0010K\u001a\u00020LH\u0002J!\u0010M\u001a\u00020'2\u0006\u0010:\u001a\u0002082\u0006\u0010N\u001a\u00020OH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006U"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerController;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;", "view", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerView;", "fileManager", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManager;", "fileOpener", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$FileOpener;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerModel;Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerView;Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManager;Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$FileOpener;)V", "loadingChildren", "", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "loadingChildrenAlarms", "Lcom/intellij/util/Alarm;", "loadingNodesAlarms", "longRunningOperationTracker", "Lcom/android/tools/idea/device/explorer/files/LongRunningOperationTracker;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "", "showLoadingNodeDelayMillis", "getShowLoadingNodeDelayMillis", "()I", "setShowLoadingNodeDelayMillis", "(I)V", "transferringNodeRepaintMillis", "getTransferringNodeRepaintMillis", "setTransferringNodeRepaintMillis", "transferringNodes", "transferringNodesAlarms", "workEstimator", "Lcom/android/tools/idea/device/explorer/files/FileTransferWorkEstimator;", "cancelOrMoveToBackgroundPendingOperations", "", "checkLongRunningOperationAllowed", "", "dispose", "getTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "getTreeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "getViewComponent", "Ljavax/swing/JComponent;", "hasActiveDevice", "registerLongRunningOperation", "tracker", "repaintLoadingChildren", "repaintTransferringNodes", "setActiveConnectedDevice", "fileSystem", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;", "setActiveDevice", "device", "(Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setNoActiveDevice", "setup", "showLoadingNode", "treeModel", "node", "startLoadChildren", "startNodeDownload", "startNodeTransfer", "download", "startNodeUpload", "stopLoadChildren", "stopNodeDownload", "stopNodeTransfer", "stopNodeUpload", "trackAction", "action", "Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;", "updateActiveDeviceState", "state", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceState;", "(Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;Lcom/android/tools/idea/device/explorer/files/fs/DeviceState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "FileOpener", "NodeSorting", "ViewListener", "intellij.android.device-explorer-files"})
@SourceDebugExtension(value={"SMAP\nDeviceFileExplorerControllerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceFileExplorerControllerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1491:1\n10#2:1492\n*S KotlinDebug\n*F\n+ 1 DeviceFileExplorerControllerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl\n*L\n1477#1:1492\n*E\n"})
public final class DeviceFileExplorerControllerImpl
implements Disposable,
DeviceFileExplorerController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DeviceFileExplorerModel model;
    @NotNull
    private final DeviceFileExplorerView view;
    @NotNull
    private final DeviceExplorerFileManager fileManager;
    @NotNull
    private final FileOpener fileOpener;
    @NotNull
    private final CoroutineScope scope;
    private int showLoadingNodeDelayMillis;
    private int transferringNodeRepaintMillis;
    @NotNull
    private final FileTransferWorkEstimator workEstimator;
    @NotNull
    private final Set<DeviceFileEntryNode> transferringNodes;
    @NotNull
    private final Set<DeviceFileEntryNode> loadingChildren;
    @NotNull
    private final Alarm loadingNodesAlarms;
    @NotNull
    private final Alarm transferringNodesAlarms;
    @NotNull
    private final Alarm loadingChildrenAlarms;
    @Nullable
    private LongRunningOperationTracker longRunningOperationTracker;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Key<DeviceFileExplorerControllerImpl> KEY;
    @NotNull
    private static final String DEVICE_EXPLORER_BUSY_MESSAGE = "Device Explorer is busy, please retry later or cancel current operation";
    private static final Duration FILE_ENTRY_CREATION_TIMEOUT;
    private static final Duration FILE_ENTRY_DELETION_TIMEOUT;

    public DeviceFileExplorerControllerImpl(@NotNull Project project, @NotNull DeviceFileExplorerModel model2, @NotNull DeviceFileExplorerView view, @NotNull DeviceExplorerFileManager fileManager, @NotNull FileOpener fileOpener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        Intrinsics.checkNotNullParameter((Object)fileOpener, (String)"fileOpener");
        this.project = project;
        this.model = model2;
        this.view = view;
        this.fileManager = fileManager;
        this.fileOpener = fileOpener;
        CoroutineScope coroutineScope = this.project.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"project.coroutineScope");
        this.scope = CoroutineScopeKt.plus((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()));
        this.showLoadingNodeDelayMillis = 200;
        this.transferringNodeRepaintMillis = 100;
        this.workEstimator = new FileTransferWorkEstimator();
        this.transferringNodes = new HashSet();
        this.loadingChildren = new HashSet();
        this.loadingNodesAlarms = new Alarm();
        this.transferringNodesAlarms = new Alarm();
        this.loadingChildrenAlarms = new Alarm();
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
        this.view.addListener(new ViewListener());
        this.project.putUserData(KEY, (Object)this);
    }

    public final int getShowLoadingNodeDelayMillis() {
        return this.showLoadingNodeDelayMillis;
    }

    @TestOnly
    public final void setShowLoadingNodeDelayMillis(int n) {
        this.showLoadingNodeDelayMillis = n;
    }

    public final int getTransferringNodeRepaintMillis() {
        return this.transferringNodeRepaintMillis;
    }

    @TestOnly
    public final void setTransferringNodeRepaintMillis(int n) {
        this.transferringNodeRepaintMillis = n;
    }

    public void dispose() {
    }

    private final DefaultTreeModel getTreeModel() {
        return this.model.getTreeModel();
    }

    private final DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.model.getTreeSelectionModel();
    }

    private final void setNoActiveDevice() {
        this.cancelOrMoveToBackgroundPendingOperations();
        this.model.setActiveDevice(null);
        this.model.setActiveDeviceTreeModel(null, null, null);
        this.view.showNoDeviceScreen();
    }

    private final Object setActiveDevice(DeviceFileSystem device2, Continuation<? super Unit> $completion) {
        this.cancelOrMoveToBackgroundPendingOperations();
        this.model.setActiveDevice(device2);
        Object object = this.updateActiveDeviceState(device2, device2.getDeviceState(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateActiveDeviceState(DeviceFileSystem var1_1, DeviceState var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof updateActiveDeviceState.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeviceFileExplorerControllerImpl.access$updateActiveDeviceState(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (state != DeviceState.ONLINE) {
                    switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                        case 1: 
                        case 2: {
                            v0 = "Device is pending authentication: please accept debugging session on the device";
                            break;
                        }
                        default: {
                            var6_7 = "Device is not online (%s)";
                            var7_8 = new Object[]{state};
                            v1 = String.format(var6_7, Arrays.copyOf(var7_8, var7_8.length));
                            v0 = v1;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(format, *args)");
                        }
                    }
                    message = v0;
                    this.view.reportMessageRelatedToDevice(device, message);
                    this.model.setActiveDeviceTreeModel(device, null, null);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = device;
                $continuation.label = 1;
                v2 = device.rootDirectory((Continuation<? super DeviceFileEntry>)$continuation);
                ** if (v2 != var10_6) goto lbl36
lbl35:
                // 1 sources

                return var10_6;
lbl36:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                device = (DeviceFileSystem)$continuation.L$1;
                this = (DeviceFileExplorerControllerImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl44:
                    // 2 sources

                    root = (DeviceFileEntry)v2;
                    model = new DefaultTreeModel(new DeviceFileEntryNode(root));
                    this.model.setActiveDeviceTreeModel(device, model, new DefaultTreeSelectionModel());
                }
                catch (Throwable t) {
                    this.model.setActiveDeviceTreeModel(device, null, null);
                    this.view.reportErrorRelatedToDevice(device, "Unable to access root directory of device", t);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void cancelOrMoveToBackgroundPendingOperations() {
        this.loadingNodesAlarms.cancelAllRequests();
        this.loadingChildrenAlarms.cancelAllRequests();
        this.transferringNodesAlarms.cancelAllRequests();
        this.loadingChildren.clear();
        this.transferringNodes.clear();
        if (this.longRunningOperationTracker != null) {
            LongRunningOperationTracker longRunningOperationTracker = this.longRunningOperationTracker;
            Intrinsics.checkNotNull((Object)longRunningOperationTracker);
            if (longRunningOperationTracker.isBackgroundable()) {
                LongRunningOperationTracker longRunningOperationTracker2 = this.longRunningOperationTracker;
                Intrinsics.checkNotNull((Object)longRunningOperationTracker2);
                longRunningOperationTracker2.moveToBackground();
                this.longRunningOperationTracker = null;
            } else {
                LongRunningOperationTracker longRunningOperationTracker3 = this.longRunningOperationTracker;
                Intrinsics.checkNotNull((Object)longRunningOperationTracker3);
                longRunningOperationTracker3.cancel();
            }
        }
    }

    private final void startNodeDownload(DeviceFileEntryNode node) {
        this.startNodeTransfer(node, true);
    }

    private final void startNodeUpload(DeviceFileEntryNode node) {
        this.startNodeTransfer(node, false);
    }

    private final void startNodeTransfer(DeviceFileEntryNode node, boolean download) {
        this.view.startTreeBusyIndicator();
        if (download) {
            node.setDownloading(true);
        } else {
            node.setUploading(true);
        }
        if (this.transferringNodes.isEmpty()) {
            this.transferringNodesAlarms.addRequest(new Runnable(this){
                final /* synthetic */ DeviceFileExplorerControllerImpl $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    DeviceFileExplorerControllerImpl.access$repaintTransferringNodes(this.$tmp0);
                }
            }, this.transferringNodeRepaintMillis);
        }
        this.transferringNodes.add(node);
    }

    private final void stopNodeDownload(DeviceFileEntryNode node) {
        this.stopNodeTransfer(node, true);
    }

    private final void stopNodeUpload(DeviceFileEntryNode node) {
        this.stopNodeTransfer(node, false);
    }

    private final void stopNodeTransfer(DeviceFileEntryNode node, boolean download) {
        this.view.stopTreeBusyIndicator();
        if (download) {
            node.setDownloading(false);
        } else {
            node.setUploading(false);
        }
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        if (defaultTreeModel != null) {
            defaultTreeModel.nodeChanged(node);
        }
        this.transferringNodes.remove(node);
        if (this.transferringNodes.isEmpty()) {
            this.transferringNodesAlarms.cancelAllRequests();
        }
    }

    private final void startLoadChildren(DeviceFileEntryNode node) {
        this.view.startTreeBusyIndicator();
        if (this.loadingChildren.isEmpty()) {
            this.loadingChildrenAlarms.addRequest(new Runnable(this){
                final /* synthetic */ DeviceFileExplorerControllerImpl $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    DeviceFileExplorerControllerImpl.access$repaintLoadingChildren(this.$tmp0);
                }
            }, this.transferringNodeRepaintMillis);
        }
        this.loadingChildren.add(node);
    }

    private final void stopLoadChildren(DeviceFileEntryNode node) {
        this.view.stopTreeBusyIndicator();
        this.loadingChildren.remove(node);
        if (this.loadingChildren.isEmpty()) {
            this.loadingChildrenAlarms.cancelAllRequests();
        }
    }

    public final boolean checkLongRunningOperationAllowed() {
        return this.longRunningOperationTracker == null;
    }

    private final void registerLongRunningOperation(LongRunningOperationTracker tracker) {
        if (!this.checkLongRunningOperationAllowed()) {
            throw new Exception(DEVICE_EXPLORER_BUSY_MESSAGE);
        }
        this.longRunningOperationTracker = tracker;
        Disposer.register((Disposable)tracker, (Disposable)new Disposable(this, tracker){
            final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
            final /* synthetic */ LongRunningOperationTracker $tracker;
            {
                this.this$0 = $receiver;
                this.$tracker = $tracker;
            }

            public final void dispose() {
                boolean bl = ApplicationManager.getApplication().isDispatchThread();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (DeviceFileExplorerControllerImpl.access$getLongRunningOperationTracker$p(this.this$0) == this.$tracker) {
                    DeviceFileExplorerControllerImpl.access$setLongRunningOperationTracker$p(this.this$0, null);
                }
            }
        });
    }

    public final boolean hasActiveDevice() {
        return this.model.getActiveDevice() != null;
    }

    @Override
    public void setup() {
        this.view.setup();
    }

    @Override
    public void setActiveConnectedDevice(@Nullable DeviceFileSystem fileSystem) {
        if (fileSystem == null) {
            this.setNoActiveDevice();
        } else {
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, fileSystem, null){
                int label;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                final /* synthetic */ DeviceFileSystem $fileSystem;
                {
                    this.this$0 = $receiver;
                    this.$fileSystem = $fileSystem;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DeviceFileExplorerControllerImpl.access$setActiveDevice(this.this$0, this.$fileSystem, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    @NotNull
    public JComponent getViewComponent() {
        JComponent jComponent = this.view.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"view.component");
        return jComponent;
    }

    private final void trackAction(DeviceExplorerEvent.Action action2) {
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_EXPLORER).setDeviceExplorerEvent(DeviceExplorerEvent.newBuilder().setAction(action2));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n        .se\u2026tAction(action)\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
    }

    private final void showLoadingNode(DefaultTreeModel treeModel, DeviceFileEntryNode node) {
        node.setAllowsChildren(true);
        MyLoadingNode newChild = new MyLoadingNode(node.getEntry());
        treeModel.insertNodeInto((MutableTreeNode)((Object)newChild), node, node.getChildCount());
    }

    private final void repaintTransferringNodes() {
        for (DeviceFileEntryNode node : this.transferringNodes) {
            node.incTransferringTick();
            DefaultTreeModel defaultTreeModel = this.getTreeModel();
            if (defaultTreeModel == null) continue;
            defaultTreeModel.nodeChanged(node);
        }
        this.transferringNodesAlarms.addRequest(new Runnable(this){
            final /* synthetic */ DeviceFileExplorerControllerImpl $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                DeviceFileExplorerControllerImpl.access$repaintTransferringNodes(this.$tmp0);
            }
        }, this.transferringNodeRepaintMillis);
    }

    private final void repaintLoadingChildren() {
        for (DeviceFileEntryNode child : this.loadingChildren) {
            TreeNode node;
            if (child.getChildCount() == 0 || !((node = child.getFirstChild()) instanceof MyLoadingNode)) continue;
            ((MyLoadingNode)((Object)node)).incTick();
            DefaultTreeModel defaultTreeModel = this.getTreeModel();
            if (defaultTreeModel == null) continue;
            defaultTreeModel.nodeChanged(node);
        }
        this.loadingChildrenAlarms.addRequest(new Runnable(this){
            final /* synthetic */ DeviceFileExplorerControllerImpl $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                DeviceFileExplorerControllerImpl.access$repaintLoadingChildren(this.$tmp0);
            }
        }, this.transferringNodeRepaintMillis);
    }

    @JvmStatic
    @Nullable
    public static final DeviceFileExplorerControllerImpl getProjectController(@Nullable Project project) {
        return Companion.getProjectController(project);
    }

    public static final /* synthetic */ Object access$setActiveDevice(DeviceFileExplorerControllerImpl $this, DeviceFileSystem device2, Continuation $completion) {
        return $this.setActiveDevice(device2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateActiveDeviceState(DeviceFileExplorerControllerImpl $this, DeviceFileSystem device2, DeviceState state2, Continuation $completion) {
        return $this.updateActiveDeviceState(device2, state2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$repaintTransferringNodes(DeviceFileExplorerControllerImpl $this) {
        $this.repaintTransferringNodes();
    }

    public static final /* synthetic */ void access$repaintLoadingChildren(DeviceFileExplorerControllerImpl $this) {
        $this.repaintLoadingChildren();
    }

    public static final /* synthetic */ LongRunningOperationTracker access$getLongRunningOperationTracker$p(DeviceFileExplorerControllerImpl $this) {
        return $this.longRunningOperationTracker;
    }

    public static final /* synthetic */ void access$setLongRunningOperationTracker$p(DeviceFileExplorerControllerImpl $this, LongRunningOperationTracker longRunningOperationTracker) {
        $this.longRunningOperationTracker = longRunningOperationTracker;
    }

    public static final /* synthetic */ DeviceFileExplorerModel access$getModel$p(DeviceFileExplorerControllerImpl $this) {
        return $this.model;
    }

    public static final /* synthetic */ FileOpener access$getFileOpener$p(DeviceFileExplorerControllerImpl $this) {
        return $this.fileOpener;
    }

    public static final /* synthetic */ DeviceExplorerFileManager access$getFileManager$p(DeviceFileExplorerControllerImpl $this) {
        return $this.fileManager;
    }

    public static final /* synthetic */ void access$registerLongRunningOperation(DeviceFileExplorerControllerImpl $this, LongRunningOperationTracker tracker) {
        $this.registerLongRunningOperation(tracker);
    }

    public static final /* synthetic */ FileTransferWorkEstimator access$getWorkEstimator$p(DeviceFileExplorerControllerImpl $this) {
        return $this.workEstimator;
    }

    public static final /* synthetic */ Duration access$getFILE_ENTRY_DELETION_TIMEOUT$cp() {
        return FILE_ENTRY_DELETION_TIMEOUT;
    }

    public static final /* synthetic */ DefaultTreeModel access$getTreeModel(DeviceFileExplorerControllerImpl $this) {
        return $this.getTreeModel();
    }

    public static final /* synthetic */ Duration access$getFILE_ENTRY_CREATION_TIMEOUT$cp() {
        return FILE_ENTRY_CREATION_TIMEOUT;
    }

    public static final /* synthetic */ void access$startNodeUpload(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.startNodeUpload(node);
    }

    public static final /* synthetic */ void access$stopNodeUpload(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.stopNodeUpload(node);
    }

    public static final /* synthetic */ void access$startNodeDownload(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.startNodeDownload(node);
    }

    public static final /* synthetic */ void access$stopNodeDownload(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.stopNodeDownload(node);
    }

    public static final /* synthetic */ DefaultTreeSelectionModel access$getTreeSelectionModel(DeviceFileExplorerControllerImpl $this) {
        return $this.getTreeSelectionModel();
    }

    public static final /* synthetic */ void access$showLoadingNode(DeviceFileExplorerControllerImpl $this, DefaultTreeModel treeModel, DeviceFileEntryNode node) {
        $this.showLoadingNode(treeModel, node);
    }

    public static final /* synthetic */ Alarm access$getLoadingNodesAlarms$p(DeviceFileExplorerControllerImpl $this) {
        return $this.loadingNodesAlarms;
    }

    public static final /* synthetic */ void access$startLoadChildren(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.startLoadChildren(node);
    }

    public static final /* synthetic */ void access$stopLoadChildren(DeviceFileExplorerControllerImpl $this, DeviceFileEntryNode node) {
        $this.stopLoadChildren(node);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DeviceFileExplorerControllerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOGGER = logger2;
        Key key = Key.create((String)DeviceFileExplorerControllerImpl.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<DeviceFileExplore\u2026pl::class.java.name\n    )");
        KEY = key;
        FILE_ENTRY_CREATION_TIMEOUT = Duration.ofMillis(10000L);
        FILE_ENTRY_DELETION_TIMEOUT = Duration.ofMillis(10000L);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$Companion;", "", "()V", "DEVICE_EXPLORER_BUSY_MESSAGE", "", "FILE_ENTRY_CREATION_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "FILE_ENTRY_DELETION_TIMEOUT", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl;", "Lorg/jetbrains/annotations/NotNull;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getProjectController", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.device-explorer-files"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final DeviceFileExplorerControllerImpl getProjectController(@Nullable Project project) {
            Project project2 = project;
            return project2 != null ? (DeviceFileExplorerControllerImpl)project2.getUserData(KEY) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0019\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$FileOpener;", "", "openFile", "", "localPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.device-explorer-files"})
    public static interface FileOpener {
        @UiThread
        @Nullable
        public Object openFile(@NotNull Path var1, @NotNull Continuation<? super Unit> var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$NodeSorting;", "", "()V", "CompareCaseInsensitive", "CustomComparator", "EntryNodeComparator", "TreeNodeComparator", "intellij.android.device-explorer-files"})
    @VisibleForTesting
    public static final class NodeSorting {
        @NotNull
        public static final NodeSorting INSTANCE = new NodeSorting();

        private NodeSorting() {
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$NodeSorting$CompareCaseInsensitive;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.android.device-explorer-files"})
        public static final class CompareCaseInsensitive
        implements Comparator<String> {
            @NotNull
            public static final CompareCaseInsensitive INSTANCE = new CompareCaseInsensitive();

            private CompareCaseInsensitive() {
            }

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return StringUtil.compare((String)o1, (String)o2, (boolean)true);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002j\n\u0012\u0006\u0012\u0004\u0018\u0001H\u0001`\u0003B-\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u00002\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$NodeSorting$CustomComparator;", "V", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "nameProvider", "Lkotlin/Function1;", "", "isDirectory", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "compare", "", "p0", "p1", "(Ljava/lang/Object;Ljava/lang/Object;)I", "intellij.android.device-explorer-files"})
        public static final class CustomComparator<V>
        implements Comparator<V> {
            private final /* synthetic */ Comparator<V> $$delegate_0;

            public CustomComparator(@NotNull Function1<? super V, String> nameProvider, @NotNull Function1<? super V, Boolean> isDirectory) {
                Intrinsics.checkNotNullParameter(nameProvider, (String)"nameProvider");
                Intrinsics.checkNotNullParameter(isDirectory, (String)"isDirectory");
                Comparator comparator2 = ((Comparator)new Comparator(isDirectory){
                    final /* synthetic */ Function1 $isDirectory$inlined;
                    {
                        this.$isDirectory$inlined = function1;
                    }

                    public final int compare(T a, T b) {
                        T it = b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)this.$isDirectory$inlined.invoke(it);
                        it = a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)this.$isDirectory$inlined.invoke(it)));
                    }
                }).thenComparing(new Function(nameProvider){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                }, CompareCaseInsensitive.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"compareByDescending<V> {\u2026, CompareCaseInsensitive)");
                this.$$delegate_0 = ComparisonsKt.nullsFirst(comparator2);
            }

            @Override
            public int compare(@Nullable V p0, @Nullable V p1) {
                return this.$$delegate_0.compare(p0, p1);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0001\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$NodeSorting$EntryNodeComparator;", "Ljava/util/Comparator;", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "Lkotlin/Comparator;", "()V", "compare", "", "p0", "p1", "intellij.android.device-explorer-files"})
        public static final class EntryNodeComparator
        implements Comparator<DeviceFileEntryNode> {
            @NotNull
            public static final EntryNodeComparator INSTANCE = new EntryNodeComparator();
            private final /* synthetic */ CustomComparator<DeviceFileEntryNode> $$delegate_0;

            private EntryNodeComparator() {
                this.$$delegate_0 = new CustomComparator(1.INSTANCE, 2.INSTANCE);
            }

            @Override
            public int compare(@Nullable DeviceFileEntryNode p0, @Nullable DeviceFileEntryNode p1) {
                return this.$$delegate_0.compare(p0, p1);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$NodeSorting$TreeNodeComparator;", "Ljava/util/Comparator;", "Ljavax/swing/tree/TreeNode;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.android.device-explorer-files"})
        public static final class TreeNodeComparator
        implements Comparator<TreeNode> {
            @NotNull
            public static final TreeNodeComparator INSTANCE = new TreeNodeComparator();

            private TreeNodeComparator() {
            }

            @Override
            public int compare(@NotNull TreeNode o1, @NotNull TreeNode o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return o1 instanceof DeviceFileEntryNode && o2 instanceof DeviceFileEntryNode ? EntryNodeComparator.INSTANCE.compare((DeviceFileEntryNode)o1, (DeviceFileEntryNode)o2) : (o1 instanceof DeviceFileEntryNode ? 1 : (o2 instanceof DeviceFileEntryNode ? -1 : 0));
            }
        }
    }

    @UiThread
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0083\u0004\u0018\u00002\u00020\u0001:\u0002\u0083\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ'\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0019\u0010#\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J)\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0019\u0010(\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J)\u0010)\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J)\u0010+\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J)\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u001a\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u001cH\u0002J\u0016\u00101\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u001cH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010-\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0019\u00106\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u000bH\u0016J\u0010\u00109\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u000bH\u0016Jq\u0010:\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u001c2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0@2\"\u0010A\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070C\u0012\u0006\u0012\u0004\u0018\u00010D0BH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010EJ!\u0010F\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0016\u0010H\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J'\u0010I\u001a\u00020\u00072\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010K\u001a\u00020LH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ\u0016\u0010N\u001a\u00020\u00072\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eH\u0002J(\u0010P\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u001cH\u0002J\u0018\u0010U\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020RH\u0002J\u0018\u0010V\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020RH\u0002J.\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020[2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020[0^H\u0002J+\u0010_\u001a\u00020\u00072\u0006\u0010X\u001a\u00020Y2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020[0a2\u0006\u0010b\u001a\u00020cH\u0002\u00a2\u0006\u0002\u0010dJ'\u0010e\u001a\u00020R2\u0006\u0010f\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010gJ\u0016\u0010h\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0019\u0010i\u001a\u00020R2\u0006\u0010\u0016\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010l\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0010\u0010m\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000bH\u0016J,\u0010n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010K\u001a\u00020L2\u0006\u0010b\u001a\u00020\u000b2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000eH\u0002J)\u0010p\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020r2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010sJ)\u0010t\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020r2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010sJ\u0010\u0010u\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u001e\u0010u\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0016J)\u0010v\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020r2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010sJ/\u0010w\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020r0\u000e2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010xJ/\u0010y\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020r0\u000e2\u0006\u0010z\u001a\u00020{H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010|Jd\u0010}\u001a\u00020R2\"\u0010~\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070C\u0012\u0006\u0012\u0004\u0018\u00010D0B2\"\u0010\u007f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070C\u0012\u0006\u0012\u0004\u0018\u00010D0B2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0082\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0084\u0001"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$ViewListener;", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerViewListener;", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl;)V", "actualCause", "", "error", "addDownloadOperationWork", "", "tracker", "Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;", "entryNode", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "(Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entryNodes", "", "(Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addUploadOperationWork", "path", "Ljava/nio/file/Path;", "(Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "files", "chooseSaveAsDirectoryPath", "treeNode", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chooseSaveAsFilePath", "copyNodePathsInvoked", "treeNodes", "createDeleteConfirmationMessage", "", "filesToDelete", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileEntry;", "createFileTransferEstimatorProgress", "Lcom/android/tools/idea/device/explorer/files/FileTransferWorkEstimatorProgress;", "deleteNodesInvoked", "nodes", "downloadAndOpenFile", "downloadFileEntry", "", "localPath", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/nio/file/Path;Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadFileEntryToDefaultLocation", "downloadSingleDirectory", "localDirectoryPath", "downloadSingleFile", "downloadSingleNode", "node", "findDeviceFileEntryNodeFromPath", "root", "entryFullPath", "getCommonParentNode", "getTreeNodeFromEntry", "getTreeNodeRoot", "Ljavax/swing/tree/TreeNode;", "getUserFacingNodeName", "loadNodeChildren", "newDirectoryInvoked", "parentTreeNode", "newFileInvoked", "newFileOrDirectory", "initialName", "title", "prompt", "emptyErrorMessage", "errorMessage", "Lkotlin/Function1;", "createFunction", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openFile", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openNodesInEditorInvoked", "querySymbolicLinks", "symlinkNodes", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "(Ljava/util/List;Ljavax/swing/tree/DefaultTreeModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportDeletionProblem", "problems", "reportFileTransferSummary", "summary", "Lcom/android/tools/idea/device/explorer/files/FileTransferSummary;", "pastParticiple", "presentParticiple", "reportSaveNodesAsSummary", "reportUploadFilesSummary", "restorePathSelection", "treeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "parentPath", "Ljavax/swing/tree/TreePath;", "oldPath", "selections", "", "restoreTreeSelection", "oldSelections", "", "parentNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "(Ljavax/swing/tree/DefaultTreeSelectionModel;[Ljavax/swing/tree/TreePath;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "saveMultiNodesAs", "commonParentNode", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveNodesAsInvoked", "saveSingleNodeAs", "showErrorMessage", "message", "synchronizeNodesInvoked", "treeNodeExpanding", "updateChildrenNodes", "newEntries", "uploadDirectory", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadFile", "uploadFilesInvoked", "uploadVirtualFile", "uploadVirtualFiles", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/util/List;Lcom/android/tools/idea/device/explorer/files/FileTransferOperationTracker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadVirtualFilesInvoked", "action", "Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wrapFileTransfer", "prepareTransfer", "performTransfer", "backgroundable", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "UploadFileState", "intellij.android.device-explorer-files"})
    @SourceDebugExtension(value={"SMAP\nDeviceFileExplorerControllerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceFileExplorerControllerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$ViewListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1491:1\n1851#2,2:1492\n1851#2,2:1494\n1549#2:1496\n1620#2,3:1497\n1603#2,9:1500\n1851#2:1509\n1852#2:1511\n1612#2:1512\n1360#2:1513\n1446#2,5:1514\n1549#2:1519\n1620#2,3:1520\n1002#2,2:1523\n1743#2,3:1525\n1743#2,3:1528\n1603#2,9:1531\n1851#2:1540\n1852#2:1542\n1612#2:1543\n1851#2,2:1544\n1603#2,9:1549\n1851#2:1558\n1852#2:1560\n1612#2:1561\n766#2:1562\n857#2,2:1563\n1549#2:1565\n1620#2,3:1566\n766#2:1569\n857#2,2:1570\n1#3:1510\n1#3:1541\n1#3:1559\n3792#4:1546\n4307#4,2:1547\n*S KotlinDebug\n*F\n+ 1 DeviceFileExplorerControllerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$ViewListener\n*L\n453#1:1492,2\n465#1:1494,2\n551#1:1496\n551#1:1497,3\n576#1:1500,9\n576#1:1509\n576#1:1511\n576#1:1512\n585#1:1513\n585#1:1514,5\n630#1:1519\n630#1:1520,3\n642#1:1523,2\n708#1:1525,3\n709#1:1528,3\n822#1:1531,9\n822#1:1540\n822#1:1542\n822#1:1543\n857#1:1544,2\n1063#1:1549,9\n1063#1:1558\n1063#1:1560\n1063#1:1561\n1236#1:1562\n1236#1:1563,2\n1237#1:1565\n1237#1:1566,3\n1253#1:1569\n1253#1:1570,2\n576#1:1510\n822#1:1541\n1063#1:1559\n921#1:1546\n921#1:1547,2\n*E\n"})
    private final class ViewListener
    implements DeviceExplorerViewListener {
        public void openNodesInEditorInvoked(@NotNull List<? extends DeviceFileEntryNode> treeNodes) {
            Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
            if (treeNodes.isEmpty()) {
                return;
            }
            if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(this.getCommonParentNode(treeNodes), DeviceFileExplorerControllerImpl.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceFileExplorerControllerImpl.this, treeNodes, this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                final /* synthetic */ List<DeviceFileEntryNode> $treeNodes;
                final /* synthetic */ ViewListener this$1;
                {
                    this.this$0 = $receiver;
                    this.$treeNodes = $treeNodes;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            device = DeviceFileExplorerControllerImpl.access$getModel$p(this.this$0).getActiveDevice();
                            var3_4 = this.$treeNodes.iterator();
lbl7:
                            // 6 sources

                            while (var3_4.hasNext()) {
                                treeNode = var3_4.next();
                                if (!Intrinsics.areEqual((Object)device, (Object)DeviceFileExplorerControllerImpl.access$getModel$p(this.this$0).getActiveDevice()) || treeNode.getEntry().isDirectory()) continue;
                                if (treeNode.isTransferring()) {
                                    DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).reportErrorRelatedToNode(treeNode, "Entry is already downloading or uploading", new RuntimeException());
                                    continue;
                                }
                                this.L$0 = device;
                                this.L$1 = var3_4;
                                this.L$2 = treeNode;
                                this.label = 1;
                                v0 = treeNode.getEntry().isSymbolicLinkToDirectory((Continuation<? super Boolean>)((Continuation)this));
                                if (v0 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl28
                            }
                            break;
                        }
                        case 1: {
                            treeNode = (DeviceFileEntryNode)this.L$2;
                            var3_4 = (Iterator)this.L$1;
                            device = (DeviceFileSystem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl28:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) ** GOTO lbl7
                            this.L$0 = device;
                            this.L$1 = var3_4;
                            this.L$2 = null;
                            this.label = 2;
                            v1 = ViewListener.access$downloadAndOpenFile(this.this$1, treeNode, (Continuation)this);
                            if (v1 != var5_2) ** GOTO lbl7
                            return var5_2;
                        }
                        case 2: {
                            var3_4 = (Iterator<DeviceFileEntryNode>)this.L$1;
                            device = (DeviceFileSystem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object openFile(DeviceFileEntryNode var1_1, Path var2_2, Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof openFile.1)) ** GOTO lbl-1000
            var6_4 = var3_3;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$openFile(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.L$1 = treeNode;
                    $continuation.L$2 = localPath;
                    $continuation.label = 1;
                    v0 = DeviceFileExplorerControllerImpl.access$getFileOpener$p(DeviceFileExplorerControllerImpl.this).openFile(localPath, (Continuation<? super Unit>)$continuation);
                    ** if (v0 != var7_6) goto lbl21
lbl20:
                    // 1 sources

                    return var7_6;
lbl21:
                    // 1 sources

                    ** GOTO lbl33
                }
                case 1: {
                    localPath = (Path)$continuation.L$2;
                    treeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                    }
                    catch (Throwable t) {
                        DeviceFileExplorerControllerImpl.access$getView$p(DeviceFileExplorerControllerImpl.this).reportErrorRelatedToNode(treeNode, "Unable to open file \"" + localPath + "\" in editor", t);
                    }
lbl33:
                    // 3 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object downloadAndOpenFile(DeviceFileEntryNode treeNode, Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, treeNode, DeviceFileExplorerControllerImpl.this, null){
                Object L$0;
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = ViewListener.access$downloadFileEntryToDefaultLocation(this.this$0, this.$treeNode, (Continuation)this);
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            path = (Path)v0;
                            this.L$0 = path;
                            this.label = 2;
                            v1 = DeviceExplorerFilesUtils.INSTANCE.findFile(path, (Continuation<? super VirtualFile>)((Continuation)this));
                            ** if (v1 != var3_2) goto lbl23
lbl22:
                            // 1 sources

                            return var3_2;
lbl23:
                            // 1 sources

                            ** GOTO lbl30
                        }
                        case 2: {
                            path = (Path)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            this.L$0 = null;
                            this.label = 3;
                            v2 = ViewListener.access$openFile(this.this$0, this.$treeNode, path, (Continuation)this);
                            ** if (v2 != var3_2) goto lbl35
lbl34:
                            // 1 sources

                            return var3_2;
lbl35:
                            // 1 sources

                            ** GOTO lbl44
                        }
                        case 3: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
                            }
                            catch (Throwable t) {
                                DeviceFileExplorerControllerImpl.access$getView$p(this.this$1).reportErrorRelatedToNode(this.$treeNode, "Error opening contents of device file " + ViewListener.access$getUserFacingNodeName(this.this$0, this.$treeNode), t);
                            }
lbl44:
                            // 3 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private final DeviceFileEntryNode getTreeNodeFromEntry(DeviceFileEntryNode treeNode, String entryFullPath) {
            TreeNode treeNode2 = this.getTreeNodeRoot(treeNode);
            DeviceFileEntryNode deviceFileEntryNode = treeNode2 instanceof DeviceFileEntryNode ? (DeviceFileEntryNode)treeNode2 : null;
            if (deviceFileEntryNode == null) {
                return null;
            }
            DeviceFileEntryNode treeNodeRoot = deviceFileEntryNode;
            return this.findDeviceFileEntryNodeFromPath(treeNodeRoot, entryFullPath);
        }

        private final TreeNode getTreeNodeRoot(TreeNode node) {
            TreeNode node2 = node;
            while (node2.getParent() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)node2.getParent(), (String)"node.parent");
            }
            return node2;
        }

        private final DeviceFileEntryNode findDeviceFileEntryNodeFromPath(DeviceFileEntryNode root, String entryFullPath) {
            List<String> list2 = AdbPathUtil.getSegments(entryFullPath);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSegments(entryFullPath)");
            List<String> pathComponents = list2;
            if (pathComponents.isEmpty()) {
                return root;
            }
            DeviceFileEntryNode currentNode = root;
            for (String segment : pathComponents) {
                if (currentNode.findChildEntry(segment) != null) continue;
                return null;
            }
            return currentNode;
        }

        /*
         * Unable to fully structure code
         */
        private final Object downloadFileEntryToDefaultLocation(DeviceFileEntryNode var1_1, Continuation<? super Path> var2_2) {
            if (!(var2_2 instanceof downloadFileEntryToDefaultLocation.1)) ** GOTO lbl-1000
            var5_3 = var2_2;
            if ((var5_3.label & -2147483648) != 0) {
                var5_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$downloadFileEntryToDefaultLocation(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = DeviceFileExplorerControllerImpl.access$getFileManager$p(DeviceFileExplorerControllerImpl.this);
                    v1 = treeNode.getEntry();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"treeNode.entry");
                    localPath = v0.getDefaultLocalPathForEntry(v1);
                    $continuation.L$0 = localPath;
                    $continuation.label = 1;
                    v2 = this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, (DeviceFileEntryNode)treeNode, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ ViewListener this$0;
                        final /* synthetic */ DeviceFileEntryNode $treeNode;
                        {
                            this.this$0 = $receiver;
                            this.$treeNode = $treeNode;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                                    this.label = 1;
                                    Object object3 = this.this$0.addDownloadOperationWork(tracker, this.$treeNode, (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, (DeviceFileEntryNode)treeNode, localPath, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ ViewListener this$0;
                        final /* synthetic */ DeviceFileEntryNode $treeNode;
                        final /* synthetic */ Path $localPath;
                        {
                            this.this$0 = $receiver;
                            this.$treeNode = $treeNode;
                            this.$localPath = $localPath;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                                    this.label = 1;
                                    Object object3 = ViewListener.access$downloadFileEntry(this.this$0, this.$treeNode, this.$localPath, tracker, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), true, (Continuation<? super FileTransferSummary>)$continuation);
                    if (v2 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    localPath = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl26:
                    // 2 sources

                    return localPath;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public void saveNodesAsInvoked(@NotNull List<? extends DeviceFileEntryNode> treeNodes) {
            Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
            if (treeNodes.isEmpty()) {
                return;
            }
            DeviceFileEntryNode commonParentNode = this.getCommonParentNode(treeNodes);
            if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(commonParentNode, DeviceFileExplorerControllerImpl.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(treeNodes, this, commonParentNode, DeviceFileExplorerControllerImpl.this, null){
                int label;
                final /* synthetic */ List<DeviceFileEntryNode> $treeNodes;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $commonParentNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                {
                    this.$treeNodes = $treeNodes;
                    this.this$0 = $receiver;
                    this.$commonParentNode = $commonParentNode;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void reportSaveNodesAsSummary(DeviceFileEntryNode node, FileTransferSummary summary) {
            this.reportFileTransferSummary(node, summary, "downloaded", "downloading");
        }

        /*
         * Unable to fully structure code
         */
        private final Object saveSingleNodeAs(DeviceFileEntryNode var1_1, Continuation<? super FileTransferSummary> var2_2) {
            if (!(var2_2 instanceof saveSingleNodeAs.1)) ** GOTO lbl-1000
            var5_3 = var2_2;
            if ((var5_3.label & -2147483648) != 0) {
                var5_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$saveSingleNodeAs(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!treeNode.getEntry().isDirectory() && !treeNode.isSymbolicLinkToDirectory()) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = treeNode;
                    $continuation.label = 1;
                    v0 = this.chooseSaveAsDirectoryPath(treeNode, (Continuation<? super Path>)$continuation);
                    if (v0 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    treeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    v1 = (Path)v0;
                    if (v1 != null) break;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v2 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v2 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl37
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl37:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            localDirectory = v1;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.label = 3;
            v3 = this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, treeNode, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                            this.label = 1;
                            Object object3 = this.this$0.addDownloadOperationWork(tracker, this.$treeNode, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, treeNode, localDirectory, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ Path $localDirectory;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.$localDirectory = $localDirectory;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                            this.label = 1;
                            Object object3 = ViewListener.access$downloadSingleDirectory(this.this$0, this.$treeNode, this.$localDirectory, tracker, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), false, (Continuation<? super FileTransferSummary>)$continuation);
            if (v3 == var6_5) {
                return var6_5;
            }
            ** GOTO lbl49
            {
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl49:
                    // 2 sources

                    return v3;
                }
            }
            $continuation.L$0 = this;
            $continuation.L$1 = treeNode;
            $continuation.label = 4;
            v4 = this.chooseSaveAsFilePath(treeNode, (Continuation<? super Path>)$continuation);
            if (v4 == var6_5) {
                return var6_5;
            }
            ** GOTO lbl62
            {
                case 4: {
                    treeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl62:
                    // 2 sources

                    v5 = (Path)v4;
                    if (v5 != null) break;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 5;
                    v6 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v6 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl74
                }
                case 5: {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl74:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            localFile = v5;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.label = 6;
            v7 = this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, treeNode, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                            this.label = 1;
                            Object object3 = this.this$0.addDownloadOperationWork(tracker, this.$treeNode, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, treeNode, localFile, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ Path $localFile;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.$localFile = $localFile;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                            this.label = 1;
                            Object object3 = ViewListener.access$downloadSingleFile(this.this$0, this.$treeNode, this.$localFile, tracker, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), false, (Continuation<? super FileTransferSummary>)$continuation);
            if (v7 == var6_5) {
                return var6_5;
            }
            ** GOTO lbl86
            {
                case 6: {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl86:
                    // 2 sources

                    return v7;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object saveMultiNodesAs(DeviceFileEntryNode var1_1, List<? extends DeviceFileEntryNode> var2_2, Continuation<? super FileTransferSummary> var3_3) {
            if (!(var3_3 instanceof saveMultiNodesAs.1)) ** GOTO lbl-1000
            var7_4 = var3_3;
            if ((var7_4.label & -2147483648) != 0) {
                var7_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$saveMultiNodesAs(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = var4_7 = treeNodes.isEmpty() == false;
                    if (_Assertions.ENABLED && !var4_7) {
                        var5_9 = "Assertion failed";
                        throw new AssertionError((Object)var5_9);
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = treeNodes;
                    $continuation.label = 1;
                    v1 = this.chooseSaveAsDirectoryPath((DeviceFileEntryNode)commonParentNode, (Continuation<? super Path>)$continuation);
                    if (v1 == var8_6) {
                        return var8_6;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    treeNodes = (List)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl28:
                    // 2 sources

                    v2 = (Path)v1;
                    if (v2 != null) break;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v3 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v3 == var8_6) {
                        return var8_6;
                    }
                    ** GOTO lbl40
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl40:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            localDirectory = v2;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.label = 3;
            v4 = this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, (List<? extends DeviceFileEntryNode>)treeNodes, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ List<DeviceFileEntryNode> $treeNodes;
                {
                    this.this$0 = $receiver;
                    this.$treeNodes = $treeNodes;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                            this.label = 1;
                            Object object3 = this.this$0.addDownloadOperationWork(tracker, this.$treeNodes, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>((List<? extends DeviceFileEntryNode>)treeNodes, localDirectory, this, null){
                Object L$1;
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ List<DeviceFileEntryNode> $treeNodes;
                final /* synthetic */ Path $localDirectory;
                final /* synthetic */ ViewListener this$0;
                {
                    this.$treeNodes = $treeNodes;
                    this.$localDirectory = $localDirectory;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            tracker = (FileTransferOperationTracker)this.L$0;
                            var3_4 = this.$treeNodes.iterator();
lbl7:
                            // 3 sources

                            while (var3_4.hasNext()) {
                                treeNode = var3_4.next();
                                nodePath = this.$localDirectory.resolve(treeNode.getEntry().getName());
                                Intrinsics.checkNotNullExpressionValue((Object)nodePath, (String)"nodePath");
                                this.L$0 = tracker;
                                this.L$1 = var3_4;
                                this.label = 1;
                                v0 = ViewListener.access$downloadSingleNode(this.this$0, treeNode, nodePath, tracker, (Continuation)this);
                                if (v0 != var6_2) continue;
                                return var6_2;
                            }
                            break;
                        }
                        case 1: {
                            var3_4 = (Iterator<DeviceFileEntryNode>)this.L$1;
                            tracker = (FileTransferOperationTracker)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), true, (Continuation<? super FileTransferSummary>)$continuation);
            if (v4 == var8_6) {
                return var8_6;
            }
            ** GOTO lbl52
            {
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl52:
                    // 2 sources

                    return v4;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object wrapFileTransfer(Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object> var1_1, Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object> var2_2, boolean var3_3, Continuation<? super FileTransferSummary> var4_4) {
            if (!(var4_4 instanceof wrapFileTransfer.1)) ** GOTO lbl-1000
            var6_5 = var4_4;
            if ((var6_5.label & -2147483648) != 0) {
                var6_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$wrapFileTransfer(this.this$0, null, null, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileTransferSummary>, Object>(DeviceFileExplorerControllerImpl.this, backgroundable != false, (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)prepareTransfer, (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)performTransfer, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                        final /* synthetic */ boolean $backgroundable;
                        final /* synthetic */ Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object> $prepareTransfer;
                        final /* synthetic */ Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object> $performTransfer;
                        {
                            this.this$0 = $receiver;
                            this.$backgroundable = $backgroundable;
                            this.$prepareTransfer = $prepareTransfer;
                            this.$performTransfer = $performTransfer;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    tracker = new FileTransferOperationTracker(DeviceFileExplorerControllerImpl.access$getView$p(this.this$0), this.$backgroundable);
                                    DeviceFileExplorerControllerImpl.access$registerLongRunningOperation(this.this$0, tracker);
                                    tracker.start();
                                    tracker.setCalculatingText(0, 0);
                                    tracker.setIndeterminate(true);
                                    Disposer.register((Disposable)this.this$0, (Disposable)tracker);
                                    DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).startTreeBusyIndicator();
                                    this.L$0 = tracker;
                                    this.label = 1;
                                    v0 = this.$prepareTransfer.invoke((Object)tracker, (Object)this);
                                    ** if (v0 != var4_2) goto lbl19
lbl18:
                                    // 1 sources

                                    return var4_2;
lbl19:
                                    // 1 sources

                                    ** GOTO lbl26
                                }
                                case 1: {
                                    tracker = (FileTransferOperationTracker)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl26:
                                    // 2 sources

                                    tracker.setIndeterminate(false);
                                    this.L$0 = tracker;
                                    this.label = 2;
                                    v1 = this.$performTransfer.invoke((Object)tracker, (Object)this);
                                    ** if (v1 != var4_2) goto lbl32
lbl31:
                                    // 1 sources

                                    return var4_2;
lbl32:
                                    // 1 sources

                                    ** GOTO lbl46
                                }
                                case 2: {
                                    tracker = (FileTransferOperationTracker)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                    }
                                    catch (Throwable var3_4) {
                                        throw var3_4;
                                    }
                                    finally {
                                        DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).stopTreeBusyIndicator();
                                        Disposer.dispose((Disposable)tracker);
                                    }
lbl46:
                                    // 2 sources

                                    return tracker.getSummary();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FileTransferSummary> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var7_7) {
                        return var7_7;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"@UiThread\nclass DeviceFi\u2026UserData(KEY)\n    }\n  }\n}");
                    return v0;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object addUploadOperationWork(@NotNull FileTransferOperationTracker var1_1, @NotNull List<? extends Path> var2_2, @NotNull Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof addUploadOperationWork.1)) ** GOTO lbl-1000
            var11_4 = var3_3;
            if ((var11_4.label & -2147483648) != 0) {
                var11_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.addUploadOperationWork((FileTransferOperationTracker)null, (List<? extends Path>)null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$forEach$iv = (Iterable)files;
                    $i$f$forEach = false;
                    var6_9 = $this$forEach$iv.iterator();
lbl15:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        it = (Path)element$iv;
                        $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$addUploadOperationWork$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = tracker;
                        $continuation.L$2 = var6_9;
                        $continuation.label = 1;
                        v0 = this.addUploadOperationWork(tracker, it, (Continuation<? super Unit>)$continuation);
                        if (v0 != var12_6) continue;
                        return var12_6;
                    }
                    break;
                }
                case 1: {
                    $i$f$forEach = false;
                    $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$addUploadOperationWork$2 = false;
                    var6_9 = (Iterator<T>)$continuation.L$2;
                    tracker = (FileTransferOperationTracker)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl15
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object addUploadOperationWork(@NotNull FileTransferOperationTracker var1_1, @NotNull Path var2_2, @NotNull Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof addUploadOperationWork.3)) ** GOTO lbl-1000
            var7_4 = var3_3;
            if ((var7_4.label & -2147483648) != 0) {
                var7_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.addUploadOperationWork((FileTransferOperationTracker)null, (Path)null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    progress = this.createFileTransferEstimatorProgress(tracker);
                    $continuation.L$0 = tracker;
                    $continuation.label = 1;
                    v0 = DeviceFileExplorerControllerImpl.access$getWorkEstimator$p(DeviceFileExplorerControllerImpl.this).estimateUploadWork((Path)path, progress, (Continuation<? super FileTransferWorkEstimate>)$continuation);
                    if (v0 == var8_6) {
                        return var8_6;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    tracker = (FileTransferOperationTracker)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    estimate = (FileTransferWorkEstimate)v0;
                    tracker.addWorkEstimate(estimate);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object addDownloadOperationWork(@NotNull FileTransferOperationTracker var1_1, @NotNull List<? extends DeviceFileEntryNode> var2_2, @NotNull Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof addDownloadOperationWork.1)) ** GOTO lbl-1000
            var11_4 = var3_3;
            if ((var11_4.label & -2147483648) != 0) {
                var11_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.addDownloadOperationWork((FileTransferOperationTracker)null, (List<? extends DeviceFileEntryNode>)null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$forEach$iv = (Iterable)entryNodes;
                    $i$f$forEach = false;
                    var6_9 = $this$forEach$iv.iterator();
lbl15:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        it = (DeviceFileEntryNode)element$iv;
                        $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$addDownloadOperationWork$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = tracker;
                        $continuation.L$2 = var6_9;
                        $continuation.label = 1;
                        v0 = this.addDownloadOperationWork(tracker, it, (Continuation<? super Unit>)$continuation);
                        if (v0 != var12_6) continue;
                        return var12_6;
                    }
                    break;
                }
                case 1: {
                    $i$f$forEach = false;
                    $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$addDownloadOperationWork$2 = false;
                    var6_9 = (Iterator<T>)$continuation.L$2;
                    tracker = (FileTransferOperationTracker)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl15
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object addDownloadOperationWork(@NotNull FileTransferOperationTracker var1_1, @NotNull DeviceFileEntryNode var2_2, @NotNull Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof addDownloadOperationWork.3)) ** GOTO lbl-1000
            var8_4 = var3_3;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.addDownloadOperationWork((FileTransferOperationTracker)null, (DeviceFileEntryNode)null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    progress = this.createFileTransferEstimatorProgress(tracker);
                    v0 = DeviceFileExplorerControllerImpl.access$getWorkEstimator$p(DeviceFileExplorerControllerImpl.this);
                    var6_8 = entryNode.getEntry();
                    Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"entryNode.entry");
                    $continuation.L$0 = tracker;
                    $continuation.label = 1;
                    v1 = v0.estimateDownloadWork(var6_8, entryNode.isSymbolicLinkToDirectory(), progress, (Continuation<? super FileTransferWorkEstimate>)$continuation);
                    if (v1 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    tracker = (FileTransferOperationTracker)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl26:
                    // 2 sources

                    estimate = (FileTransferWorkEstimate)v1;
                    tracker.addWorkEstimate(estimate);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final FileTransferWorkEstimatorProgress createFileTransferEstimatorProgress(FileTransferOperationTracker tracker) {
            return new FileTransferWorkEstimatorProgress(tracker){
                final /* synthetic */ FileTransferOperationTracker $tracker;
                {
                    this.$tracker = $tracker;
                }

                public void progress(int fileCount2, int directoryCount) {
                    this.$tracker.setCalculatingText(fileCount2, directoryCount);
                }

                public boolean isCancelled() {
                    return this.$tracker.isCancelled();
                }
            };
        }

        private final Object downloadSingleNode(DeviceFileEntryNode node, Path localPath, FileTransferOperationTracker tracker, Continuation<? super Unit> $completion) {
            if (node.getEntry().isDirectory()) {
                Object object = this.downloadSingleDirectory(node, localPath, tracker, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            Object object = this.downloadSingleFile(node, localPath, tracker, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final Object downloadSingleFile(DeviceFileEntryNode var1_1, Path var2_2, FileTransferOperationTracker var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof downloadSingleFile.1)) ** GOTO lbl-1000
            var9_5 = var4_4;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$downloadSingleFile(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = var5_8 = treeNode.getEntry().isDirectory() == false;
                    if (_Assertions.ENABLED && !var5_8) {
                        var6_11 = "Assertion failed";
                        throw new AssertionError((Object)var6_11);
                    }
                    if (treeNode.isTransferring()) {
                        var6_12 = "File %s is already downloading or uploading";
                        var7_13 = new Object[]{this.getUserFacingNodeName(treeNode)};
                        v1 = String.format(var6_12, Arrays.copyOf(var7_13, var7_13.length));
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(format, *args)");
                        tracker.addProblem(new Exception(v1));
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = treeNode;
                    $continuation.L$2 = tracker;
                    $continuation.label = 1;
                    v2 = this.downloadFileEntry(treeNode, (Path)localPath, tracker, (Continuation<? super Long>)$continuation);
                    ** if (v2 != var10_7) goto lbl33
lbl32:
                    // 1 sources

                    return var10_7;
lbl33:
                    // 1 sources

                    ** GOTO lbl42
                }
                case 1: {
                    tracker = (FileTransferOperationTracker)$continuation.L$2;
                    treeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl42:
                        // 2 sources

                        entrySize = ((Number)v2).longValue();
                        tracker.getSummary().addFileCount(1);
                        tracker.getSummary().addByteCount(entrySize);
                    }
                    catch (Throwable t) {
                        tracker.addProblem(new Exception("Error saving contents of device file " + this.getUserFacingNodeName(treeNode), t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Exception decompiling
         */
        private final Object downloadSingleDirectory(DeviceFileEntryNode var1_1, Path var2_2, FileTransferOperationTracker var3_3, Continuation<? super Unit> var4_4) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        public void copyNodePathsInvoked(@NotNull List<? extends DeviceFileEntryNode> treeNodes) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
            Iterable $this$map$iv = treeNodes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DeviceFileEntryNode deviceFileEntryNode = (DeviceFileEntryNode)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getEntry().getFullPath());
            }
            String text2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
            DeviceFileExplorerControllerImpl.this.trackAction(DeviceExplorerEvent.Action.COPY_PATH);
        }

        @Override
        public void newFileInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            Intrinsics.checkNotNullParameter((Object)parentTreeNode, (String)"parentTreeNode");
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, parentTreeNode, DeviceFileExplorerControllerImpl.this, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $parentTreeNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.$parentTreeNode = $parentTreeNode;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = UIBundle.message((String)"new.file.dialog.title", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(\"new.file.dialog.title\")");
                            v1 = UIBundle.message((String)"create.new.file.enter.new.file.name.prompt.text", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(\"create.new.file\u2026w.file.name.prompt.text\")");
                            v2 = UIBundle.message((String)"create.new.file.file.name.cannot.be.empty.error.message", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(\"create.new.file\u2026.be.empty.error.message\")");
                            this.label = 1;
                            v3 = ViewListener.access$newFileOrDirectory(this.this$0, this.$parentTreeNode, "NewTextFile.txt", v0, v1, v2, newFileInvoked.1.INSTANCE, (Function2)new Function2<String, Continuation<? super Unit>, Object>(this.$parentTreeNode, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ DeviceFileEntryNode $parentTreeNode;
                                {
                                    this.$parentTreeNode = $parentTreeNode;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            String it = (String)this.L$0;
                                            this.label = 1;
                                            Object object3 = this.$parentTreeNode.getEntry().createNewFile(it, (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (v3 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl19:
                            // 2 sources

                            DeviceFileExplorerControllerImpl.access$trackAction(this.this$1, DeviceExplorerEvent.Action.NEW_FILE);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - void declaration
         */
        public void synchronizeNodesInvoked(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            if (nodes2.isEmpty()) {
                return;
            }
            Ref.ObjectRef directoryNodes = new Ref.ObjectRef();
            Iterable iterable = nodes2;
            Ref.ObjectRef objectRef = directoryNodes;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DeviceFileEntryNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                DeviceFileEntryNode it = (DeviceFileEntryNode)element$iv$iv;
                boolean bl2 = false;
                if ((it.isSymbolicLinkToDirectory() || it.getEntry().isDirectory() ? it : DeviceFileEntryNode.fromNode(it.getParent())) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            objectRef.element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$mapNotNull$iv = (Iterable)directoryNodes.element;
            objectRef = directoryNodes;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DeviceFileEntryNode node = (DeviceFileEntryNode)element$iv$iv;
                boolean bl = false;
                List nodesToSynchronize = new ArrayList();
                Stack<DeviceFileEntryNode> stack = new Stack<DeviceFileEntryNode>();
                stack.push(node);
                while (!stack.isEmpty()) {
                    DeviceFileEntryNode currentNode = (DeviceFileEntryNode)stack.pop();
                    Intrinsics.checkNotNullExpressionValue((Object)currentNode, (String)"currentNode");
                    nodesToSynchronize.add(currentNode);
                    for (DeviceFileEntryNode child : currentNode.getChildEntryNodes()) {
                        if (!child.getEntry().isDirectory() && !child.isSymbolicLinkToDirectory() || !child.isLoaded()) continue;
                        stack.push(child);
                    }
                }
                Iterable list$iv$iv = nodesToSynchronize;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            objectRef.element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceFileExplorerControllerImpl.this, (Ref.ObjectRef<Set<DeviceFileEntryNode>>)directoryNodes, this, null){
                Object L$0;
                int label;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                final /* synthetic */ Ref.ObjectRef<Set<DeviceFileEntryNode>> $directoryNodes;
                final /* synthetic */ ViewListener this$1;
                {
                    this.this$0 = $receiver;
                    this.$directoryNodes = $directoryNodes;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    Iterator<E> iterator2;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DeviceFileExplorerControllerImpl.access$trackAction(this.this$0, DeviceExplorerEvent.Action.SYNC);
                            DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).startTreeBusyIndicator();
                            iterator2 = ((Set)this.$directoryNodes.element).iterator();
                            break;
                        }
                        case 1: {
                            iterator2 = (Iterator<E>)this.L$0;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                            }
                            catch (Throwable throwable) {
                                DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).stopTreeBusyIndicator();
                                throw throwable;
                            }
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator2.hasNext()) {
                        DeviceFileEntryNode node = (DeviceFileEntryNode)iterator2.next();
                        node.setLoaded(false);
                        try {
                            this.L$0 = iterator2;
                            this.label = 1;
                            object2 = ViewListener.access$loadNodeChildren(this.this$1, node, (Continuation)this);
                            if (object2 != object3) continue;
                        }
                        catch (Exception exception) {}
                        return object3;
                    }
                    DeviceFileExplorerControllerImpl.access$getView$p(this.this$0).stopTreeBusyIndicator();
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - void declaration
         */
        public void deleteNodesInvoked(@NotNull List<? extends DeviceFileEntryNode> nodes2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            if (nodes2.isEmpty()) {
                return;
            }
            if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(this.getCommonParentNode(nodes2), DeviceFileExplorerControllerImpl.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            Iterable $this$map$iv = nodes2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DeviceFileEntryNode deviceFileEntryNode = (DeviceFileEntryNode)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getEntry());
            }
            List fileEntries = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            String message2 = this.createDeleteConfirmationMessage(fileEntries);
            int returnValue = Messages.showOkCancelDialog((String)message2, (String)UIBundle.message((String)"delete.dialog.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (returnValue != 0) {
                return;
            }
            List $this$sortBy$iv = fileEntries;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DeviceFileEntry it = (DeviceFileEntry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getFullPath());
                        it = (DeviceFileEntry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFullPath())));
                    }
                });
            }
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<DeviceFileEntry>)fileEntries, this, DeviceFileExplorerControllerImpl.this, nodes2, null){
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ List<DeviceFileEntry> $fileEntries;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                final /* synthetic */ List<DeviceFileEntryNode> $nodes;
                {
                    this.$fileEntries = $fileEntries;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$nodes = $nodes;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            problems = new LinkedList<E>();
                            var3_4 = this.$fileEntries.iterator();
lbl7:
                            // 4 sources

                            while (var3_4.hasNext()) {
                                fileEntry = var3_4.next();
                                v0 = DeviceFileExplorerControllerImpl.access$getFILE_ENTRY_DELETION_TIMEOUT$cp();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FILE_ENTRY_DELETION_TIMEOUT");
                                this.L$0 = problems;
                                this.L$1 = var3_4;
                                this.L$2 = fileEntry;
                                this.label = 1;
                                v1 = TimeKt.withTimeout((Duration)v0, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fileEntry, null){
                                    int label;
                                    final /* synthetic */ DeviceFileEntry $fileEntry;
                                    {
                                        this.$fileEntry = $fileEntry;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.$fileEntry.delete((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 != var19_2) continue;
                                return var19_2;
                            }
                            break;
                        }
                        case 1: {
                            fileEntry = (DeviceFileEntry)this.L$2;
                            var3_4 = (Iterator<DeviceFileEntry>)this.L$1;
                            problems = (List)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                            }
                            catch (Throwable t) {
                                DeviceFileExplorerControllerImpl.access$getLOGGER$cp().info("Error deleting file \"" + fileEntry.getFullPath() + "\"", t);
                                v2 = Strings.emptyToNull((String)ExceptionUtil.getRootCause((Throwable)t).getMessage());
                                if (v2 == null) {
                                    v2 = "Error deleting file";
                                }
                                problemMessage = v2;
                                problems.add(fileEntry.getFullPath() + ": " + (String)problemMessage);
                            }
                            ** GOTO lbl7
                        }
                    }
                    if (!problems.isEmpty()) {
                        ViewListener.access$reportDeletionProblem(this.this$0, problems);
                    } else {
                        DeviceFileExplorerControllerImpl.access$trackAction(this.this$1, DeviceExplorerEvent.Action.DELETE);
                    }
                    $this$mapNotNull$iv = this.$nodes;
                    $i$f$mapNotNull = false;
                    problemMessage = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var11_15 = $this$forEach$iv$iv$iv.iterator();
                    while (var11_15.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var11_15.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (DeviceFileEntryNode)element$iv$iv;
                        $i$a$-mapNotNull-DeviceFileExplorerControllerImpl$ViewListener$deleteNodesInvoked$2$parentsToRefresh$1 = false;
                        if (DeviceFileEntryNode.fromNode(it.getParent()) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    parentsToRefresh = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    var4_5 = parentsToRefresh.iterator();
lbl63:
                    // 4 sources

                    while (var4_5.hasNext()) {
                        parent = (DeviceFileEntryNode)var4_5.next();
                        parent.setLoaded(false);
                        Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                        this.L$0 = var4_5;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 2;
                        v3 = ViewListener.access$loadNodeChildren(this.this$0, parent, (Continuation)this);
                        if (v3 != var19_2) continue;
                        return var19_2;
                    }
                    {
                        break;
                        case 2: {
                            var4_5 = (Iterator<E>)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                            }
                            catch (Exception var6_10) {}
                            ** GOTO lbl63
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void reportDeletionProblem(List<String> problems) {
            List<String> problems2 = problems;
            if (problems2.size() == 1) {
                Messages.showMessageDialog((String)StringsKt.trimIndent((String)("\n  Could not erase file or folder:\n  " + problems2.get(0) + "\n  ")), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            boolean more = false;
            if (problems2.size() > 10) {
                problems2 = problems2.subList(0, 10);
                more = true;
            }
            Messages.showMessageDialog((String)("Could not erase files or folders:\n  " + StringUtil.join((Collection)problems2, (String)",\n  ") + (more ? "\n  ..." : "")), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        private final String createDeleteConfirmationMessage(List<? extends DeviceFileEntry> filesToDelete) {
            String string;
            if (filesToDelete.size() == 1) {
                String string2;
                if (filesToDelete.get(0).isDirectory()) {
                    Object[] objectArray = new Object[]{filesToDelete.get(0).getName()};
                    string2 = UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folder.confirmation.message", (Object[])objectArray);
                } else {
                    Object[] objectArray = new Object[]{filesToDelete.get(0).getName()};
                    string2 = UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.file.confirmation.message", (Object[])objectArray);
                }
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        if (filesToDel\u2026].name)\n        }\n      }");
            } else {
                String string3;
                boolean hasFolders;
                boolean hasFiles;
                block15: {
                    boolean bl;
                    block14: {
                        Iterable $this$any$iv = filesToDelete;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                DeviceFileEntry it = (DeviceFileEntry)element$iv;
                                boolean bl2 = false;
                                if (!(!it.isDirectory())) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    hasFiles = bl;
                    Iterable $this$any$iv = filesToDelete;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DeviceFileEntry it = (DeviceFileEntry)element$iv;
                            boolean bl3 = false;
                            if (!it.isDirectory()) continue;
                            v3 = true;
                            break block15;
                        }
                        v3 = hasFolders = false;
                    }
                }
                if (hasFiles && hasFolders) {
                    var4_8 = new Object[]{filesToDelete.size()};
                    string3 = UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", (Object[])var4_8);
                } else if (hasFolders) {
                    var4_8 = new Object[]{filesToDelete.size()};
                    string3 = UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folders.confirmation.message", (Object[])var4_8);
                } else {
                    var4_8 = new Object[]{filesToDelete.size()};
                    string3 = UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", (Object[])var4_8);
                }
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        val hasFiles =\u2026e.size)\n        }\n      }");
            }
            return string;
        }

        @Override
        public void newDirectoryInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            Intrinsics.checkNotNullParameter((Object)parentTreeNode, (String)"parentTreeNode");
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, parentTreeNode, DeviceFileExplorerControllerImpl.this, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $parentTreeNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.$parentTreeNode = $parentTreeNode;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message(\"new.folder.dialog.title\")");
                            v1 = UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(\"create.new.fold\u2026folder.name.prompt.text\")");
                            v2 = UIBundle.message((String)"create.new.folder.folder.name.cannot.be.empty.error.message", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(\"create.new.fold\u2026.be.empty.error.message\")");
                            this.label = 1;
                            v3 = ViewListener.access$newFileOrDirectory(this.this$0, this.$parentTreeNode, "NewFolder", v0, v1, v2, newDirectoryInvoked.1.INSTANCE, (Function2)new Function2<String, Continuation<? super Unit>, Object>(this.$parentTreeNode, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ DeviceFileEntryNode $parentTreeNode;
                                {
                                    this.$parentTreeNode = $parentTreeNode;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            String it = (String)this.L$0;
                                            this.label = 1;
                                            Object object3 = this.$parentTreeNode.getEntry().createNewDirectory(it, (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (v3 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl19:
                            // 2 sources

                            DeviceFileExplorerControllerImpl.access$trackAction(this.this$1, DeviceExplorerEvent.Action.NEW_DIRECTORY);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object newFileOrDirectory(DeviceFileEntryNode var1_1, String var2_2, String var3_3, String var4_4, String var5_5, Function1<? super String, String> var6_6, Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> var7_7, Continuation<? super Unit> var8_8) {
            if (!(var8_8 instanceof newFileOrDirectory.1)) ** GOTO lbl-1000
            var13_9 = var8_8;
            if ((var13_9.label & -2147483648) != 0) {
                var13_9.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var8_8){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$newFileOrDirectory(this.this$0, null, null, null, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    initialName = initialName;
                    if (DeviceFileExplorerControllerImpl.access$getTreeModel(DeviceFileExplorerControllerImpl.this) == null) {
                        return Unit.INSTANCE;
                    }
lbl15:
                    // 3 sources

                    while (true) {
                        if (Messages.showInputDialog((String)prompt, (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)((InputValidator)new InputValidatorEx(emptyErrorMessage){
                            final /* synthetic */ String $emptyErrorMessage;
                            {
                                this.$emptyErrorMessage = $emptyErrorMessage;
                            }

                            @Nullable
                            public String getErrorText(@NotNull String inputString) {
                                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                                String $this$trim$iv = inputString;
                                boolean $i$f$trim = false;
                                CharSequence $this$trim$iv$iv = $this$trim$iv;
                                boolean $i$f$trim2 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                if (StringUtil.isEmpty((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
                                    return this.$emptyErrorMessage;
                                }
                                if (StringsKt.contains$default((CharSequence)inputString, (CharSequence)"/", (boolean)false, (int)2, null)) {
                                    return "Path cannot contain \"/\" characters";
                                }
                                return null;
                            }

                            public boolean checkInput(@NotNull String inputString) {
                                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                                return this.canClose(inputString);
                            }

                            public boolean canClose(@NotNull String inputString) {
                                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                                String $this$trim$iv = inputString;
                                boolean $i$f$trim = false;
                                CharSequence $this$trim$iv$iv = $this$trim$iv;
                                boolean $i$f$trim2 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                return !StringUtil.isEmpty((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                            }
                        })) == null) {
                            return Unit.INSTANCE;
                        }
                        v0 = DeviceFileExplorerControllerImpl.access$getFILE_ENTRY_CREATION_TIMEOUT$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FILE_ENTRY_CREATION_TIMEOUT");
                        $continuation.L$0 = this;
                        $continuation.L$1 = parentTreeNode;
                        $continuation.L$2 = title;
                        $continuation.L$3 = prompt;
                        $continuation.L$4 = emptyErrorMessage;
                        $continuation.L$5 = errorMessage;
                        $continuation.L$6 = createFunction;
                        $continuation.L$7 = newFileName;
                        $continuation.label = 1;
                        v1 = TimeKt.withTimeout((Duration)v0, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function2<? super String, ? super Continuation<? super Unit>, ? extends Object>)createFunction, newFileName, null){
                            int label;
                            final /* synthetic */ Function2<String, Continuation<? super Unit>, Object> $createFunction;
                            final /* synthetic */ String $newFileName;
                            {
                                this.$createFunction = $createFunction;
                                this.$newFileName = $newFileName;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$createFunction.invoke((Object)this.$newFileName, (Object)((Object)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        ** if (v1 != var14_11) goto lbl34
lbl33:
                        // 1 sources

                        return var14_11;
lbl34:
                        // 1 sources

                        ** GOTO lbl48
                        break;
                    }
                }
                case 1: {
                    newFileName = (String)$continuation.L$7;
                    createFunction = (Function2)$continuation.L$6;
                    errorMessage = (Function1)$continuation.L$5;
                    emptyErrorMessage = (String)$continuation.L$4;
                    prompt = (String)$continuation.L$3;
                    title = (String)$continuation.L$2;
                    parentTreeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    parentTreeNode.setLoaded(false);
                    $continuation.L$0 = this;
                    $continuation.L$1 = parentTreeNode;
                    $continuation.L$2 = title;
                    $continuation.L$3 = prompt;
                    $continuation.L$4 = emptyErrorMessage;
                    $continuation.L$5 = errorMessage;
                    $continuation.L$6 = createFunction;
                    $continuation.L$7 = newFileName;
                    $continuation.label = 2;
                    v2 = this.loadNodeChildren(parentTreeNode, (Continuation<? super Unit>)$continuation);
                    ** if (v2 != var14_11) goto lbl61
lbl60:
                    // 1 sources

                    return var14_11;
lbl61:
                    // 1 sources

                    ** GOTO lbl75
                }
                case 2: {
                    newFileName = (String)$continuation.L$7;
                    createFunction = (Function2)$continuation.L$6;
                    errorMessage = (Function1)$continuation.L$5;
                    emptyErrorMessage = (String)$continuation.L$4;
                    prompt = (String)$continuation.L$3;
                    title = (String)$continuation.L$2;
                    parentTreeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl75:
                        // 2 sources

                        DeviceFileExplorerControllerImpl.access$getView$p(DeviceFileExplorerControllerImpl.this).expandNode(parentTreeNode);
                        return Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        this.showErrorMessage((String)errorMessage.invoke((Object)newFileName), e);
                        initialName = newFileName;
                        ** continue;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Throwable actualCause(Throwable error) {
            Throwable throwable;
            if (error instanceof ExecutionException) {
                throwable = error.getCause();
                if (throwable == null) {
                    throwable = error;
                }
            } else {
                throwable = error;
            }
            return throwable;
        }

        private final void showErrorMessage(String message2, Throwable error) {
            Object object;
            block3: {
                block2: {
                    object = this.actualCause(error).getMessage();
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    String string = message2 + StringsKt.trimIndent((String)("\n                :\n                " + it + "\n                "));
                    object = string;
                    if (string != null) break block3;
                }
                object = message2;
            }
            String message3 = object;
            Messages.showMessageDialog((String)message3, (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        @Override
        public void uploadFilesInvoked(@NotNull DeviceFileEntryNode treeNode) {
            Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
            if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(treeNode, DeviceFileExplorerControllerImpl.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
            AtomicReference<List<VirtualFile>> filesRef = new AtomicReference<List<VirtualFile>>();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)DeviceFileExplorerControllerImpl.this.project, null, (Consumer)new Consumer(filesRef){
                final /* synthetic */ AtomicReference<List<VirtualFile>> $filesRef;
                {
                    this.$filesRef = $filesRef;
                }

                public final void consume(List<VirtualFile> it) {
                    this.$filesRef.set(it);
                }
            });
            List<VirtualFile> files2 = filesRef.get();
            if (files2 == null || files2.isEmpty()) {
                return;
            }
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, treeNode, files2, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ List<VirtualFile> $files;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.$files = $files;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            List<VirtualFile> list2 = this.$files;
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"files");
                            this.label = 1;
                            Object object3 = ViewListener.access$uploadVirtualFilesInvoked(this.this$0, this.$treeNode, list2, DeviceExplorerEvent.Action.UPLOAD, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - void declaration
         */
        public void uploadFilesInvoked(@NotNull DeviceFileEntryNode treeNode, @NotNull List<? extends Path> files2) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(treeNode, DeviceFileExplorerControllerImpl.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            Iterable $this$mapNotNull$iv = files2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                if (VfsUtil.findFile((Path)it, (boolean)true) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List vfiles = (List)destination$iv$iv;
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, treeNode, (List<? extends VirtualFile>)vfiles, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ List<VirtualFile> $vfiles;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.$vfiles = $vfiles;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ViewListener.access$uploadVirtualFilesInvoked(this.this$0, this.$treeNode, this.$vfiles, DeviceExplorerEvent.Action.DROP, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object uploadVirtualFilesInvoked(DeviceFileEntryNode var1_1, List<? extends VirtualFile> var2_2, DeviceExplorerEvent.Action var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof uploadVirtualFilesInvoked.1)) ** GOTO lbl-1000
            var7_5 = var4_4;
            if ((var7_5.label & -2147483648) != 0) {
                var7_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$uploadVirtualFilesInvoked(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!DeviceFileExplorerControllerImpl.this.checkLongRunningOperationAllowed()) {
                        DeviceFileExplorerControllerImpl.access$getView$p(DeviceFileExplorerControllerImpl.this).reportErrorRelatedToNode(treeNode, "Device Explorer is busy, please retry later or cancel current operation", new RuntimeException());
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = treeNode;
                    $continuation.L$2 = action;
                    $continuation.label = 1;
                    v0 = this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, (List<? extends VirtualFile>)files, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ ViewListener this$0;
                        final /* synthetic */ List<VirtualFile> $files;
                        {
                            this.this$0 = $receiver;
                            this.$files = $files;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    Collection<Path> collection2;
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                                    Iterable iterable = this.$files;
                                    FileTransferOperationTracker fileTransferOperationTracker = tracker;
                                    ViewListener viewListener = this.this$0;
                                    boolean $i$f$map = false;
                                    void var5_8 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                                        collection2 = destination$iv$iv;
                                        boolean bl = false;
                                        collection2.add(Paths.get(it.getPath(), new String[0]));
                                    }
                                    collection2 = (List)destination$iv$iv;
                                    this.label = 1;
                                    Object object3 = viewListener.addUploadOperationWork(fileTransferOperationTracker, (List<? extends Path>)collection2, (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FileTransferOperationTracker, Continuation<? super Unit>, Object>(this, treeNode, (List<? extends VirtualFile>)files, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ ViewListener this$0;
                        final /* synthetic */ DeviceFileEntryNode $treeNode;
                        final /* synthetic */ List<VirtualFile> $files;
                        {
                            this.this$0 = $receiver;
                            this.$treeNode = $treeNode;
                            this.$files = $files;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileTransferOperationTracker tracker = (FileTransferOperationTracker)this.L$0;
                                    this.label = 1;
                                    Object object3 = ViewListener.access$uploadVirtualFiles(this.this$0, this.$treeNode, this.$files, tracker, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull FileTransferOperationTracker p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), true, (Continuation<? super FileTransferSummary>)$continuation);
                    ** if (v0 != var8_7) goto lbl24
lbl23:
                    // 1 sources

                    return var8_7;
lbl24:
                    // 1 sources

                    ** GOTO lbl33
                }
                case 1: {
                    action = (DeviceExplorerEvent.Action)$continuation.L$2;
                    treeNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        transferSummary = (FileTransferSummary)v0;
                        transferSummary.setAction(action);
                        this.reportUploadFilesSummary(treeNode, transferSummary);
                    }
                    catch (Throwable t) {
                        DeviceFileExplorerControllerImpl.access$getView$p(DeviceFileExplorerControllerImpl.this).reportErrorRelatedToNode(treeNode, "Error uploading files(s) to device", t);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final void reportUploadFilesSummary(DeviceFileEntryNode treeNode, FileTransferSummary summary) {
            this.reportFileTransferSummary(treeNode, summary, "uploaded", "uploading");
        }

        /*
         * Unable to fully structure code
         */
        private final Object uploadVirtualFiles(DeviceFileEntryNode var1_1, List<? extends VirtualFile> var2_2, FileTransferOperationTracker var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof uploadVirtualFiles.1)) ** GOTO lbl-1000
            var12_5 = var4_4;
            if ((var12_5.label & -2147483648) != 0) {
                var12_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$uploadVirtualFiles(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$forEach$iv = (Iterable)files;
                    $i$f$forEach = false;
                    var7_10 = $this$forEach$iv.iterator();
lbl15:
                    // 3 sources

                    while (var7_10.hasNext()) {
                        element$iv = var7_10.next();
                        it = (VirtualFile)element$iv;
                        $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$uploadVirtualFiles$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = parentNode;
                        $continuation.L$2 = tracker;
                        $continuation.L$3 = var7_10;
                        $continuation.label = 1;
                        v0 = this.uploadVirtualFile(parentNode, it, tracker, (Continuation<? super Unit>)$continuation);
                        if (v0 != var13_7) continue;
                        return var13_7;
                    }
                    break;
                }
                case 1: {
                    $i$f$forEach = false;
                    $i$a$-forEach-DeviceFileExplorerControllerImpl$ViewListener$uploadVirtualFiles$2 = false;
                    var7_10 = (Iterator<T>)$continuation.L$3;
                    tracker = (FileTransferOperationTracker)$continuation.L$2;
                    parentNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl15
                }
            }
            parentNode.setLoaded(false);
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.label = 2;
            v1 = this.loadNodeChildren(parentNode, (Continuation<? super Unit>)$continuation);
            if (v1 == var13_7) {
                return var13_7;
            }
            ** GOTO lbl51
            {
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object uploadVirtualFile(DeviceFileEntryNode treeNode, VirtualFile file2, FileTransferOperationTracker tracker, Continuation<? super Unit> $completion) {
            if (file2.isDirectory()) {
                Object object = this.uploadDirectory(treeNode, file2, tracker, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            Object object = this.uploadFile(treeNode, file2, tracker, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final Object uploadDirectory(DeviceFileEntryNode var1_1, VirtualFile var2_2, FileTransferOperationTracker var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof uploadDirectory.1)) ** GOTO lbl-1000
            var21_5 = var4_4;
            if ((var21_5.label & -2147483648) != 0) {
                var21_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$uploadDirectory(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var22_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!tracker.isCancelled()) break;
                    $continuation.label = 1;
                    v0 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v0 == var22_7) {
                        return var22_7;
                    }
                    ** GOTO lbl21
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl21:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            tracker.processDirectory();
            tracker.getSummary().addDirectoryCount(1);
            v1 = parentNode.getEntry();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parentNode.entry");
            parentEntry = v1;
            v2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"file.name");
            directoryName = v2;
            $continuation.L$0 = this;
            $continuation.L$1 = parentNode;
            $continuation.L$2 = file;
            $continuation.L$3 = tracker;
            $continuation.L$4 = directoryName;
            $continuation.label = 2;
            v3 = parentEntry.createNewDirectory(directoryName, (Continuation<? super Unit>)$continuation);
            ** if (v3 != var22_7) goto lbl41
lbl40:
            // 1 sources

            return var22_7;
lbl41:
            // 1 sources

            ** GOTO lbl52
            {
                case 2: {
                    directoryName = (String)$continuation.L$4;
                    tracker = (FileTransferOperationTracker)$continuation.L$3;
                    file = (VirtualFile)$continuation.L$2;
                    parentNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl52:
                        // 2 sources

                        var8_10 = Unit.INSTANCE;
                    }
                    catch (Throwable t) {
                        var8_10 = t;
                    }
                    createDirectoryResult = var8_10;
                    parentNode.setLoaded(false);
                    $continuation.L$0 = this;
                    $continuation.L$1 = parentNode;
                    $continuation.L$2 = file;
                    $continuation.L$3 = tracker;
                    $continuation.L$4 = directoryName;
                    $continuation.L$5 = createDirectoryResult;
                    $continuation.label = 3;
                    v4 = this.loadNodeChildren(parentNode, (Continuation<? super Unit>)$continuation);
                    ** if (v4 != var22_7) goto lbl70
lbl69:
                    // 1 sources

                    return var22_7;
lbl70:
                    // 1 sources

                    ** GOTO lbl86
                }
                case 3: {
                    createDirectoryResult = $continuation.L$5;
                    directoryName = (String)$continuation.L$4;
                    tracker = (FileTransferOperationTracker)$continuation.L$3;
                    file = (VirtualFile)$continuation.L$2;
                    parentNode = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                    }
                    catch (Throwable t) {
                        tracker.addProblem(t);
                        return Unit.INSTANCE;
                    }
lbl86:
                    // 2 sources

                    childNode = parentNode.findChildEntry(directoryName);
                    if (childNode == null) {
                        tracker.addProblem(createDirectoryResult instanceof Throwable != false ? (Throwable)createDirectoryResult : (Throwable)new Exception("Error creating directory " + directoryName));
                        return Unit.INSTANCE;
                    }
                    var10_15 = file.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)var10_15, (String)"file.children");
                    $this$filter$iv = var10_15;
                    $i$f$filter = false;
                    var12_17 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        it = (VirtualFile)element$iv$iv;
                        $i$a$-filter-DeviceFileExplorerControllerImpl$ViewListener$uploadDirectory$childFiles$1 = false;
                        v5 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.name");
                        if (!(StringsKt.startsWith$default((String)v5, (String)".", (boolean)false, (int)2, null) == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    childFiles = (List)destination$iv$iv;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 4;
                    v6 = this.uploadVirtualFiles(childNode, childFiles, tracker, (Continuation<? super Unit>)$continuation);
                    if (v6 == var22_7) {
                        return var22_7;
                    }
                    ** GOTO lbl121
                }
                case 4: {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl121:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object uploadFile(DeviceFileEntryNode var1_1, VirtualFile var2_2, FileTransferOperationTracker var3_3, Continuation<? super Unit> var4_4) {
            if (!(var4_4 instanceof uploadFile.1)) ** GOTO lbl-1000
            var11_5 = var4_4;
            if ((var11_5.label & -2147483648) != 0) {
                var11_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$uploadFile(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!tracker.isCancelled()) break;
                    $continuation.label = 1;
                    v0 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v0 == var12_7) {
                        return var12_7;
                    }
                    ** GOTO lbl21
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl21:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            tracker.processFile();
            tracker.setUploadFileText(file, 0L, 0L);
            stopwatch = Stopwatch.createStarted();
            v1 = parentNode.getEntry();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parentNode.entry");
            parentEntry = v1;
            localPath = Paths.get(file.getPath(), new String[0]);
            uploadState = new UploadFileState(this, null, null, 0L, 7, null);
            Intrinsics.checkNotNullExpressionValue((Object)localPath, (String)"localPath");
            $continuation.L$0 = parentNode;
            $continuation.L$1 = file;
            $continuation.L$2 = tracker;
            $continuation.L$3 = stopwatch;
            $continuation.L$4 = uploadState;
            $continuation.label = 2;
            v2 = parentEntry.uploadFile(localPath, new FileTransferProgress(tracker, file, uploadState, localPath, parentNode, DeviceFileExplorerControllerImpl.this, this){
                private long previousBytes;
                final /* synthetic */ FileTransferOperationTracker $tracker;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ UploadFileState $uploadState;
                final /* synthetic */ Path $localPath;
                final /* synthetic */ DeviceFileEntryNode $parentNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                final /* synthetic */ ViewListener this$1;
                {
                    this.$tracker = $tracker;
                    this.$file = $file;
                    this.$uploadState = $uploadState;
                    this.$localPath = $localPath;
                    this.$parentNode = $parentNode;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                @UiThread
                public void progress(long currentBytes, long totalBytes) {
                    this.$tracker.processFileBytes(currentBytes - this.previousBytes);
                    this.$tracker.setUploadFileText(this.$file, currentBytes, totalBytes);
                    this.previousBytes = currentBytes;
                    if (this.$tracker.isInForeground()) {
                        DeviceFileEntryNode deviceFileEntryNode;
                        this.$uploadState.setByteCount(totalBytes);
                        if (this.$uploadState.getChildNode() == null) {
                            String fileName = ((Object)this.$localPath.getFileName()).toString();
                            this.$uploadState.setChildNode(this.$parentNode.findChildEntry(fileName));
                            if (this.$uploadState.getChildNode() != null) {
                                DeviceFileEntryNode deviceFileEntryNode2 = this.$uploadState.getChildNode();
                                Intrinsics.checkNotNull((Object)deviceFileEntryNode2);
                                DeviceFileExplorerControllerImpl.access$startNodeUpload(this.this$0, deviceFileEntryNode2);
                            }
                        }
                        if ((deviceFileEntryNode = this.$uploadState.getChildNode()) != null) {
                            DeviceFileEntryNode deviceFileEntryNode3 = deviceFileEntryNode;
                            FileTransferOperationTracker fileTransferOperationTracker = this.$tracker;
                            DeviceFileExplorerControllerImpl deviceFileExplorerControllerImpl = this.this$0;
                            DeviceFileEntryNode childNode = deviceFileEntryNode3;
                            boolean bl = false;
                            childNode.setTransferProgress(currentBytes, totalBytes);
                            if (currentBytes == totalBytes && fileTransferOperationTracker.isInForeground()) {
                                DeviceFileExplorerControllerImpl.access$stopNodeUpload(deviceFileExplorerControllerImpl, childNode);
                            }
                            return;
                        }
                        if (this.$uploadState.getLoadChildrenJob() != null) {
                            Job job2 = this.$uploadState.getLoadChildrenJob();
                            Intrinsics.checkNotNull((Object)job2);
                            if (job2.isCompleted()) {
                                this.$uploadState.setLoadChildrenJob(null);
                            }
                        }
                        if (currentBytes > 0L && this.$uploadState.getLoadChildrenJob() == null) {
                            this.$parentNode.setLoaded(false);
                            this.$uploadState.setLoadChildrenJob(BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$parentNode, null){
                                int label;
                                final /* synthetic */ ViewListener this$0;
                                final /* synthetic */ DeviceFileEntryNode $parentNode;
                                {
                                    this.this$0 = $receiver;
                                    this.$parentNode = $parentNode;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = ViewListener.access$loadNodeChildren(this.this$0, this.$parentNode, (Continuation)this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                    }
                }

                @WorkerThread
                public boolean isCancelled() {
                    return this.$tracker.isCancelled();
                }
            }, (Continuation<? super Unit>)$continuation);
            ** if (v2 != var12_7) goto lbl42
lbl41:
            // 1 sources

            return var12_7;
lbl42:
            // 1 sources

            ** GOTO lbl53
            {
                case 2: {
                    uploadState = (UploadFileState)$continuation.L$4;
                    stopwatch = (Stopwatch)$continuation.L$3;
                    tracker = (FileTransferOperationTracker)$continuation.L$2;
                    file = (VirtualFile)$continuation.L$1;
                    parentNode = (DeviceFileEntryNode)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl53:
                        // 2 sources

                        tracker.getSummary().addFileCount(1);
                        tracker.getSummary().addByteCount(uploadState.getByteCount());
                    }
                    catch (Throwable t) {
                        tracker.addProblem(t);
                    }
                    DeviceFileExplorerControllerImpl.access$getLOGGER$cp().trace("Uploaded file in " + stopwatch + ": " + AdbPathUtil.resolve(parentNode.getEntry().getFullPath(), file.getName()));
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - void declaration
         */
        private final void reportFileTransferSummary(DeviceFileEntryNode node, FileTransferSummary summary, String pastParticiple, String presentParticiple) {
            void $this$mapNotNullTo$iv$iv;
            String string = StringUtil.pluralize((String)"file", (int)summary.getFileCount());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(\"file\", summary.fileCount)");
            String fileString = string;
            String string2 = StringUtil.pluralize((String)"directory", (int)summary.getDirectoryCount());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluralize(\"directory\", summary.directoryCount)");
            String directoryString = string2;
            String string3 = StringUtil.pluralize((String)"byte", (int)Ints.saturatedCast((long)summary.getByteCount()));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluralize(\"byte\", Ints.s\u2026dCast(summary.byteCount))");
            String byteCountString = string3;
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_EXPLORER).setDeviceExplorerEvent(DeviceExplorerEvent.newBuilder().setAction(summary.getAction()).setTransferFileCount(summary.getFileCount()).setTransferTotalSize((int)summary.getByteCount()).setTransferTimeMs((int)summary.getDurationMillis()));
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n          .\u2026llis.toInt())\n          )");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            if (summary.getProblems().isEmpty()) {
                String string4;
                if (summary.getDirectoryCount() > 0) {
                    var10_8 = Locale.getDefault();
                    var11_11 = "Successfully %s %,d %s and %,d %s for a total size of %,d %s in %s.";
                    var12_13 = new Object[]{pastParticiple, summary.getFileCount(), fileString, summary.getDirectoryCount(), directoryString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis())};
                    String string5 = String.format(var10_8, var11_11, Arrays.copyOf(var12_13, var12_13.length));
                    string4 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
                } else {
                    var10_8 = Locale.getDefault();
                    var11_11 = "Successfully %s %,d %s for a total of size of %,d %s in %s.";
                    var12_13 = new Object[]{pastParticiple, summary.getFileCount(), fileString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis())};
                    String string6 = String.format(var10_8, var11_11, Arrays.copyOf(var12_13, var12_13.length));
                    string4 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(locale, format, *args)");
                }
                String successMessage = string4;
                DeviceFileExplorerControllerImpl.this.view.reportMessageRelatedToNode(node, successMessage);
                return;
            }
            List<Throwable> list2 = summary.getProblems();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"summary.problems");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Throwable it = (Throwable)element$iv$iv;
                boolean bl2 = false;
                if (ExceptionUtil.getRootCause((Throwable)it).getMessage() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List problems = (List)destination$iv$iv;
            boolean more = false;
            if (problems.size() > 10) {
                problems = problems.subList(0, 10);
                more = true;
            }
            Object object = "There were errors %s files and/or directories";
            Object object2 = new Object[]{presentParticiple};
            String string7 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
            Object message2 = string7;
            if (summary.getFileCount() > 0) {
                object = Locale.getDefault();
                object2 = ", although %,d %s %s successfully %s in %s for a total of size of %,d %s";
                Object[] objectArray = new Object[]{summary.getFileCount(), fileString, summary.getFileCount() <= 1 ? "was" : "were", pastParticiple, StringUtil.formatDuration((long)summary.getDurationMillis()), summary.getByteCount(), byteCountString};
                String string8 = String.format((Locale)object, (String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(locale, format, *args)");
                message2 = (String)message2 + string8;
            }
            DeviceFileExplorerControllerImpl.this.view.reportErrorRelatedToNode(node, (String)message2, new Exception("\n  " + StringUtil.join((Collection)problems, (String)",\n  ") + (more ? "\n  ..." : "")));
        }

        private final DeviceFileEntryNode getCommonParentNode(List<? extends DeviceFileEntryNode> treeNodes) {
            TreePath commonPath = TreeUtil.getCommonPath(treeNodes);
            LOGGER.assertTrue(commonPath != null);
            TreePath treePath = commonPath;
            Intrinsics.checkNotNull((Object)treePath);
            DeviceFileEntryNode result2 = DeviceFileEntryNode.fromNode(treePath.getLastPathComponent());
            LOGGER.assertTrue(result2 != null);
            DeviceFileEntryNode deviceFileEntryNode = result2;
            Intrinsics.checkNotNull((Object)deviceFileEntryNode);
            return deviceFileEntryNode;
        }

        /*
         * Unable to fully structure code
         */
        private final Object chooseSaveAsFilePath(DeviceFileEntryNode var1_1, Continuation<? super Path> var2_2) {
            if (!(var2_2 instanceof chooseSaveAsFilePath.1)) ** GOTO lbl-1000
            var8_3 = var2_2;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$chooseSaveAsFilePath(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = treeNode.getEntry();
                    Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"treeNode.entry");
                    entry = var4_6;
                    localPath = DeviceFileExplorerControllerImpl.access$getFileManager$p(DeviceFileExplorerControllerImpl.this).getDefaultLocalPathForEntry(entry);
                    $continuation.L$0 = this;
                    $continuation.L$1 = localPath;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getDiskIoThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(localPath, null){
                        int label;
                        final /* synthetic */ Path $localPath;
                        {
                            this.$localPath = $localPath;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileUtils.mkdirs((File)this.$localPath.getParent().toFile());
                                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.$localPath.getParent().toFile(), (boolean)true);
                                    if (virtualFile == null) {
                                        throw new Exception("Unable to locate file \"" + this.$localPath.getParent() + "\"");
                                    }
                                    return virtualFile;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFile> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    localPath = (Path)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"localPath = fileManager.\u2026lPath.parent}\\\"\")\n      }");
                    baseDir = (VirtualFile)v0;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFileWrapper>, Object>(DeviceFileExplorerControllerImpl.this, baseDir, localPath, null){
                        int label;
                        final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                        final /* synthetic */ VirtualFile $baseDir;
                        final /* synthetic */ Path $localPath;
                        {
                            this.this$0 = $receiver;
                            this.$baseDir = $baseDir;
                            this.$localPath = $localPath;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[0]);
                                    FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, DeviceFileExplorerControllerImpl.access$getProject$p(this.this$0));
                                    Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance().createSave\u2026alog(descriptor, project)");
                                    FileSaverDialog saveFileDialog = fileSaverDialog;
                                    VirtualFileWrapper virtualFileWrapper = saveFileDialog.save(this.$baseDir, ((Object)this.$localPath.getFileName()).toString());
                                    if (virtualFileWrapper != null) return virtualFileWrapper;
                                    this.label = 1;
                                    Object object3 = CoroutineContextUtilKt.cancelAndThrow((Continuation)this);
                                    if (object3 != object2) throw new KotlinNothingValueException();
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    throw new KotlinNothingValueException();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFileWrapper> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl40
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl40:
                    // 2 sources

                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"@UiThread\nclass DeviceFi\u2026UserData(KEY)\n    }\n  }\n}");
                    fileWrapper = (VirtualFileWrapper)v1;
                    return fileWrapper.getFile().toPath();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object chooseSaveAsDirectoryPath(DeviceFileEntryNode var1_1, Continuation<? super Path> var2_2) {
            if (!(var2_2 instanceof chooseSaveAsDirectoryPath.1)) ** GOTO lbl-1000
            var9_3 = var2_2;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$chooseSaveAsDirectoryPath(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = treeNode.getEntry();
                    Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"treeNode.entry");
                    entry = var4_6;
                    localPath = DeviceFileExplorerControllerImpl.access$getFileManager$p(DeviceFileExplorerControllerImpl.this).getDefaultLocalPathForEntry(entry);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getDiskIoThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(localPath, null){
                        int label;
                        final /* synthetic */ Path $localPath;
                        {
                            this.$localPath = $localPath;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileUtils.mkdirs((File)this.$localPath.toFile());
                                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.$localPath.toFile(), (boolean)true);
                                    if (virtualFile == null) {
                                        throw new Exception("Unable to locate directory \"" + this.$localPath.getParent() + "\"");
                                    }
                                    return virtualFile;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFile> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"localPath = fileManager.\u2026lPath.parent}\\\"\")\n      }");
                    localDir = (VirtualFile)v0;
                    descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                    $continuation.L$0 = resultPath = new AtomicReference<Object>(null);
                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, DeviceFileExplorerControllerImpl.this, localDir, resultPath, null){
                        int label;
                        final /* synthetic */ FileChooserDescriptor $descriptor;
                        final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                        final /* synthetic */ VirtualFile $localDir;
                        final /* synthetic */ AtomicReference<Path> $resultPath;
                        {
                            this.$descriptor = $descriptor;
                            this.this$0 = $receiver;
                            this.$localDir = $localDir;
                            this.$resultPath = $resultPath;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    FileChooser.chooseFiles((FileChooserDescriptor)this.$descriptor, (Project)DeviceFileExplorerControllerImpl.access$getProject$p(this.this$0), (VirtualFile)this.$localDir, (Consumer)new Consumer(this.$resultPath){
                                        final /* synthetic */ AtomicReference<Path> $resultPath;
                                        {
                                            this.$resultPath = $resultPath;
                                        }

                                        public final void consume(@NotNull List<? extends VirtualFile> files2) {
                                            Intrinsics.checkNotNullParameter(files2, (String)"files");
                                            if (files2.size() == 1) {
                                                Path path2 = Paths.get(files2.get(0).getPath(), new String[0]);
                                                this.$resultPath.set(path2);
                                            }
                                        }
                                    });
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl39
                }
                case 2: {
                    resultPath = (AtomicReference<Object>)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl39:
                    // 2 sources

                    return resultPath.get();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object downloadFileEntry(DeviceFileEntryNode var1_1, Path var2_2, FileTransferOperationTracker var3_3, Continuation<? super Long> var4_4) {
            if (!(var4_4 instanceof downloadFileEntry.1)) ** GOTO lbl-1000
            var9_5 = var4_4;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$downloadFileEntry(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!tracker.isCancelled()) break;
                    $continuation.label = 1;
                    v0 = CoroutineContextUtilKt.cancelAndThrow($continuation);
                    if (v0 == var10_7) {
                        return var10_7;
                    }
                    ** GOTO lbl21
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl21:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            tracker.processFile();
            v1 = treeNode.getEntry();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"treeNode.entry");
            entry = v1;
            sizeRef = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            stopwatch = Stopwatch.createStarted();
            $continuation.L$0 = entry;
            $continuation.L$1 = sizeRef;
            $continuation.L$2 = stopwatch;
            $continuation.label = 2;
            v2 = DeviceFileExplorerControllerImpl.access$getFileManager$p(DeviceFileExplorerControllerImpl.this).downloadFileEntry(entry, (Path)localPath, new DownloadProgress(this, (DeviceFileEntryNode)treeNode, DeviceFileExplorerControllerImpl.this, (FileTransferOperationTracker)tracker, (CompletableDeferred<Long>)sizeRef){
                private long previousBytes;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $treeNode;
                final /* synthetic */ DeviceFileExplorerControllerImpl this$1;
                final /* synthetic */ FileTransferOperationTracker $tracker;
                final /* synthetic */ CompletableDeferred<Long> $sizeRef;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    this.this$1 = $receiver2;
                    this.$tracker = $tracker;
                    this.$sizeRef = $sizeRef;
                }

                @UiThread
                public void onStarting(@NotNull String entryFullPath) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    DeviceFileEntryNode deviceFileEntryNode = ViewListener.access$getTreeNodeFromEntry(this.this$0, this.$treeNode, entryFullPath);
                    Intrinsics.checkNotNull((Object)deviceFileEntryNode);
                    DeviceFileEntryNode currentNode = deviceFileEntryNode;
                    this.previousBytes = 0L;
                    DeviceFileExplorerControllerImpl.access$startNodeDownload(this.this$1, currentNode);
                }

                @UiThread
                public void onProgress(@NotNull String entryFullPath, long currentBytes, long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    DeviceFileEntryNode deviceFileEntryNode = ViewListener.access$getTreeNodeFromEntry(this.this$0, this.$treeNode, entryFullPath);
                    Intrinsics.checkNotNull((Object)deviceFileEntryNode);
                    DeviceFileEntryNode currentNode = deviceFileEntryNode;
                    this.$tracker.processFileBytes(currentBytes - this.previousBytes);
                    this.previousBytes = currentBytes;
                    this.$tracker.setDownloadFileText(entryFullPath, currentBytes, totalBytes);
                    if (this.$tracker.isInForeground()) {
                        currentNode.setTransferProgress(currentBytes, totalBytes);
                    }
                }

                @UiThread
                public void onCompleted(@NotNull String entryFullPath) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    this.$sizeRef.complete((Object)this.previousBytes);
                    if (this.$tracker.isInForeground()) {
                        DeviceFileEntryNode deviceFileEntryNode = ViewListener.access$getTreeNodeFromEntry(this.this$0, this.$treeNode, entryFullPath);
                        Intrinsics.checkNotNull((Object)deviceFileEntryNode);
                        DeviceFileEntryNode currentNode = deviceFileEntryNode;
                        DeviceFileExplorerControllerImpl.access$stopNodeDownload(this.this$1, currentNode);
                    }
                }

                @AnyThread
                public boolean isCancelled() {
                    return this.$tracker.isCancelled();
                }
            }, (Continuation<? super VirtualFile>)$continuation);
            if (v2 == var10_7) {
                return var10_7;
            }
            ** GOTO lbl42
            {
                case 2: {
                    stopwatch = (Stopwatch)$continuation.L$2;
                    sizeRef = (CompletableDeferred)$continuation.L$1;
                    entry = (DeviceFileEntry)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    DeviceFileExplorerControllerImpl.access$getLOGGER$cp().trace("Downloaded file in " + stopwatch + ": " + entry.getFullPath());
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 3;
                    v3 = sizeRef.await((Continuation)$continuation);
                    if (v3 == var10_7) {
                        return var10_7;
                    }
                    ** GOTO lbl54
                }
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl54:
                    // 2 sources

                    return v3;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public void treeNodeExpanding(@NotNull DeviceFileEntryNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            BuildersKt.launch$default((CoroutineScope)DeviceFileExplorerControllerImpl.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, node, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ DeviceFileEntryNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ViewListener.access$loadNodeChildren(this.this$0, this.$node, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final Object loadNodeChildren(DeviceFileEntryNode var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof loadNodeChildren.1)) ** GOTO lbl-1000
            var24_3 = var2_2;
            if ((var24_3.label & -2147483648) != 0) {
                var24_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$loadNodeChildren(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_6 = node.getEntry().getFullPath();
                    if (new Regex("^/data/data/[^/]+$").matches(var3_6)) {
                        DeviceFileExplorerControllerImpl.access$trackAction(DeviceFileExplorerControllerImpl.this, DeviceExplorerEvent.Action.EXPAND_APP_DATA);
                    }
                    if (node.isLoaded()) {
                        return Unit.INSTANCE;
                    }
                    node.setLoaded(true);
                    if (node.isLeaf()) {
                        return Unit.INSTANCE;
                    }
                    treeModel = DeviceFileExplorerControllerImpl.access$getTreeModel(DeviceFileExplorerControllerImpl.this);
                    treeSelectionModel = DeviceFileExplorerControllerImpl.access$getTreeSelectionModel(DeviceFileExplorerControllerImpl.this);
                    if (treeModel == null || treeSelectionModel == null) {
                        return Unit.INSTANCE;
                    }
                    fileSystem = DeviceFileExplorerControllerImpl.access$getModel$p(DeviceFileExplorerControllerImpl.this).getActiveDevice();
                    if (!Intrinsics.areEqual((Object)fileSystem, (Object)node.getEntry().getFileSystem())) {
                        return Unit.INSTANCE;
                    }
                    showLoadingNode = new Runnable(DeviceFileExplorerControllerImpl.this, treeModel, node){
                        final /* synthetic */ DeviceFileExplorerControllerImpl this$0;
                        final /* synthetic */ DefaultTreeModel $treeModel;
                        final /* synthetic */ DeviceFileEntryNode $node;
                        {
                            this.this$0 = $receiver;
                            this.$treeModel = $treeModel;
                            this.$node = $node;
                        }

                        public final void run() {
                            DeviceFileExplorerControllerImpl.access$showLoadingNode(this.this$0, this.$treeModel, this.$node);
                        }
                    };
                    DeviceFileExplorerControllerImpl.access$getLoadingNodesAlarms$p(DeviceFileExplorerControllerImpl.this).addRequest(showLoadingNode, DeviceFileExplorerControllerImpl.this.getShowLoadingNodeDelayMillis());
                    DeviceFileExplorerControllerImpl.access$startLoadChildren(DeviceFileExplorerControllerImpl.this, node);
                    $continuation.L$0 = this;
                    $continuation.L$1 = node;
                    $continuation.L$2 = treeModel;
                    $continuation.L$3 = treeSelectionModel;
                    $continuation.L$4 = showLoadingNode;
                    $continuation.label = 1;
                    v0 = node.getEntry().entries((Continuation<? super List<? extends DeviceFileEntry>>)$continuation);
                    ** if (v0 != var25_5) goto lbl41
lbl40:
                    // 1 sources

                    return var25_5;
lbl41:
                    // 1 sources

                    ** GOTO lbl52
                }
                case 1: {
                    showLoadingNode = (Runnable)$continuation.L$4;
                    treeSelectionModel = (DefaultTreeSelectionModel)$continuation.L$3;
                    treeModel = (DefaultTreeModel)$continuation.L$2;
                    node = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl52:
                    // 2 sources

                    entries = (List)v0;
                    if (Intrinsics.areEqual((Object)treeModel, (Object)DeviceFileExplorerControllerImpl.access$getTreeModel(DeviceFileExplorerControllerImpl.this))) ** GOTO lbl60
                    var8_13 = Unit.INSTANCE;
                    DeviceFileExplorerControllerImpl.access$stopLoadChildren(DeviceFileExplorerControllerImpl.this, node);
                    DeviceFileExplorerControllerImpl.access$getLoadingNodesAlarms$p(DeviceFileExplorerControllerImpl.this).cancelRequest(showLoadingNode);
                    return var8_13;
lbl60:
                    // 2 sources

                    oldSelections = treeSelectionModel.getSelectionPaths();
                    v1 = node.getChildEntryNodes();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"node.childEntryNodes");
                    $this$filter$iv = v1;
                    $i$f$filter = false;
                    var12_19 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (DeviceFileEntryNode)element$iv$iv;
                        $i$a$-filter-DeviceFileExplorerControllerImpl$ViewListener$loadNodeChildren$isLinkToDirectory$1 = false;
                        if (!it.isSymbolicLinkToDirectory()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (DeviceFileEntryNode)item$iv$iv;
                        var22_28 = destination$iv$iv;
                        $i$a$-map-DeviceFileExplorerControllerImpl$ViewListener$loadNodeChildren$isLinkToDirectory$2 = false;
                        var22_28.add(it.getEntry().getName());
                    }
                    isLinkToDirectory = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    comparator = new NodeSorting.CustomComparator<V>(loadNodeChildren.comparator.1.INSTANCE, (Function1)new Function1<DeviceFileEntry, Boolean>((Set<String>)isLinkToDirectory){
                        final /* synthetic */ Set<String> $isLinkToDirectory;
                        {
                            this.$isLinkToDirectory = $isLinkToDirectory;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull DeviceFileEntry it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it.isDirectory() || this.$isLinkToDirectory.contains(it.getName());
                        }
                    });
                    addedNodes = this.updateChildrenNodes(treeModel, node, CollectionsKt.sortedWith((Iterable)entries, (Comparator)comparator));
                    DeviceFileExplorerControllerImpl.access$getLOGGER$cp().debug("Number of nodes added: " + addedNodes.size());
                    DeviceFileExplorerControllerImpl.access$getLoadingNodesAlarms$p(DeviceFileExplorerControllerImpl.this).cancelRequest(showLoadingNode);
                    Intrinsics.checkNotNullExpressionValue((Object)oldSelections, (String)"oldSelections");
                    this.restoreTreeSelection(treeSelectionModel, oldSelections, node);
                    $this$filter$iv = addedNodes;
                    $i$f$filter = false;
                    var15_22 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (DeviceFileEntryNode)element$iv$iv;
                        $i$a$-filter-DeviceFileExplorerControllerImpl$ViewListener$loadNodeChildren$symlinkNodes$1 = false;
                        if (!it.getEntry().isSymbolicLink()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    symlinkNodes = (List)destination$iv$iv;
                    $continuation.L$0 = this;
                    $continuation.L$1 = node;
                    $continuation.L$2 = treeModel;
                    $continuation.L$3 = showLoadingNode;
                    $continuation.L$4 = null;
                    $continuation.label = 2;
                    v2 = this.querySymbolicLinks(symlinkNodes, treeModel, (Continuation<? super Unit>)$continuation);
                    ** if (v2 != var25_5) goto lbl117
lbl116:
                    // 1 sources

                    return var25_5;
lbl117:
                    // 1 sources

                    ** GOTO lbl146
                }
                case 2: {
                    showLoadingNode = (Runnable)$continuation.L$3;
                    treeModel = (DefaultTreeModel)$continuation.L$2;
                    node = (DeviceFileEntryNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl146
                    }
                    catch (Throwable t) {
                        v3 = Strings.emptyToNull((String)ExceptionUtil.getRootCause((Throwable)t).getMessage());
                        if (v3 == null) {
                            v3 = "Unable to list entries of directory " + this.getUserFacingNodeName(node);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"emptyToNull(ExceptionUti\u2026serFacingNodeName(node)}\"");
                        message = v3;
                        node.removeAllChildren();
                        node.add(new ErrorNode(message));
                        node.setAllowsChildren(true);
                        treeModel.nodeStructureChanged(node);
                        throw t;
                    }
                }
                catch (Throwable var7_12) {
                    throw var7_12;
                }
                {
                    finally {
                        DeviceFileExplorerControllerImpl.access$stopLoadChildren(DeviceFileExplorerControllerImpl.this, node);
                        DeviceFileExplorerControllerImpl.access$getLoadingNodesAlarms$p(DeviceFileExplorerControllerImpl.this).cancelRequest(showLoadingNode);
                    }
lbl146:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final List<DeviceFileEntryNode> updateChildrenNodes(DefaultTreeModel treeModel, DeviceFileEntryNode parentNode, List<? extends DeviceFileEntry> newEntries) {
            TreeUtil.UpdateChildrenOps updateChildrenOps2 = new TreeUtil.UpdateChildrenOps<DeviceFileEntryNode, DeviceFileEntry>(){

                @Nullable
                public DeviceFileEntryNode getChildNode(@NotNull DeviceFileEntryNode parentNode, int index2) {
                    Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
                    return DeviceFileEntryNode.fromNode(parentNode.getChildAt(index2));
                }

                @NotNull
                public DeviceFileEntryNode mapEntry(@NotNull DeviceFileEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return new DeviceFileEntryNode(entry);
                }

                public int compareNodeWithEntry(@NotNull DeviceFileEntryNode node, @NotNull DeviceFileEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return node.getEntry().getName().compareTo(entry.getName());
                }

                public void updateNode(@NotNull DeviceFileEntryNode node, @NotNull DeviceFileEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    node.setEntry(entry);
                }
            };
            List<MutableTreeNode> list2 = TreeUtil.updateChildrenNodes(treeModel, (MutableTreeNode)parentNode, newEntries, updateChildrenOps2);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"updateChildrenNodes(tree\u2026tries, updateChildrenOps)");
            List<MutableTreeNode> addedNodes = list2;
            parentNode.setAllowsChildren(parentNode.getChildCount() > 0);
            return addedNodes;
        }

        private final void restoreTreeSelection(DefaultTreeSelectionModel treeSelectionModel, TreePath[] oldSelections, DefaultMutableTreeNode parentNode) {
            Set newSelections = new HashSet();
            TreePath parentPath = new TreePath(parentNode.getPath());
            for (TreePath oldSelection : oldSelections) {
                this.restorePathSelection(treeSelectionModel, parentPath, oldSelection, newSelections);
            }
            TreePath[] newSelectionArray = (TreePath[])ArrayUtil.toObjectArray((Collection)new ArrayList(newSelections), TreePath.class);
            treeSelectionModel.addSelectionPaths(newSelectionArray);
        }

        private final void restorePathSelection(DefaultTreeSelectionModel treeSelectionModel, TreePath parentPath, TreePath oldPath, Set<TreePath> selections) {
            if (treeSelectionModel.isPathSelected(oldPath)) {
                return;
            }
            if (Intrinsics.areEqual((Object)parentPath, (Object)oldPath)) {
                return;
            }
            if (!parentPath.isDescendant(oldPath)) {
                return;
            }
            Object object = parentPath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.TreeNode");
            TreeNode node = (TreeNode)object;
            TreeNode existingChild2 = TreeUtil.getChildren(node).filter(new Predicate(oldPath){
                final /* synthetic */ TreePath $oldPath;
                {
                    this.$oldPath = $oldPath;
                }

                public final boolean test(@Nullable TreeNode x) {
                    return Intrinsics.areEqual((Object)x, (Object)this.$oldPath.getLastPathComponent());
                }
            }).findFirst().orElse(null);
            if (existingChild2 == null) {
                selections.add(parentPath);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final Object querySymbolicLinks(List<? extends DeviceFileEntryNode> var1_1, DefaultTreeModel var2_2, Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof querySymbolicLinks.1)) ** GOTO lbl-1000
            var11_4 = var3_3;
            if ((var11_4.label & -2147483648) != 0) {
                var11_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$querySymbolicLinks(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_7 = symlinkNodes.iterator();
lbl13:
                    // 4 sources

                    while (var4_7.hasNext()) {
                        treeNode = (DeviceFileEntryNode)var4_7.next();
                        $continuation.L$0 = this;
                        $continuation.L$1 = treeModel;
                        $continuation.L$2 = var4_7;
                        $continuation.L$3 = treeNode;
                        $continuation.label = 1;
                        v0 = treeNode.getEntry().isSymbolicLinkToDirectory((Continuation<? super Boolean>)$continuation);
                        ** if (v0 != var12_6) goto lbl25
lbl24:
                        // 1 sources

                        return var12_6;
lbl25:
                        // 1 sources

                        ** GOTO lbl36
                    }
                    break;
                }
                case 1: {
                    treeNode = (DeviceFileEntryNode)$continuation.L$3;
                    var4_7 = (Iterator)$continuation.L$2;
                    treeModel = (DefaultTreeModel)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        var7_10 = (Boolean)v0;
                    }
                    catch (Throwable t) {
                        DeviceFileExplorerControllerImpl.access$getLOGGER$cp().info("Error determining if file entry \"" + treeNode.getEntry().getName() + "\" is a link to a directory", t);
                        var7_10 = false;
                    }
                    isDirectory = var7_10;
                    if (!Intrinsics.areEqual((Object)DeviceFileExplorerControllerImpl.access$getModel$p(DeviceFileExplorerControllerImpl.this).getTreeModel(), (Object)treeModel)) {
                        return Unit.INSTANCE;
                    }
                    if (treeNode.isSymbolicLinkToDirectory() == isDirectory) ** GOTO lbl13
                    v1 = treeNode.getParent();
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
                    parent = (MutableTreeNode)v1;
                    previousIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.TreeNodeComparator.INSTANCE);
                    if (previousIndex >= 0) {
                        treeModel.removeNodeFromParent(treeNode);
                    }
                    treeNode.setSymbolicLinkToDirectory(isDirectory != false);
                    newIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.TreeNodeComparator.INSTANCE);
                    if (newIndex >= 0) ** GOTO lbl13
                    treeModel.insertNodeInto(treeNode, parent, -(newIndex + 1));
                    ** GOTO lbl13
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String getUserFacingNodeName(DeviceFileEntryNode node) {
            return StringUtil.isEmpty((String)node.getEntry().getName()) ? "[root]" : "\"" + node.getEntry().getName() + "\"";
        }

        public static final /* synthetic */ Object access$downloadAndOpenFile(ViewListener $this, DeviceFileEntryNode treeNode, Continuation $completion) {
            return $this.downloadAndOpenFile(treeNode, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$openFile(ViewListener $this, DeviceFileEntryNode treeNode, Path localPath, Continuation $completion) {
            return $this.openFile(treeNode, localPath, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$downloadFileEntryToDefaultLocation(ViewListener $this, DeviceFileEntryNode treeNode, Continuation $completion) {
            return $this.downloadFileEntryToDefaultLocation(treeNode, (Continuation<? super Path>)$completion);
        }

        public static final /* synthetic */ String access$getUserFacingNodeName(ViewListener $this, DeviceFileEntryNode node) {
            return $this.getUserFacingNodeName(node);
        }

        public static final /* synthetic */ Object access$downloadFileEntry(ViewListener $this, DeviceFileEntryNode treeNode, Path localPath, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.downloadFileEntry(treeNode, localPath, tracker, (Continuation<? super Long>)$completion);
        }

        public static final /* synthetic */ Object access$saveSingleNodeAs(ViewListener $this, DeviceFileEntryNode treeNode, Continuation $completion) {
            return $this.saveSingleNodeAs(treeNode, (Continuation<? super FileTransferSummary>)$completion);
        }

        public static final /* synthetic */ Object access$saveMultiNodesAs(ViewListener $this, DeviceFileEntryNode commonParentNode, List treeNodes, Continuation $completion) {
            return $this.saveMultiNodesAs(commonParentNode, treeNodes, (Continuation<? super FileTransferSummary>)$completion);
        }

        public static final /* synthetic */ void access$reportSaveNodesAsSummary(ViewListener $this, DeviceFileEntryNode node, FileTransferSummary summary) {
            $this.reportSaveNodesAsSummary(node, summary);
        }

        public static final /* synthetic */ Object access$downloadSingleDirectory(ViewListener $this, DeviceFileEntryNode treeNode, Path localDirectoryPath, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.downloadSingleDirectory(treeNode, localDirectoryPath, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$downloadSingleFile(ViewListener $this, DeviceFileEntryNode treeNode, Path localPath, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.downloadSingleFile(treeNode, localPath, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$downloadSingleNode(ViewListener $this, DeviceFileEntryNode node, Path localPath, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.downloadSingleNode(node, localPath, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$wrapFileTransfer(ViewListener $this, Function2 prepareTransfer, Function2 performTransfer, boolean backgroundable, Continuation $completion) {
            return $this.wrapFileTransfer((Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)prepareTransfer, (Function2<? super FileTransferOperationTracker, ? super Continuation<? super Unit>, ? extends Object>)performTransfer, backgroundable, (Continuation<? super FileTransferSummary>)$completion);
        }

        public static final /* synthetic */ Object access$newFileOrDirectory(ViewListener $this, DeviceFileEntryNode parentTreeNode, String initialName, String title, String prompt, String emptyErrorMessage, Function1 errorMessage, Function2 createFunction, Continuation $completion) {
            return $this.newFileOrDirectory(parentTreeNode, initialName, title, prompt, emptyErrorMessage, (Function1<? super String, String>)errorMessage, (Function2<? super String, ? super Continuation<? super Unit>, ? extends Object>)createFunction, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$loadNodeChildren(ViewListener $this, DeviceFileEntryNode node, Continuation $completion) {
            return $this.loadNodeChildren(node, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$reportDeletionProblem(ViewListener $this, List problems) {
            $this.reportDeletionProblem(problems);
        }

        public static final /* synthetic */ Object access$uploadVirtualFilesInvoked(ViewListener $this, DeviceFileEntryNode treeNode, List files2, DeviceExplorerEvent.Action action2, Continuation $completion) {
            return $this.uploadVirtualFilesInvoked(treeNode, files2, action2, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$uploadVirtualFiles(ViewListener $this, DeviceFileEntryNode parentNode, List files2, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.uploadVirtualFiles(parentNode, files2, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$uploadVirtualFile(ViewListener $this, DeviceFileEntryNode treeNode, VirtualFile file2, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.uploadVirtualFile(treeNode, file2, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$uploadDirectory(ViewListener $this, DeviceFileEntryNode parentNode, VirtualFile file2, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.uploadDirectory(parentNode, file2, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$uploadFile(ViewListener $this, DeviceFileEntryNode parentNode, VirtualFile file2, FileTransferOperationTracker tracker, Continuation $completion) {
            return $this.uploadFile(parentNode, file2, tracker, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$chooseSaveAsFilePath(ViewListener $this, DeviceFileEntryNode treeNode, Continuation $completion) {
            return $this.chooseSaveAsFilePath(treeNode, (Continuation<? super Path>)$completion);
        }

        public static final /* synthetic */ Object access$chooseSaveAsDirectoryPath(ViewListener $this, DeviceFileEntryNode treeNode, Continuation $completion) {
            return $this.chooseSaveAsDirectoryPath(treeNode, (Continuation<? super Path>)$completion);
        }

        public static final /* synthetic */ DeviceFileEntryNode access$getTreeNodeFromEntry(ViewListener $this, DeviceFileEntryNode treeNode, String entryFullPath) {
            return $this.getTreeNodeFromEntry(treeNode, entryFullPath);
        }

        public static final /* synthetic */ Object access$querySymbolicLinks(ViewListener $this, List symlinkNodes, DefaultTreeModel treeModel, Continuation $completion) {
            return $this.querySymbolicLinks(symlinkNodes, treeModel, (Continuation<? super Unit>)$completion);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$ViewListener$UploadFileState;", "", "loadChildrenJob", "Lkotlinx/coroutines/Job;", "childNode", "Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "byteCount", "", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerControllerImpl$ViewListener;Lkotlinx/coroutines/Job;Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;J)V", "getByteCount", "()J", "setByteCount", "(J)V", "getChildNode", "()Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;", "setChildNode", "(Lcom/android/tools/idea/device/explorer/files/DeviceFileEntryNode;)V", "getLoadChildrenJob", "()Lkotlinx/coroutines/Job;", "setLoadChildrenJob", "(Lkotlinx/coroutines/Job;)V", "intellij.android.device-explorer-files"})
        private final class UploadFileState {
            @Nullable
            private Job loadChildrenJob;
            @Nullable
            private DeviceFileEntryNode childNode;
            private long byteCount;
            final /* synthetic */ ViewListener this$0;

            public UploadFileState(@Nullable ViewListener this$0, @Nullable Job loadChildrenJob, DeviceFileEntryNode childNode, long byteCount) {
                this.this$0 = this$0;
                this.loadChildrenJob = loadChildrenJob;
                this.childNode = childNode;
                this.byteCount = byteCount;
            }

            public /* synthetic */ UploadFileState(ViewListener viewListener, Job job2, DeviceFileEntryNode deviceFileEntryNode, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    job2 = null;
                }
                if ((n & 2) != 0) {
                    deviceFileEntryNode = null;
                }
                if ((n & 4) != 0) {
                    l = 0L;
                }
                this(viewListener, job2, deviceFileEntryNode, l);
            }

            @Nullable
            public final Job getLoadChildrenJob() {
                return this.loadChildrenJob;
            }

            public final void setLoadChildrenJob(@Nullable Job job2) {
                this.loadChildrenJob = job2;
            }

            @Nullable
            public final DeviceFileEntryNode getChildNode() {
                return this.childNode;
            }

            public final void setChildNode(@Nullable DeviceFileEntryNode deviceFileEntryNode) {
                this.childNode = deviceFileEntryNode;
            }

            public final long getByteCount() {
                return this.byteCount;
            }

            public final void setByteCount(long l) {
                this.byteCount = l;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceState.values().length];
            try {
                nArray[DeviceState.UNAUTHORIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceState.OFFLINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

