/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debuggers.coroutine;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Sites;
import com.android.tools.idea.debuggers.coroutine.CoroutineDebuggerAnalyticsTracker;
import com.android.tools.idea.debuggers.coroutine.CoroutineDebuggerSettings;
import com.android.tools.idea.debuggers.coroutine.FlagController;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.intellij.execution.Executor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/debuggers/coroutine/CoroutineDebuggerLaunchTaskContributor;", "Lcom/android/tools/idea/run/AndroidLaunchTaskContributor;", "()V", "getAmStartOptions", "", "applicationId", "configuration", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "device", "Lcom/android/ddmlib/IDevice;", "executor", "Lcom/intellij/execution/Executor;", "getTask", "Lcom/android/tools/idea/run/tasks/LaunchTask;", "intellij.android.debuggers"})
public final class CoroutineDebuggerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    @Override
    @Nullable
    public LaunchTask getTask(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration, @NotNull IDevice device2, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        return null;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration, @NotNull IDevice device2, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        if (!FlagController.INSTANCE.isCoroutineDebuggerEnabled().booleanValue()) {
            return "";
        }
        if (!Intrinsics.areEqual((Object)"Debug", (Object)executor2.getId())) {
            return "";
        }
        if (!device2.getVersion().isGreaterOrEqualThan(29)) {
            return "";
        }
        boolean isCoroutineDebuggerEnabledInSettings = CoroutineDebuggerSettings.INSTANCE.isCoroutineDebuggerEnabled();
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        CoroutineDebuggerAnalyticsTracker.Companion.getInstance(project).trackLaunchEvent(!isCoroutineDebuggerEnabledInSettings);
        if (!isCoroutineDebuggerEnabledInSettings) {
            return "";
        }
        String appCodeCache = Sites.appCodeCache((String)applicationId2);
        return "--attach-agent " + appCodeCache + "coroutine_debugger_agent.so";
    }
}

