/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.android.tools.sdk.AndroidSdkData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.StudioAndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectResourceIdResolver
implements ResourceIdResolver {
    @NotNull
    private static final List<String> myPublicFileNames = ImmutableList.of((Object)"public.xml", (Object)"public-final.xml", (Object)"public-staging.xml");
    @NotNull
    private static final Object myPublicResourceIdMapLock = new Object();
    @NotNull
    private static final Map<IAndroidTarget, Int2ObjectMap<String>> myPublicResourceIdMap = new WeakHashMap<IAndroidTarget, Int2ObjectMap<String>>();
    @NotNull
    private static final Logger LOG = Logger.getInstance(ProjectResourceIdResolver.class);
    private final Project myProject;
    private Int2ObjectMap<String> myIdMap;
    private boolean myInitialized;

    @NotNull
    public static ResourceIdResolver getInstance(@NotNull Project project) {
        return (ResourceIdResolver)project.getService(ResourceIdResolver.class);
    }

    private ProjectResourceIdResolver(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public String getAndroidResourceName(int resId) {
        if (!this.myInitialized) {
            this.myIdMap = this.getIdMap();
            this.myInitialized = true;
        }
        return this.myIdMap == null ? null : (String)this.myIdMap.get(resId);
    }

    @NotNull
    private static Int2ObjectMap<String> buildPublicResourceIdMap(@NotNull IAndroidTarget target2) {
        Path resDirPath = target2.getPath(11);
        Int2ObjectOpenHashMap resourceIdMap = new Int2ObjectOpenHashMap();
        for (String fileName : myPublicFileNames) {
            Path publicXmlPath = resDirPath.resolve("values").resolve(fileName);
            VirtualFile publicXml = LocalFileSystem.getInstance().findFileByNioFile(publicXmlPath);
            if (publicXml == null) continue;
            try {
                MyPublicResourceIdMapBuilder builder2 = new MyPublicResourceIdMapBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder2);
                builder2.getIdMap().forEachEntry((arg_0, arg_1) -> ProjectResourceIdResolver.lambda$buildPublicResourceIdMap$0((Int2ObjectMap)resourceIdMap, arg_0, arg_1));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return resourceIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Int2ObjectMap<String> getPublicIdMap(@NotNull IAndroidTarget target2) {
        Object object = myPublicResourceIdMapLock;
        synchronized (object) {
            return myPublicResourceIdMap.computeIfAbsent(target2, ProjectResourceIdResolver::buildPublicResourceIdMap);
        }
    }

    private Int2ObjectMap<String> getIdMap() {
        AndroidSdkData sdkData;
        Module m;
        AndroidFacet facet2 = null;
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n && (facet2 = AndroidFacet.getInstance((Module)(m = moduleArray[i]))) == null; ++i) {
        }
        AndroidSdkData androidSdkData = sdkData = facet2 == null ? null : StudioAndroidSdkData.getSdkData(facet2);
        if (sdkData == null) {
            return null;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            return null;
        }
        return ProjectResourceIdResolver.getPublicIdMap(targets[targets.length - 1]);
    }

    private static /* synthetic */ boolean lambda$buildPublicResourceIdMap$0(Int2ObjectMap resourceIdMap, int key, String value2) {
        resourceIdMap.put(key, (Object)value2);
        return true;
    }

    @VisibleForTesting
    static class MyPublicResourceIdMapBuilder
    implements NanoXmlBuilder {
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;
        private boolean inGroup;

        MyPublicResourceIdMapBuilder() {
        }

        public void elementAttributesProcessed(String name2, String nsPrefix, String nsURI) {
            if ("public".equals(name2) && this.myName != null && this.myType != null && this.myId != 0) {
                this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                if (this.inGroup) {
                    ++this.myId;
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) {
            switch (key) {
                case "name": {
                    this.myName = value2;
                    break;
                }
                case "type": {
                    this.myType = value2;
                    break;
                }
                case "first-id": 
                case "id": {
                    try {
                        this.myId = Integer.decode(value2);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.myId = 0;
                    }
                }
            }
        }

        public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (!this.inGroup) {
                this.myType = null;
                this.myId = 0;
            }
            if ("public-group".equals(name2)) {
                this.inGroup = true;
            }
            this.myName = null;
        }

        public void endElement(String name2, String nsPrefix, String nsURI) {
            if ("public-group".equals(name2)) {
                this.inGroup = false;
            }
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }
}

