/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayMapRendererBase
extends NodeRendererImpl {
    private static final int MAX_CHILDREN = 10;
    @NonNls
    private static final String MORE_ELEMENTS = "...";
    private final String myFqn;
    private final LabelRenderer myLabelRenderer = new LabelRenderer();
    private final MyArrayMapSizeEvaluator mySizeEvaluator = new MyArrayMapSizeEvaluator();

    public ArrayMapRendererBase(@NotNull String mapFqn) {
        super("unnamed", true);
        this.myProperties.setName(mapFqn);
        this.myFqn = mapFqn;
    }

    public void buildChildren(Value value2, ChildrenBuilder builder2, EvaluationContext evaluationContext) {
        int size;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayList<DebuggerTreeNodeImpl> children2 = new ArrayList<DebuggerTreeNodeImpl>();
        NodeManagerImpl nodeManager = (NodeManagerImpl)builder2.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder2.getDescriptorManager();
        try {
            size = this.getArrayMapSize(value2, evaluationContext);
        }
        catch (Exception e) {
            size = 0;
        }
        int n = Math.min(size, 10);
        for (int i = 0; i < n; ++i) {
            String expression2 = String.format("new AbstractMap.SimpleEntry(this.keyAt(%1$d), this.valueAt(%2$d)", i, i);
            UserExpressionData descriptorData = new UserExpressionData((ValueDescriptorImpl)builder2.getParentDescriptor(), this.myFqn, String.format(Locale.US, "entry[%1$d]", i), (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression2, "java.util.AbstractMap", (FileType)JavaFileType.INSTANCE));
            UserExpressionDescriptor userExpressionDescriptor = descriptorFactory.getUserExpressionDescriptor((NodeDescriptor)builder2.getParentDescriptor(), (DescriptorData)descriptorData);
            DebuggerTreeNodeImpl arrayMapItemNode = nodeManager.createNode((NodeDescriptor)userExpressionDescriptor, evaluationContext);
            children2.add(arrayMapItemNode);
        }
        if (size > 10) {
            children2.add(nodeManager.createMessageNode(new MessageDescriptor(MORE_ELEMENTS, 3)));
        }
        builder2.setChildren(children2);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context2) throws EvaluateException {
        return null;
    }

    public boolean isExpandable(Value value2, EvaluationContext context2, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.getArrayMapIsEmpty(value2, context2);
    }

    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        if (!(descriptor2.getValue() instanceof ObjectReference)) {
            return JavaDebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
        }
        ObjectReference ref = (ObjectReference)descriptor2.getValue();
        this.myLabelRenderer.setLabelExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)JavaFileType.INSTANCE));
        return ValueDescriptorImpl.getIdLabel((ObjectReference)ref) + ", size = " + this.myLabelRenderer.calcLabel(descriptor2, evaluationContext, listener2);
    }

    public String getUniqueId() {
        return this.myFqn;
    }

    public boolean isApplicable(@Nullable Type type) {
        return type != null && this.myFqn.equals(type.name());
    }

    private boolean getArrayMapIsEmpty(Value arrayMapValue, EvaluationContext context2) {
        try {
            return this.getArrayMapSize(arrayMapValue, context2) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getArrayMapSize(Value arrayMapValue, EvaluationContext context2) throws InvalidTypeException, EvaluateException {
        EvaluationContext evaluationContext = context2.createEvaluationContext(arrayMapValue);
        Value v = this.mySizeEvaluator.evaluate(evaluationContext.getProject(), evaluationContext);
        if (v instanceof IntegerValue) {
            return ((IntegerValue)v).intValue();
        }
        throw new InvalidTypeException();
    }

    private class MyArrayMapSizeEvaluator
    extends CachedEvaluator {
        public MyArrayMapSizeEvaluator() {
            this.setReferenceExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)JavaFileType.INSTANCE));
        }

        protected String getClassName() {
            return ArrayMapRendererBase.this.myFqn;
        }

        public Value evaluate(Project p, EvaluationContext context2) throws EvaluateException {
            return this.getEvaluator(p).evaluate(context2);
        }
    }
}

