/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.debug.DesugarUtils;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SdkInstallListener;
import com.android.tools.idea.sdk.sources.SdkSourcePositionFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSessionListener;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerImpl;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "myAndroidVersion", "Lcom/android/sdklib/AndroidVersion;", "createPrepareRequests", "", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getPsiFileByLocation", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "location", "Lcom/sun/jdi/Location;", "getSourcePosition", "refreshDebugSession", "", "getDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "MyXDebugSessionListener", "intellij.android.debuggers"})
@SourceDebugExtension(value={"SMAP\nAndroidPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n8#2:219\n8#2:220\n*S KotlinDebug\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager\n*L\n71#1:219\n212#1:220\n*E\n"})
public final class AndroidPositionManager
extends PositionManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final AndroidVersion myAndroidVersion;
    @NotNull
    private static final Logger LOG;

    public AndroidPositionManager(@NotNull DebugProcessImpl myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        super(myDebugProcess);
        this.myDebugProcess = myDebugProcess;
        this.myAndroidVersion = (AndroidVersion)this.myDebugProcess.getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
        Disposable disposable2 = this.getDisposable(this.myDebugProcess);
        if (disposable2 == null) {
            AndroidPositionManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(AndroidPositionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.warn("Cannot subscribe to OnDownloadedCallback");
        } else {
            this.myDebugProcess.getProject().getMessageBus().connect(disposable2).subscribe(SdkInstallListener.TOPIC, (Object)new SdkInstallListener(){

                @Override
                public final void installCompleted(@NotNull Collection<? extends UpdatablePackage> installed, @NotNull Collection<? extends LocalPackage> uninstalled) {
                    block9: {
                        block8: {
                            Object v2;
                            block7: {
                                Object v1;
                                UpdatablePackage it;
                                Iterable iterable;
                                String path2;
                                block6: {
                                    Intrinsics.checkNotNullParameter(installed, (String)"installed");
                                    Intrinsics.checkNotNullParameter(uninstalled, (String)"uninstalled");
                                    AndroidVersion androidVersion = myAndroidVersion;
                                    if (androidVersion == null) {
                                        return;
                                    }
                                    path2 = DetailsTypes.getSourcesPath((AndroidVersion)androidVersion);
                                    iterable = installed;
                                    for (Object t : iterable) {
                                        it = (UpdatablePackage)t;
                                        boolean bl = false;
                                        if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path2)) continue;
                                        v1 = t;
                                        break block6;
                                    }
                                    v1 = null;
                                }
                                if (v1 != null) break block8;
                                iterable = uninstalled;
                                for (Object t : iterable) {
                                    it = (LocalPackage)t;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)path2)) continue;
                                    v2 = t;
                                    break block7;
                                }
                                v2 = null;
                            }
                            if (v2 == null) break block9;
                        }
                        this.refreshDebugSession();
                    }
                }
            });
        }
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List<ReferenceType> list2 = DesugarUtils.addExtraClassesIfNeeded((DebugProcess)this.myDebugProcess, position, super.getAllClasses(position), (PositionManager)this);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"addExtraClassesIfNeeded(\u2026lClasses(position), this)");
        List<ReferenceType> referenceTypes = list2;
        if (referenceTypes.isEmpty()) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        return referenceTypes;
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List<ClassPrepareRequest> list2 = DesugarUtils.addExtraPrepareRequestsIfNeeded((DebugProcess)this.myDebugProcess, requestor, position, super.createPrepareRequests(requestor, position));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"addExtraPrepareRequestsI\u2026sts(requestor, position))");
        List<ClassPrepareRequest> requests2 = list2;
        if (requests2.isEmpty()) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        return requests2;
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return SetsKt.setOf((Object)JavaFileType.INSTANCE);
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        if (location == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (this.myAndroidVersion == null) {
            LOG.debug("getSourcePosition cannot determine version from device.");
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
        Project project2 = project;
        PsiFile file2 = this.getPsiFileByLocation(project2, location);
        if (file2 == null || !AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file2)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        return SdkSourcePositionFinder.Companion.getInstance(project2).getSourcePosition(this.myAndroidVersion.getApiLevel(), file2, location.lineNumber());
    }

    @VisibleForTesting
    @Nullable
    public PsiFile getPsiFileByLocation(@NotNull Project project, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return super.getPsiFileByLocation(project, location);
    }

    private final void refreshDebugSession() {
        DumbService.getInstance((Project)this.myDebugProcess.getProject()).smartInvokeLater(new Runnable(this){
            final /* synthetic */ AndroidPositionManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getManagerThread().invoke(PrioritizedTask.Priority.HIGH, new Runnable(this.this$0){
                    final /* synthetic */ AndroidPositionManager this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getPositionManager().clearCache();
                        ApplicationManager.getApplication().invokeLater(new Runnable(this.this$0){
                            final /* synthetic */ AndroidPositionManager this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final void run() {
                                AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getSession().refresh(true);
                            }
                        }, new Condition(this.this$0){
                            final /* synthetic */ AndroidPositionManager this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final boolean value(Object it) {
                                return AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getSession().isStopped();
                            }
                        });
                    }
                });
            }
        });
    }

    private final Disposable getDisposable(DebugProcessImpl $this$getDisposable) {
        Disposable disposable2;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            disposable2 = (Disposable)$this$getDisposable.getProject();
        } else {
            Disposable disposable3;
            try {
                Field field2 = DebugProcessImpl.class.getDeclaredField("myDisposable");
                field2.setAccessible(true);
                Object object = field2.get($this$getDisposable);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
                disposable3 = (Disposable)object;
            }
            catch (Exception e) {
                DebugProcessImpl $this$thisLogger$iv = $this$getDisposable;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(DebugProcessImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.warn("Could not get DebugProcessImpl.disposable");
                disposable3 = null;
            }
            disposable2 = disposable3;
        }
        return disposable2;
    }

    public static final /* synthetic */ DebugProcessImpl access$getMyDebugProcess$p(AndroidPositionManager $this) {
        return $this.myDebugProcess;
    }

    static {
        Logger logger2 = Logger.getInstance(AndroidPositionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidPositionManager::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\u0007*\u00020\u0007H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRelPathForJavaSource", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "changeClassExtensionToJava", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final String getRelPathForJavaSource(@NotNull Project project, @NotNull PsiFile file2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            FileType fileType = file2.getFileType();
            if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
                VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file2.getVirtualFile());
                if (sourceRoot == null) {
                    LOG.debug("Could not determine source root for file: " + file2.getVirtualFile().getPath());
                    string = null;
                } else {
                    string = VfsUtilCore.getRelativePath((VirtualFile)file2.getVirtualFile(), (VirtualFile)sourceRoot);
                }
            } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
                String relativeClassPath;
                VirtualFile virtualFile = file2.getVirtualFile();
                String string2 = relativeClassPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)VfsUtilCore.getRootFile((VirtualFile)virtualFile));
                string = string2 != null ? this.changeClassExtensionToJava(string2) : null;
            } else {
                string = null;
            }
            return string;
        }

        @VisibleForTesting
        @NotNull
        public final String changeClassExtensionToJava(@NotNull String $this$changeClassExtensionToJava) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$changeClassExtensionToJava, (String)"<this>");
            if (StringsKt.endsWith$default((String)$this$changeClassExtensionToJava, (String)".class", (boolean)false, (int)2, null)) {
                String string = $this$changeClassExtensionToJava.substring(0, $this$changeClassExtensionToJava.length() - 6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = string + ".java";
            } else {
                object = $this$changeClassExtensionToJava;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00030\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "fileToClose", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "myFileToClose", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "myProject", "sessionStopped", "", "intellij.android.debuggers"})
    @SourceDebugExtension(value={"SMAP\nAndroidPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,218:1\n1#2:219\n48#3,13:220\n*S KotlinDebug\n*F\n+ 1 AndroidPositionManager.kt\ncom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener\n*L\n143#1:220,13\n*E\n"})
    public static final class MyXDebugSessionListener
    implements XDebugSessionListener {
        @NotNull
        private final WeakReference<VirtualFile> myFileToClose;
        @NotNull
        private final Project myProject;

        @VisibleForTesting
        public MyXDebugSessionListener(@NotNull VirtualFile fileToClose, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)fileToClose, (String)"fileToClose");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.myFileToClose = new WeakReference<VirtualFile>(fileToClose);
            this.myProject = project;
        }

        public void sessionStopped() {
            block2: {
                VirtualFile virtualFile = (VirtualFile)this.myFileToClose.get();
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                Object modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl2 = false;
                    FileEditorManager.getInstance((Project)this.myProject).closeFile(it);
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, it){
                        final /* synthetic */ MyXDebugSessionListener this$0;
                        final /* synthetic */ VirtualFile $it$inlined;
                        {
                            this.this$0 = myXDebugSessionListener;
                            this.$it$inlined = virtualFile;
                        }

                        public final void run() {
                            boolean bl = false;
                            FileEditorManager.getInstance((Project)MyXDebugSessionListener.access$getMyProject$p(this.this$0)).closeFile(this.$it$inlined);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
        }
    }
}

