/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetAdbAction
extends AnAction {
    public GetAdbAction() {
        super("Get ADB");
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = GetAdbAction.getEventProject((AnActionEvent)e);
        File adb = project == null ? null : this.getAdbFile(project);
        e.getPresentation().setEnabled(adb != null && adb.exists());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        File adb;
        Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB requested.", NotificationType.INFORMATION));
        Project project = GetAdbAction.getEventProject((AnActionEvent)e);
        File file2 = adb = project == null ? null : this.getAdbFile(project);
        if (adb == null) {
            return;
        }
        ListenableFuture<AndroidDebugBridge> bridge = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(bridge, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge result2) {
                Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB obtained", NotificationType.INFORMATION));
            }

            public void onFailure(Throwable t) {
                Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB error: " + t.toString(), NotificationType.INFORMATION));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Nullable
    private File getAdbFile(@NotNull Project project) {
        return AdbFileProvider.fromProject(project).get();
    }
}

