/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002:\u0003%&'B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB1\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a*\u00020\u0010H\u0002R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000fj\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0\u000fj\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesProvider;", "parent", "(Lcom/intellij/openapi/Disposable;)V", "uiCallback", "Lcom/google/common/util/concurrent/FutureCallback;", "Lcom/android/tools/idea/ddms/DeviceNameProperties;", "(Lcom/intellij/openapi/Disposable;Lcom/google/common/util/concurrent/FutureCallback;)V", "isDisposed", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/Disposable;Lcom/google/common/util/concurrent/FutureCallback;Lkotlin/jvm/functions/Function1;)V", "defaultValue", "deviceNamePropertiesMap", "Ljava/util/HashMap;", "Lcom/android/ddmlib/IDevice;", "Lkotlin/collections/HashMap;", "edtExecutor", "Lcom/intellij/util/concurrency/EdtExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "myDeviceChangeListener", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DeviceChangeListener;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "tasksMap", "Lcom/google/common/util/concurrent/ListenableFuture;", "assertThreadMatch", "", "callBy", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$ThreadType;", "dispose", "get", "device", "isRetrieving", "startRetriever", "getDeviceSystemProperties", "DefaultCallback", "DeviceChangeListener", "ThreadType", "intellij.android.adb"})
@SourceDebugExtension(value={"SMAP\nDeviceNamePropertiesFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceNamePropertiesFetcher.kt\ncom/android/tools/idea/ddms/DeviceNamePropertiesFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class DeviceNamePropertiesFetcher
implements Disposable,
DeviceNamePropertiesProvider {
    @NotNull
    private final Disposable parent;
    @NotNull
    private final FutureCallback<DeviceNameProperties> uiCallback;
    @NotNull
    private final Function1<Disposable, Boolean> isDisposed;
    @NotNull
    private final EdtExecutorService edtExecutor;
    @NotNull
    private final ExecutorService taskExecutor;
    @NotNull
    private final DeviceNameProperties defaultValue;
    @NotNull
    private final HashMap<IDevice, ListenableFuture<DeviceNameProperties>> tasksMap;
    @NotNull
    private final HashMap<IDevice, DeviceNameProperties> deviceNamePropertiesMap;
    @NotNull
    private final DeviceChangeListener myDeviceChangeListener;

    @VisibleForTesting
    public DeviceNamePropertiesFetcher(@NotNull Disposable parent2, @NotNull FutureCallback<DeviceNameProperties> uiCallback, @NotNull Function1<? super Disposable, Boolean> isDisposed) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        Intrinsics.checkNotNullParameter(isDisposed, (String)"isDisposed");
        this.parent = parent2;
        this.uiCallback = uiCallback;
        this.isDisposed = isDisposed;
        EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance()");
        this.edtExecutor = edtExecutorService;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DeviceNamePropertiesFetcher");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicat\u2026ceNamePropertiesFetcher\")");
        this.taskExecutor = executorService;
        this.defaultValue = new DeviceNameProperties(null, null, null, null);
        this.tasksMap = new HashMap();
        this.deviceNamePropertiesMap = new HashMap();
        this.myDeviceChangeListener = new DeviceChangeListener();
        Disposer.register((Disposable)this.parent, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
    }

    public DeviceNamePropertiesFetcher(@NotNull Disposable parent2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        this(parent2, (FutureCallback<DeviceNameProperties>)((FutureCallback)new DefaultCallback()));
    }

    public DeviceNamePropertiesFetcher(@NotNull Disposable parent2, @NotNull FutureCallback<DeviceNameProperties> uiCallback) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        this(parent2, uiCallback, (Function1<? super Disposable, Boolean>)((Function1)1.INSTANCE));
    }

    private final ListenableFuture<DeviceNameProperties> getDeviceSystemProperties(IDevice $this$getDeviceSystemProperties) {
        Object[] objectArray = new Future[4];
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.product.model"), (String)"getSystemProperty(IDevice.PROP_DEVICE_MODEL)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.product.manufacturer"), (String)"getSystemProperty(IDevic\u2026PROP_DEVICE_MANUFACTURER)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.build.version.release"), (String)"getSystemProperty(IDevice.PROP_BUILD_VERSION)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.build.version.sdk"), (String)"getSystemProperty(IDevice.PROP_BUILD_API_LEVEL)");
        List futures = CollectionsKt.listOf((Object[])objectArray);
        ListenableFuture listenableFuture = FutureUtils.whenAllComplete((List)FutureUtils.listenInPoolThread((List)futures, (Executor)this.taskExecutor)).call(new Callable(futures){
            final /* synthetic */ List<Future<String>> $futures;
            {
                this.$futures = $futures;
            }

            public final DeviceNameProperties call() {
                return new DeviceNameProperties(this.$futures.get(0).get(), this.$futures.get(1).get(), this.$futures.get(2).get(), this.$futures.get(3).get());
            }
        }, MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"futures = listOf<Future<\u2026ecutors.directExecutor())");
        return listenableFuture;
    }

    private final boolean isRetrieving(IDevice device2) {
        this.assertThreadMatch(ThreadType.TASK);
        ListenableFuture<DeviceNameProperties> task2 = this.tasksMap.get(device2);
        return task2 != null && !task2.isDone();
    }

    private final void startRetriever(IDevice device2) {
        this.assertThreadMatch(ThreadType.TASK);
        ListenableFuture<DeviceNameProperties> task2 = this.getDeviceSystemProperties(device2);
        FutureUtils.addCallback(task2, (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<DeviceNameProperties, Unit>(this, device2){
            final /* synthetic */ DeviceNamePropertiesFetcher this$0;
            final /* synthetic */ IDevice $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
                super(1);
            }

            public final void invoke(@Nullable DeviceNameProperties deviceNameProperties) {
                if (!Intrinsics.areEqual(DeviceNamePropertiesFetcher.access$getDeviceNamePropertiesMap$p(this.this$0).get(this.$device), (Object)deviceNameProperties)) {
                    ((Map)DeviceNamePropertiesFetcher.access$getDeviceNamePropertiesMap$p(this.this$0)).put(this.$device, deviceNameProperties);
                    if (!((Boolean)DeviceNamePropertiesFetcher.access$isDisposed$p(this.this$0).invoke((Object)this.this$0)).booleanValue()) {
                        DeviceNamePropertiesFetcher.access$getUiCallback$p(this.this$0).onSuccess((Object)deviceNameProperties);
                    }
                }
            }
        }), (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ DeviceNamePropertiesFetcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable t) {
                if (!((Boolean)DeviceNamePropertiesFetcher.access$isDisposed$p(this.this$0).invoke((Object)this.this$0)).booleanValue()) {
                    FutureCallback futureCallback = DeviceNamePropertiesFetcher.access$getUiCallback$p(this.this$0);
                    Throwable throwable = t;
                    Intrinsics.checkNotNull((Object)throwable);
                    futureCallback.onFailure(throwable);
                }
            }
        }));
        ((Map)this.tasksMap).put(device2, task2);
    }

    private final void assertThreadMatch(ThreadType callBy) {
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isUnitTestMode()) {
            switch (WhenMappings.$EnumSwitchMapping$0[callBy.ordinal()]) {
                case 1: {
                    application.assertIsDispatchThread();
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl2 = bl = !application.isDispatchThread();
                    if (!_Assertions.ENABLED || bl) break;
                    boolean bl3 = false;
                    String string = "This operation is time consuming and must not be called on EDT";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }

    @Override
    @NotNull
    public DeviceNameProperties get(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.assertThreadMatch(ThreadType.EDT);
        if (((Boolean)this.isDisposed.invoke((Object)this)).booleanValue()) {
            Logger.getInstance(DeviceNamePropertiesFetcher.class).warn("DeviceNamePropertiesFetcher has been disposed");
            return this.defaultValue;
        }
        DeviceNameProperties value2 = this.deviceNamePropertiesMap.get(device2);
        this.taskExecutor.execute(new Runnable(this, device2){
            final /* synthetic */ DeviceNamePropertiesFetcher this$0;
            final /* synthetic */ IDevice $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
            }

            public final void run() {
                if (!DeviceNamePropertiesFetcher.access$isRetrieving(this.this$0, this.$device)) {
                    DeviceNamePropertiesFetcher.access$startRetriever(this.this$0, this.$device);
                }
            }
        });
        DeviceNameProperties deviceNameProperties = value2;
        if (deviceNameProperties == null) {
            deviceNameProperties = this.defaultValue;
        }
        return deviceNameProperties;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
    }

    public static final /* synthetic */ HashMap access$getDeviceNamePropertiesMap$p(DeviceNamePropertiesFetcher $this) {
        return $this.deviceNamePropertiesMap;
    }

    public static final /* synthetic */ Function1 access$isDisposed$p(DeviceNamePropertiesFetcher $this) {
        return $this.isDisposed;
    }

    public static final /* synthetic */ FutureCallback access$getUiCallback$p(DeviceNamePropertiesFetcher $this) {
        return $this.uiCallback;
    }

    public static final /* synthetic */ boolean access$isRetrieving(DeviceNamePropertiesFetcher $this, IDevice device2) {
        return $this.isRetrieving(device2);
    }

    public static final /* synthetic */ void access$startRetriever(DeviceNamePropertiesFetcher $this, IDevice device2) {
        $this.startRetriever(device2);
    }

    public static final /* synthetic */ void access$assertThreadMatch(DeviceNamePropertiesFetcher $this, ThreadType callBy) {
        $this.assertThreadMatch(callBy);
    }

    public static final /* synthetic */ HashMap access$getTasksMap$p(DeviceNamePropertiesFetcher $this) {
        return $this.tasksMap;
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DefaultCallback;", "Lcom/google/common/util/concurrent/FutureCallback;", "Lcom/android/tools/idea/ddms/DeviceNameProperties;", "()V", "onFailure", "", "throwable", "", "onSuccess", "properties", "intellij.android.adb"})
    public static final class DefaultCallback
    implements FutureCallback<DeviceNameProperties> {
        public void onSuccess(@Nullable DeviceNameProperties properties2) {
        }

        public void onFailure(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Logger.getInstance(DeviceNamePropertiesFetcher.class).warn(throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DeviceChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "(Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher;)V", "deviceChanged", "", "device", "Lcom/android/ddmlib/IDevice;", "changeMask", "", "deviceConnected", "deviceDisconnected", "intellij.android.adb"})
    public final class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceNamePropertiesFetcher.this.edtExecutor.execute(new Runnable(DeviceNamePropertiesFetcher.this, device2){
                final /* synthetic */ DeviceNamePropertiesFetcher this$0;
                final /* synthetic */ IDevice $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                }

                public final void run() {
                    DeviceNamePropertiesFetcher.access$assertThreadMatch(this.this$0, ThreadType.EDT);
                    DeviceNamePropertiesFetcher.access$getDeviceNamePropertiesMap$p(this.this$0).remove(this.$device);
                    DeviceNamePropertiesFetcher.access$getTasksMap$p(this.this$0).remove(this.$device);
                }
            });
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$ThreadType;", "", "(Ljava/lang/String;I)V", "EDT", "TASK", "intellij.android.adb"})
    public static final class ThreadType
    extends Enum<ThreadType> {
        public static final /* enum */ ThreadType EDT = new ThreadType();
        public static final /* enum */ ThreadType TASK = new ThreadType();
        private static final /* synthetic */ ThreadType[] $VALUES;

        public static ThreadType[] values() {
            return (ThreadType[])$VALUES.clone();
        }

        public static ThreadType valueOf(String value2) {
            return Enum.valueOf(ThreadType.class, value2);
        }

        static {
            $VALUES = threadTypeArray = new ThreadType[]{ThreadType.EDT, ThreadType.TASK};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreadType.values().length];
            try {
                nArray[ThreadType.EDT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreadType.TASK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

