/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0011\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/databinding/util/LayoutBindingTypeUtil;", "", "()V", "VIEW_PACKAGE_ELEMENTS", "", "", "getFqcn", "className", "getViewClassName", "xmlData", "Lcom/android/tools/idea/databinding/index/BindingXmlData;", "viewIdData", "Lcom/android/tools/idea/databinding/index/ViewIdData;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "viewName", "layoutName", "getViewClassNameFromIncludeTag", "getViewClassNameFromLayoutAttribute", "getViewClassNameFromMergeTag", "parsePsiType", "Lcom/intellij/psi/PsiType;", "typeStr", "context", "Lcom/intellij/psi/PsiElement;", "resolveViewPsiType", "viewTag", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLayoutBindingTypeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutBindingTypeUtil.kt\ncom/android/tools/idea/databinding/util/LayoutBindingTypeUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class LayoutBindingTypeUtil {
    @NotNull
    public static final LayoutBindingTypeUtil INSTANCE = new LayoutBindingTypeUtil();
    @NotNull
    private static final List<String> VIEW_PACKAGE_ELEMENTS;

    private LayoutBindingTypeUtil() {
    }

    @JvmStatic
    @Nullable
    public static final PsiType parsePsiType(@NotNull String typeStr, @NotNull PsiElement context2) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)typeStr, (String)"typeStr");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            psiType = PsiElementFactory.getInstance((Project)context2.getProject()).createTypeFromText(typeStr, context2);
        }
        catch (IncorrectOperationException e) {
            psiType = null;
        }
        return psiType;
    }

    @JvmStatic
    @Nullable
    public static final PsiType resolveViewPsiType(@NotNull BindingXmlData xmlData, @NotNull ViewIdData viewIdData, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)xmlData, (String)"xmlData");
        Intrinsics.checkNotNullParameter((Object)viewIdData, (String)"viewIdData");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)context2);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet androidFacet2 = androidFacet;
        String string = INSTANCE.getViewClassName(xmlData, viewIdData, androidFacet2);
        if (string == null) {
            return null;
        }
        String viewClassName = string;
        return ((CharSequence)viewClassName).length() > 0 ? (PsiType)PsiType.getTypeByName((String)viewClassName, (Project)context2.getProject(), (GlobalSearchScope)context2.getResolveScope()) : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiType resolveViewPsiType(@NotNull BindingXmlData xmlData, @NotNull String viewTag, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)xmlData, (String)"xmlData");
        Intrinsics.checkNotNullParameter((Object)viewTag, (String)"viewTag");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)context2);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet androidFacet2 = androidFacet;
        String string = INSTANCE.getViewClassName(xmlData, viewTag, null, androidFacet2);
        if (string == null) {
            return null;
        }
        String viewClassName = string;
        return ((CharSequence)viewClassName).length() > 0 ? (PsiType)PsiType.getTypeByName((String)viewClassName, (Project)context2.getProject(), (GlobalSearchScope)context2.getResolveScope()) : null;
    }

    private final String getViewClassName(BindingXmlData xmlData, ViewIdData viewIdData, AndroidFacet facet2) {
        return this.getViewClassName(xmlData, viewIdData.getViewName(), viewIdData.getLayoutName(), facet2);
    }

    private final String getViewClassName(BindingXmlData xmlData, String viewName, String layoutName, AndroidFacet facet2) {
        String string;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!Intrinsics.areEqual((Object)"merge", (Object)viewName)) break block5;
                        string = this.getViewClassNameFromMergeTag(layoutName, facet2);
                        break block6;
                    }
                    if (!Intrinsics.areEqual((Object)"include", (Object)viewName)) break block7;
                    string = this.getViewClassNameFromIncludeTag(layoutName, facet2);
                    break block6;
                }
                if (!Intrinsics.areEqual((Object)"ViewStub", (Object)viewName)) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[xmlData.getLayoutType().ordinal()]) {
                    case 1: {
                        string = "android.view.ViewStub";
                        break block6;
                    }
                    case 2: {
                        String string2;
                        String it = string2 = DataBindingUtil.getDataBindingMode((AndroidFacet)facet2).viewStubProxy;
                        boolean bl = false;
                        string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                        if (string == null) {
                            string = "android.view.ViewStub";
                        }
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            string = Intrinsics.areEqual((Object)"fragment", (Object)viewName) ? null : LayoutBindingTypeUtil.getFqcn(viewName);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getFqcn(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) >= 0 ? className : (VIEW_PACKAGE_ELEMENTS.contains(className) ? "android.view." + className : (Intrinsics.areEqual((Object)"WebView", (Object)className) ? "android.webkit." + className : "android.widget." + className));
    }

    private final String getViewClassNameFromIncludeTag(String layoutName, AndroidFacet facet2) {
        String reference = this.getViewClassNameFromLayoutAttribute(layoutName, facet2);
        String string = reference;
        if (string == null) {
            string = "android.view.View";
        }
        return string;
    }

    private final String getViewClassNameFromMergeTag(String layoutName, AndroidFacet facet2) {
        return this.getViewClassNameFromLayoutAttribute(layoutName, facet2);
    }

    private final String getViewClassNameFromLayoutAttribute(String layoutName, AndroidFacet facet2) {
        Module module2;
        BindingXmlIndex.Entry indexEntry;
        block8: {
            block7: {
                if (layoutName == null) {
                    return null;
                }
                ResourceUrl resourceUrl = ResourceUrl.parse((String)layoutName);
                if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
                    return null;
                }
                Project project = facet2.getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
                String string = resourceUrl.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceUrl.name");
                BindingXmlIndex.Entry entry = (BindingXmlIndex.Entry)CollectionsKt.firstOrNull((Iterable)BindingXmlIndex.Companion.getEntriesForLayout(project, string));
                if (entry == null) {
                    return null;
                }
                indexEntry = entry;
                VirtualFile virtualFile = indexEntry.getFile();
                Project project2 = facet2.getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"facet.module.project");
                module2 = ProjectStructureUtilKt.getModule((VirtualFile)virtualFile, (Project)project2);
                if (module2 == null) break block7;
                Module it = module2;
                boolean bl = false;
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)it);
                module2 = androidFacet;
                if (androidFacet != null) break block8;
            }
            return null;
        }
        Module resourceFacet = module2;
        if (indexEntry.getData().getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && !ViewBindingUtil.isViewBindingEnabled((AndroidFacet)resourceFacet)) {
            return this.getViewClassName(indexEntry.getData(), indexEntry.getData().getRootTag(), null, (AndroidFacet)resourceFacet);
        }
        return DataBindingUtil.getQualifiedBindingName((AndroidFacet)resourceFacet, indexEntry);
    }

    static {
        Object[] objectArray = new String[]{"View", "ViewGroup", "TextureView", "SurfaceView"};
        VIEW_PACKAGE_ELEMENTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BindingLayoutType.values().length];
            try {
                nArray[BindingLayoutType.PLAIN_LAYOUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindingLayoutType.DATA_BINDING_LAYOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

