/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesActionStateManagerKt;
import com.android.tools.idea.connection.assistant.actions.RestartAdbAction;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "()V", "projectStates", "", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager$State;", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "devices", "", "Lcom/android/ddmlib/IDevice;", "([Lcom/android/ddmlib/IDevice;)Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "", "State", "connection-assistant"})
@SourceDebugExtension(value={"SMAP\nRestartAdbActionStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestartAdbActionStateManager.kt\ncom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n13543#2,2:202\n*S KotlinDebug\n*F\n+ 1 RestartAdbActionStateManager.kt\ncom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager\n*L\n190#1:202,2\n*E\n"})
public final class RestartAdbActionStateManager
extends AssistActionStateManager {
    @NotNull
    private final Map<Project, State> projectStates = new LinkedHashMap();

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        this.projectStates.computeIfAbsent(project, new Function(this){
            final /* synthetic */ RestartAdbActionStateManager $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final State apply(@NotNull Project p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.new State(p0);
            }
        });
        this.refreshDependencyState(project);
    }

    @Override
    @NotNull
    public String getId() {
        return RestartAdbAction.Companion.getACTION_ID();
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        State state2 = this.projectStates.get(project);
        if ((state2 != null ? state2.getAssistActionState() : null) == null) {
            ListUsbDevicesActionStateManagerKt.getLogger().warn("getState called before init for this project");
            return DefaultActionState.IN_PROGRESS;
        }
        State state3 = this.projectStates.get(project);
        Intrinsics.checkNotNull((Object)state3);
        return state3.getAssistActionState();
    }

    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        State state2 = this.projectStates.get(project);
        if ((state2 != null ? state2.getStateDisplay() : null) == null) {
            ListUsbDevicesActionStateManagerKt.getLogger().warn("getStateDisplay called before init for this project");
            return null;
        }
        State state3 = this.projectStates.get(project);
        Intrinsics.checkNotNull((Object)state3);
        return state3.getStateDisplay();
    }

    private final ButtonMessage generateMessage(IDevice[] devices2) {
        ButtonMessage buttonMessage;
        if (devices2.length == 0) {
            String string = new HtmlBuilder().addHtml(AndroidBundle.message("connection.assistant.adb.no_devices.title", new Object[0])).newlineIfNecessary().getHtml();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder().addHtml(An\u2026newlineIfNecessary().html");
            buttonMessage = new ButtonMessage(string, new HtmlBuilder().addHtml("<p>" + AndroidBundle.message("connection.assistant.adb.no_devices.body", new Object[0]) + "</p>").getHtml());
        } else {
            String title = new HtmlBuilder().addHtml("<span style=\"color: " + UIUtils.getCssColor(UIUtils.getSuccessColor()) + ";\">" + AndroidBundle.message("connection.assistant.adb.devices", new Object[0]) + "</span>").getHtml();
            HtmlBuilder htmlBodyBuilder = new HtmlBuilder();
            IDevice[] $this$forEach$iv = devices2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                IDevice element$iv;
                IDevice device2 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                htmlBodyBuilder.addHtml("<p><span>" + device2.getName() + "</span>").newline().addHtml("<span style=\"font-size: 80%; font-weight: lighter;\">" + device2.getVersion() + "</span></p>").newline();
            }
            Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
            buttonMessage = new ButtonMessage(title, htmlBodyBuilder.getHtml());
        }
        return buttonMessage;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u000fJ\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager$State;", "Lcom/android/ddmlib/AndroidDebugBridge$IDebugBridgeChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager;Lcom/intellij/openapi/project/Project;)V", "adbFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/AndroidDebugBridge;", "loading", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "bridgeChanged", "", "bridge", "deviceChanged", "device", "Lcom/android/ddmlib/IDevice;", "changeMask", "", "deviceConnected", "deviceDisconnected", "dispose", "getAssistActionState", "Lcom/android/tools/idea/assistant/AssistActionState;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "initDebugBridge", "restartCompleted", "isSuccessful", "restartInitiated", "setLoading", "connection-assistant"})
    private final class State
    implements AndroidDebugBridge.IDebugBridgeChangeListener,
    AndroidDebugBridge.IDeviceChangeListener,
    Disposable {
        @NotNull
        private final Project project;
        @Nullable
        private ListenableFuture<AndroidDebugBridge> adbFuture;
        private boolean loading;

        public State(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
            this.initDebugBridge();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void initDebugBridge() {
            File file2 = AndroidSdkUtils.getAdb(this.project);
            if (file2 == null) {
                return;
            }
            File adb = file2;
            ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(adb);
            if (listenableFuture == null) {
                return;
            }
            this.adbFuture = listenableFuture;
            Futures.addCallback(this.adbFuture, (FutureCallback)((FutureCallback)new FutureCallback<AndroidDebugBridge>(RestartAdbActionStateManager.this, this){
                final /* synthetic */ RestartAdbActionStateManager this$0;
                final /* synthetic */ State this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                    this.this$0.refreshDependencyState(this.this$1.getProject());
                }

                public void onFailure(@Nullable Throwable t) {
                    this.this$0.refreshDependencyState(this.this$1.getProject());
                }
            }), (Executor)((Executor)EdtExecutorService.getInstance()));
        }

        private final void setLoading(boolean loading) {
            this.loading = loading;
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        }

        public void restartInitiated() {
            this.setLoading(true);
        }

        public void restartCompleted(boolean isSuccessful) {
            this.setLoading(false);
        }

        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            RestartAdbActionStateManager.this.refreshDependencyState(this.project);
        }

        public void dispose() {
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            RestartAdbActionStateManager.this.projectStates.remove(this.project);
        }

        @NotNull
        public final AssistActionState getAssistActionState() {
            block7: {
                block6: {
                    if (this.loading) {
                        return DefaultActionState.IN_PROGRESS;
                    }
                    if (this.adbFuture == null) {
                        return DefaultActionState.INCOMPLETE;
                    }
                    ListenableFuture<AndroidDebugBridge> listenableFuture = this.adbFuture;
                    Intrinsics.checkNotNull(listenableFuture);
                    if (!listenableFuture.isDone()) {
                        return DefaultActionState.IN_PROGRESS;
                    }
                    AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
                    if (adb == null) break block6;
                    IDevice[] iDeviceArray = adb.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"adb.devices");
                    if (!(((Object[])iDeviceArray).length == 0)) break block7;
                }
                return DefaultActionState.ERROR_RETRY;
            }
            return CustomSuccessState.INSTANCE;
        }

        @NotNull
        public final StatefulButtonMessage getStateDisplay() {
            ButtonMessage buttonMessage;
            AssistActionState state2 = this.getAssistActionState();
            AssistActionState assistActionState = state2;
            if (assistActionState == DefaultActionState.IN_PROGRESS) {
                String string = AndroidBundle.message("connection.assistant.loading", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.assistant.loading\")");
                buttonMessage = new ButtonMessage(string, null, 2, null);
            } else if (Intrinsics.areEqual((Object)assistActionState, (Object)CustomSuccessState.INSTANCE) ? true : assistActionState == DefaultActionState.ERROR_RETRY) {
                IDevice[] adb;
                IDevice[] iDeviceArray = adb = AndroidDebugBridge.getBridge();
                int deviceCount = adb != null && (iDeviceArray = iDeviceArray.getDevices()) != null ? iDeviceArray.length : -1;
                AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.ADB_DEVICES_DETECTED).setAdbDevicesDetected(deviceCount));
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026cesDetected(deviceCount))");
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder2, this.project));
                if (adb != null) {
                    IDevice[] iDeviceArray2 = adb.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray2, (String)"adb.devices");
                    buttonMessage = RestartAdbActionStateManager.this.generateMessage(iDeviceArray2);
                } else {
                    String string = AndroidBundle.message("connection.assistant.adb.failure", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.assistant.adb.failure\")");
                    buttonMessage = new ButtonMessage(string, null, 2, null);
                }
            } else {
                String string = AndroidBundle.message("connection.assistant.adb.unexpected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"connection.assistant.adb.unexpected\")");
                buttonMessage = new ButtonMessage(string, null, 2, null);
            }
            ButtonMessage buttonMessage2 = buttonMessage;
            String title = buttonMessage2.component1();
            String body = buttonMessage2.component2();
            return new StatefulButtonMessage(title, state2, body);
        }
    }
}

