/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.connection.assistant.actions.ConnectionAssistantSection;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReference;
import com.android.tools.idea.connection.assistant.actions.DeviceSummary;
import com.android.tools.usb.UsbDevice;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"summarize", "Lcom/android/tools/idea/connection/assistant/actions/DeviceSummary;", "crossReference", "Lcom/android/tools/idea/connection/assistant/actions/DeviceCrossReference;", "connection-assistant"})
public final class DeviceSummaryKt {
    @NotNull
    public static final DeviceSummary summarize(@NotNull DeviceCrossReference crossReference) {
        Intrinsics.checkNotNullParameter((Object)crossReference, (String)"crossReference");
        IDevice device2 = (IDevice)CollectionsKt.firstOrNull(crossReference.getDdmsDevices());
        String label = null;
        if (device2 != null) {
            String string = device2.getName();
            if (string == null) {
                string = "";
            }
            label = string;
        } else if (!crossReference.getAdbDevice().isEmpty()) {
            String string = ((AdbDevice)CollectionsKt.first(crossReference.getAdbDevice())).getSerial();
            if (string == null) {
                string = "";
            }
            label = string;
        } else {
            label = !crossReference.getUsbDevice().isEmpty() ? ((UsbDevice)CollectionsKt.first(crossReference.getUsbDevice())).getName() : "Unknown device";
        }
        ConnectionAssistantSection section = null;
        Object errorMessage = null;
        if (device2 != null) {
            IDevice.DeviceState devState = device2.getState();
            AdbDevice adbDevice = (AdbDevice)CollectionsKt.firstOrNull(crossReference.getAdbDevice());
            if (adbDevice != null && adbDevice.getState() != devState) {
                section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
                IDevice.DeviceState deviceState = adbDevice.getState();
                String string = deviceState != null ? deviceState.getState() : null;
                if (string == null) {
                    string = "unknown";
                }
                IDevice.DeviceState deviceState2 = devState;
                String string2 = deviceState2 != null ? deviceState2.getState() : null;
                if (string2 == null) {
                    string2 = "unknown";
                }
                errorMessage = "ADB reports that the device is in the '" + string + "' state but Android Studio reports that it is in the '" + string2 + "' state";
            } else {
                IDevice.DeviceState deviceState = devState;
                switch (deviceState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deviceState.ordinal()]) {
                    case 1: {
                        section = ConnectionAssistantSection.WORKING;
                        break;
                    }
                    case 2: {
                        section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
                        errorMessage = "Device is waiting for you to grant permission for USB debugging";
                        break;
                    }
                    default: {
                        section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
                        IDevice.DeviceState deviceState3 = device2.getState();
                        String string = deviceState3 != null ? deviceState3.getState() : null;
                        if (string == null) {
                            string = "unknown";
                        }
                        errorMessage = "Device is currently in the " + string + " state";
                        break;
                    }
                }
            }
        } else if (!crossReference.getAdbDevice().isEmpty()) {
            section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
            errorMessage = "Device was detected by ADB but not Android Studio.";
        } else {
            section = ConnectionAssistantSection.OTHER_USB;
        }
        return new DeviceSummary(label, device2, section, (String)errorMessage);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IDevice.DeviceState.values().length];
            try {
                nArray[IDevice.DeviceState.ONLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IDevice.DeviceState.UNAUTHORIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

