/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.resources.Locale;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaryingConfiguration
extends NestedConfiguration {
    private int myVariation;
    private int myVariationCount;
    private int myAlternate;
    private Device myPrevParentDevice;
    private Device myPrevDevice;

    private VaryingConfiguration(@NotNull Configuration configuration) {
        super(configuration);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull Configuration parent2) {
        return new VaryingConfiguration(parent2);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull VaryingConfiguration other, @NotNull Configuration parent2) {
        VaryingConfiguration configuration = new VaryingConfiguration(parent2);
        configuration.startBulkEditing();
        VaryingConfiguration.initFrom(configuration, other, other);
        configuration.myAlternate = other.myAlternate;
        configuration.myVariation = other.myVariation;
        configuration.myVariationCount = other.myVariationCount;
        configuration.finishBulkEditing();
        return configuration;
    }

    public int getAlternateFlags() {
        return this.myAlternate;
    }

    @Override
    protected void syncFolderConfig() {
        super.syncFolderConfig();
        this.updateDisplayName();
    }

    public void setVariation(int variation) {
        this.myVariation = variation;
        this.myVariationCount = Math.max(this.myVariationCount, variation + 1);
    }

    public void setVariationCount(int count2) {
        this.myVariationCount = count2;
    }

    public void updateDisplayName() {
        this.setDisplayName(this.computeDisplayName());
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            return super.getLocale();
        }
        Locale locale = this.myParent.getLocale();
        if (this.isAlternatingLocale()) {
            ImmutableList<Locale> locales = this.getConfigurationManager().getLocalesInProject();
            for (Locale l : locales) {
                if (l.equals((Object)locale)) continue;
                locale = l;
                break;
            }
        }
        return locale;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        ConfigurationManager manager;
        IAndroidTarget[] targets;
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        IAndroidTarget target2 = this.myParent.getTarget();
        if (this.isAlternatingTarget() && target2 != null && (targets = (manager = this.getConfigurationManager()).getTargets()).length > 0) {
            IAndroidTarget mostRecent = manager.getHighestApiTarget();
            if (target2.equals(mostRecent)) {
                AndroidModuleInfo info2 = manager.getConfigModule().getAndroidModuleInfo();
                if (info2 != null) {
                    int minSdkVersion2 = info2.getMinSdkVersion().getFeatureLevel();
                    for (IAndroidTarget t : targets) {
                        if (t.getVersion().getFeatureLevel() < minSdkVersion2 || !ConfigurationManager.isLayoutLibTarget(t)) continue;
                        target2 = t;
                        break;
                    }
                }
            } else {
                target2 = mostRecent;
            }
        }
        return target2;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        Device device2 = this.myParent.getDevice();
        if (this.isAlternatingDevice() && device2 != null) {
            if (device2 == this.myPrevParentDevice) {
                return this.myPrevDevice;
            }
            this.myPrevParentDevice = device2;
            ImmutableList<Device> devices2 = this.getConfigurationManager().getDevices();
            boolean isTv = HardwareConfigHelper.isTv((Device)device2);
            boolean isWear = HardwareConfigHelper.isWear((Device)device2);
            double smallest = 100.0;
            double biggest = 1.0;
            for (Device d : devices2) {
                double size = VaryingConfiguration.getScreenSize(d);
                if (size < 0.0 || isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d)) continue;
                if (size >= biggest) {
                    biggest = size;
                }
                if (!(size <= smallest)) continue;
                smallest = size;
            }
            int bucketCount = this.myVariationCount + 1;
            double inchesPerBucket = (biggest - smallest) / (double)bucketCount;
            double overriddenSize = VaryingConfiguration.getScreenSize(device2);
            int overriddenBucket = (int)((overriddenSize - smallest) / inchesPerBucket);
            int bucket = this.myVariation < overriddenBucket ? this.myVariation : this.myVariation + 1;
            double from = inchesPerBucket * (double)bucket + smallest;
            double to = from + inchesPerBucket;
            if (biggest - to < 0.1) {
                to = biggest + 0.1;
            }
            for (Device d : devices2) {
                double size;
                if (isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d) || !((size = VaryingConfiguration.getScreenSize(d)) >= from) || !(size < to)) continue;
                device2 = d;
                break;
            }
            this.myPrevDevice = device2;
        }
        return device2;
    }

    @Nullable
    private static Density getDensity(@NotNull Device device2) {
        Hardware hardware = device2.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getPixelDensity();
        }
        return null;
    }

    private static double getScreenSize(@NotNull Device device2) {
        Hardware hardware = device2.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getDiagonalLength();
        }
        return -1.0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device2;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state2 = this.myParent.getDeviceState();
        if (this.isAlternatingDeviceState() && state2 != null) {
            State next = this.getNextDeviceState(state2);
            if (next != null) {
                return next;
            }
            return state2;
        }
        if ((this.isAlternatingDevice() || this.isOverridingDevice()) && state2 != null && (device2 = this.getDevice()) != null) {
            return device2.getState(state2.getName());
        }
        return state2;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            return super.getNightMode();
        }
        NightMode nightMode = this.myParent.getNightMode();
        if (this.isAlternatingNightMode()) {
            nightMode = nightMode == NightMode.NIGHT ? NightMode.NOTNIGHT : NightMode.NIGHT;
        }
        return nightMode;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            return super.getUiMode();
        }
        UiMode uiMode = this.myParent.getUiMode();
        if (this.isAlternatingUiMode()) {
            UiMode[] values = UiMode.values();
            uiMode = values[(uiMode.ordinal() + 1) % values.length];
        }
        return uiMode;
    }

    @Override
    @Nullable
    public String computeDisplayName() {
        return VaryingConfiguration.computeDisplayName(this.getOverrideFlags() | this.myAlternate, this);
    }

    public void setAlternateLocale(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x10) : (this.myAlternate &= 0xFFFFFFEF);
    }

    public final boolean isAlternatingLocale() {
        return (this.myAlternate & 0x10) != 0;
    }

    public void setAlternateTarget(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x20) : (this.myAlternate &= 0xFFFFFFDF);
    }

    public final boolean isAlternatingTarget() {
        return (this.myAlternate & 0x20) != 0;
    }

    public void setAlternateDevice(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 2) : (this.myAlternate &= 0xFFFFFFFD);
    }

    public final boolean isAlternatingDevice() {
        return (this.myAlternate & 2) != 0;
    }

    public void setAlternateDeviceState(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 4) : (this.myAlternate &= 0xFFFFFFFB);
    }

    public final boolean isAlternatingDeviceState() {
        return (this.myAlternate & 4) != 0;
    }

    public void setAlternateNightMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x40) : (this.myAlternate &= 0xFFFFFFBF);
    }

    public final boolean isAlternatingNightMode() {
        return (this.myAlternate & 0x40) != 0;
    }

    public void setAlternateUiMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x80) : (this.myAlternate &= 0xFFFFFF7F);
    }

    public final boolean isAlternatingUiMode() {
        return (this.myAlternate & 0x80) != 0;
    }

    @Override
    public boolean changed(int flags) {
        this.updated(flags);
        return true;
    }
}

