/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TargetMenuAction
extends DropDownAction {
    private static final int SHOW_FROM_API_LEVEL = 7;
    private final ConfigurationHolder myRenderContext;
    private final boolean myUseCompatibilityTarget;

    public TargetMenuAction(ConfigurationHolder renderContext, boolean useCompatibilityTarget) {
        super("API Version for Preview", "API Version for Preview", StudioIcons.LayoutEditor.Toolbar.ANDROID_API);
        boolean visible;
        this.myRenderContext = renderContext;
        this.myUseCompatibilityTarget = useCompatibilityTarget;
        Presentation presentation = this.getTemplatePresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            IAndroidTarget target2 = configuration.getTarget();
            String brief = TargetMenuAction.getRenderingTargetLabel(target2, true);
            presentation.setText(brief);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public TargetMenuAction(ConfigurationHolder renderContext) {
        this(renderContext, false);
    }

    public void update(@NotNull AnActionEvent e) {
        IAndroidTarget target2;
        String brief;
        boolean visible;
        Presentation presentation = e.getPresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible && !(brief = TargetMenuAction.getRenderingTargetLabel(target2 = configuration.getTarget(), true)).equals(presentation.getText())) {
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private int getMinSdkVersion() {
        AndroidModuleInfo moduleInfo;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (moduleInfo = configuration.getConfigModule().getAndroidModuleInfo()) != null) {
            return moduleInfo.getMinSdkVersion().getFeatureLevel();
        }
        return -1;
    }

    @NotNull
    private List<SetTargetAction> getCompatibilitySetTargetActions(boolean defaultSelectable) {
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget currentTarget = configuration.getTarget();
        IAndroidTarget highestTarget = configuration.getConfigurationManager().getHighestApiTarget();
        assert (highestTarget != null);
        ArrayList<SetTargetAction> actions2 = new ArrayList<SetTargetAction>();
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minApi = Math.max(this.getMinSdkVersion(), 7);
        for (int apiLevel = highestApiLevel; apiLevel >= minApi; --apiLevel) {
            CompatibilityRenderTarget target2 = new CompatibilityRenderTarget(highestTarget, apiLevel, null);
            boolean isSelected = !defaultSelectable && currentTarget != null && target2.getVersion().equals((Object)currentTarget.getVersion());
            actions2.add(new SetTargetAction(this.myRenderContext, target2.getVersionName(), target2, isSelected));
        }
        return this.deduplicateSetTargetAction(actions2);
    }

    @NotNull
    private List<SetTargetAction> getRealSetTargetActions(boolean defaultSelectable) {
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget current = configuration.getTarget();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        ArrayList<SetTargetAction> actions2 = new ArrayList<SetTargetAction>();
        boolean haveRecent = false;
        int minSdk = this.getMinSdkVersion();
        for (int i = targets.length - 1; i >= 0; --i) {
            AndroidVersion version2;
            IAndroidTarget target2 = targets[i];
            if (!ConfigurationManager.isLayoutLibTarget(target2) || (version2 = target2.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version2.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target2, true);
            boolean select2 = !defaultSelectable && current != null && target2.getVersion().equals((Object)current.getVersion());
            actions2.add(new SetTargetAction(this.myRenderContext, title, target2, select2));
        }
        return this.deduplicateSetTargetAction(actions2);
    }

    @NotNull
    private List<SetTargetAction> deduplicateSetTargetAction(@NotNull List<SetTargetAction> targetActions) {
        LinkedHashMap<String, SetTargetAction> titleToActionMap = new LinkedHashMap<String, SetTargetAction>();
        for (SetTargetAction targetAction : targetActions) {
            String title = targetAction.myTitle;
            if (titleToActionMap.containsKey(title)) {
                SetTargetAction oldAction = (SetTargetAction)titleToActionMap.get(title);
                int oldRevision = oldAction.myTarget.getRevision();
                int newRevision = targetAction.myTarget.getRevision();
                if (newRevision <= oldRevision) continue;
                titleToActionMap.replace(title, targetAction);
                continue;
            }
            titleToActionMap.put(title, targetAction);
        }
        return titleToActionMap.values().stream().toList();
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        this.add(new TogglePickBestAction(configuration.getConfigurationManager()));
        this.addSeparator();
        ConfigurationManager manager = configuration.getConfigurationManager();
        boolean isPickBest = manager.getStateManager().getProjectState().isPickTarget();
        List<SetTargetAction> actions2 = this.myUseCompatibilityTarget && manager.getHighestApiTarget() != null ? this.getCompatibilitySetTargetActions(isPickBest) : this.getRealSetTargetActions(isPickBest);
        this.addAll(actions2);
        return true;
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target2, boolean brief) {
        if (target2 == null) {
            return "<null>";
        }
        AndroidVersion version2 = target2.getVersion();
        if (brief) {
            if (target2.isPlatform()) {
                String codename = version2.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(version2.getApiLevel());
            }
            return target2.getName() + ":" + Integer.toString(version2.getApiLevel());
        }
        return String.format(Locale.US, "API %1$d: %2$s", version2.getApiLevel(), target2.getShortClasspathName());
    }

    @VisibleForTesting
    static class SetTargetAction
    extends ConfigurationAction {
        @VisibleForTesting
        final IAndroidTarget myTarget;
        private final String myTitle;

        public SetTargetAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull IAndroidTarget target2, boolean select2) {
            super(renderContext, title);
            this.myTarget = target2;
            this.myTitle = title;
            this.getTemplatePresentation().putClientProperty("selected", (Object)select2);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideTarget();
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Configuration config2 = this.myRenderContext.getConfiguration();
            if (config2 != null) {
                config2.getConfigurationManager().getStateManager().getProjectState().setPickTarget(false);
            }
            super.actionPerformed(e);
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
            super.pickedBetterMatch(file2, old2);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideTarget();
            }
        }

        private void setProjectWideTarget() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setTarget(this.myTarget);
            }
        }
    }

    private static class TogglePickBestAction
    extends AnAction
    implements Toggleable {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (manager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        private boolean isSelected() {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        private void setSelected(boolean state2) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state2);
            if (state2) {
                this.myManager.setTarget(null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent event2) {
            this.setSelected(!this.isSelected());
        }

        public void update(@NotNull AnActionEvent event2) {
            Presentation presentation = event2.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.isSelected());
        }
    }
}

