/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AndroidLayouts", storages={@Storage(value="$WORKSPACE_FILE$")})
public class StudioConfigurationStateManager
implements ConfigurationStateManager {
    private final Map<VirtualFile, ConfigurationFileState> myFileToState = new HashMap<VirtualFile, ConfigurationFileState>();
    private ConfigurationProjectState myProjectState = new ConfigurationProjectState();

    @NotNull
    public static ConfigurationStateManager get(@NotNull Project project) {
        return (ConfigurationStateManager)project.getService(ConfigurationStateManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConfigurationFileState getConfigurationState(@NotNull VirtualFile file2) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            return this.myFileToState.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigurationState(@NotNull VirtualFile file2, @NotNull ConfigurationFileState state2) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.put(file2, state2);
        }
    }

    @Override
    @NotNull
    public ConfigurationProjectState getProjectState() {
        return this.myProjectState;
    }

    @VisibleForTesting
    void setProjectState(@NotNull ConfigurationProjectState projectState) {
        this.myProjectState = projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStateManager.State getState() {
        HashMap<String, ConfigurationFileState> urlToState = new HashMap<String, ConfigurationFileState>();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            for (Map.Entry<VirtualFile, ConfigurationFileState> entry : this.myFileToState.entrySet()) {
                urlToState.put(entry.getKey().getUrl(), entry.getValue());
            }
        }
        ConfigurationStateManager.State state2 = new ConfigurationStateManager.State();
        state2.setUrlToStateMap(urlToState);
        state2.setProjectState(this.myProjectState);
        return state2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull ConfigurationStateManager.State state2) {
        this.myProjectState = state2.getProjectState();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.clear();
            for (Map.Entry<String, ConfigurationFileState> entry : state2.getUrlToStateMap().entrySet()) {
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(entry.getKey());
                if (file2 == null) continue;
                this.myFileToState.put(file2, entry.getValue());
            }
        }
    }
}

