/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ConfigurationModelModule;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.StudioConfigurationStateManager;
import com.android.tools.idea.configurations.StudioThemeInfoProvider;
import com.android.tools.idea.configurations.ThemeInfoProvider;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.rendering.EnvironmentContext;
import com.android.tools.idea.rendering.StudioEnvironmentContext;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/configurations/StudioConfigurationModelModule;", "Lcom/android/tools/idea/configurations/ConfigurationModelModule;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "androidModuleInfo", "Lcom/android/tools/idea/model/AndroidModuleInfo;", "getAndroidModuleInfo", "()Lcom/android/tools/idea/model/AndroidModuleInfo;", "androidPlatform", "Lcom/android/tools/sdk/AndroidPlatform;", "getAndroidPlatform", "()Lcom/android/tools/sdk/AndroidPlatform;", "configurationStateManager", "Lcom/android/tools/idea/configurations/ConfigurationStateManager;", "getConfigurationStateManager", "()Lcom/android/tools/idea/configurations/ConfigurationStateManager;", "environmentContext", "Lcom/android/tools/idea/rendering/EnvironmentContext;", "getEnvironmentContext", "()Lcom/android/tools/idea/rendering/EnvironmentContext;", "getModule", "()Lcom/intellij/openapi/module/Module;", "name", "", "getName", "()Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "resourceRepositoryManager", "Lcom/android/tools/res/ResourceRepositoryManager;", "getResourceRepositoryManager", "()Lcom/android/tools/res/ResourceRepositoryManager;", "themeInfoProvider", "Lcom/android/tools/idea/configurations/ThemeInfoProvider;", "getThemeInfoProvider", "()Lcom/android/tools/idea/configurations/ThemeInfoProvider;", "dispose", "", "intellij.android.core"})
public final class StudioConfigurationModelModule
implements ConfigurationModelModule {
    @NotNull
    private final Module module;
    @NotNull
    private final ThemeInfoProvider themeInfoProvider;
    @Nullable
    private final AndroidModuleInfo androidModuleInfo;
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final EnvironmentContext environmentContext;

    public StudioConfigurationModelModule(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        this.themeInfoProvider = new StudioThemeInfoProvider(this.module);
        this.androidModuleInfo = StudioAndroidModuleInfo.getInstance(this.module);
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        this.project = project;
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        this.name = string;
        Project project2 = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        this.environmentContext = new StudioEnvironmentContext(project2);
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Override
    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        return AndroidPlatforms.getInstance(this.module);
    }

    @Override
    @Nullable
    public ResourceRepositoryManager getResourceRepositoryManager() {
        return StudioResourceRepositoryManager.getInstance(this.module);
    }

    @Override
    @NotNull
    public ConfigurationStateManager getConfigurationStateManager() {
        ConfigurationStateManager configurationStateManager = StudioConfigurationStateManager.get(this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)configurationStateManager, (String)"get(module.project)");
        return configurationStateManager;
    }

    @Override
    @NotNull
    public ThemeInfoProvider getThemeInfoProvider() {
        return this.themeInfoProvider;
    }

    @Override
    @Nullable
    public AndroidModuleInfo getAndroidModuleInfo() {
        return this.androidModuleInfo;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public EnvironmentContext getEnvironmentContext() {
        return this.environmentContext;
    }

    public void dispose() {
    }
}

