/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationModelModule;
import com.android.tools.idea.configurations.RtlAction;
import com.android.tools.idea.configurations.StudioConfigurationModelModule;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.res.ResourceRepositoryManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;

public class LocaleMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;

    public LocaleMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("Locale for Preview", "Locale for Preview", null);
        this.myRenderContext = renderContext;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        Configuration conf = this.myRenderContext.getConfiguration();
        String currentLocalLabel = Locale.getLocaleLabel((Locale)(conf == null ? Locale.ANY : conf.getLocale()), (boolean)false);
        List<Locale> locales = this.getRelevantLocales();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && !locales.isEmpty()) {
            String title = Locale.getLocaleLabel((Locale)Locale.ANY, (boolean)false);
            this.add(new SetLocaleAction(this.myRenderContext, title, Locale.ANY, currentLocalLabel.equals(title)));
            this.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                title = Locale.getLocaleLabel((Locale)locale, (boolean)false);
                VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, null, locale, null);
                if (better != null) {
                    title = ConfigurationAction.getBetterMatchLabel(Locale.getLocaleLabel((Locale)locale, (boolean)true), better, configuration.getFile());
                }
                this.add(new SetLocaleAction(this.myRenderContext, title, locale, currentLocalLabel.equals(title)));
            }
            this.addSeparator();
        }
        this.add(new EditTranslationAction());
        if (configuration != null && !LocaleMenuAction.hasAnyRtlLocales(configuration, locales)) {
            this.add((AnAction)new RtlAction(this.myRenderContext));
        }
        return true;
    }

    private static boolean hasAnyRtlLocales(@NotNull Configuration configuration, @NotNull List<Locale> locales) {
        Module module2 = ((StudioConfigurationModelModule)configuration.getConfigModule()).getModule();
        LayoutLibrary layoutlib = StudioRenderServiceKt.getLayoutLibrary(module2, configuration.getTarget());
        if (layoutlib == null) {
            return false;
        }
        return locales.stream().anyMatch(locale -> layoutlib.isRtl(locale.toLocaleId()));
    }

    @NotNull
    private List<Locale> getRelevantLocales() {
        ResourceRepositoryManager repoManager;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return Collections.emptyList();
        }
        ConfigurationModelModule module2 = configuration.getConfigModule();
        LocaleQualifier specificLocale = configuration.getEditedConfig().getLocaleQualifier();
        if (specificLocale != null) {
            List<VirtualFile> variations = IdeResourcesUtil.getResourceVariations(configuration.getFile(), false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config2 == null || config2.getLocaleQualifier() != null) continue;
                specificLocale = null;
                break;
            }
        }
        SortedSet languages2 = (repoManager = module2.getResourceRepositoryManager()) != null ? ResourceRepositoryUtil.getLocales((ResourceRepository)repoManager.getProjectResources()) : Collections.emptySet();
        for (LocaleQualifier l : languages2) {
            if (specificLocale != null && !specificLocale.isMatchFor((ResourceQualifier)l)) continue;
            locales.add(Locale.create((LocaleQualifier)l));
        }
        return locales;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
            String brief = Locale.getLocaleLabel((Locale)locale, (boolean)true);
            presentation.setText(brief);
        } else {
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    private class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;
        private final boolean myIsCurrentLocale;

        public SetLocaleAction(ConfigurationHolder renderContext, @NotNull String title, Locale locale, boolean isCurrentLocale) {
            super(renderContext, title, null);
            this.myLocale = locale;
            this.myIsCurrentLocale = isCurrentLocale;
        }

        public void update(@NotNull AnActionEvent event2) {
            Presentation presentation = event2.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.myIsCurrentLocale);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent event2) {
            super.actionPerformed(event2);
            LocaleMenuAction.this.updateActions(event2.getDataContext());
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideLocale();
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
            super.pickedBetterMatch(file2, old2);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideLocale();
            }
        }

        private void setProjectWideLocale() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setLocale(this.myLocale);
            }
        }
    }

    private class EditTranslationAction
    extends AnAction {
        public EditTranslationAction() {
            super("Edit Translations...", null, null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Configuration configuration = LocaleMenuAction.this.myRenderContext.getConfiguration();
            if (configuration != null) {
                Module module2 = ((StudioConfigurationModelModule)configuration.getConfigModule()).getModule();
                StringResourceEditorProvider.openEditor(module2);
            }
        }
    }
}

