/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.idea.configurations.AddDeviceDefinitionAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.DeviceGroup;
import com.android.tools.idea.configurations.DeviceUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DeviceMenuAction
extends DropDownAction {
    private static final boolean LIST_RECENT_DEVICES = false;
    @NotNull
    private final ConfigurationHolder myRenderContext;
    @NotNull
    private final DeviceChangeListener myDeviceChangeListener;

    public DeviceMenuAction(@NotNull ConfigurationHolder renderContext, @NotNull DeviceChangeListener deviceChangeListener2) {
        super("Device for Preview", "Device for Preview", StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES);
        this.myRenderContext = renderContext;
        this.myDeviceChangeListener = deviceChangeListener2;
    }

    public void update(@NotNull AnActionEvent event2) {
        super.update(event2);
        this.updatePresentation(event2.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Device device2 = configuration.getCachedDevice();
            String label = DeviceMenuAction.getDeviceLabel(device2, true);
            presentation.setText(label, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getDeviceLabel(@Nullable Device device2, boolean brief) {
        if (device2 == null) {
            return "";
        }
        String name2 = device2.getDisplayName();
        if (brief) {
            int end;
            int begin;
            int nexus = name2.indexOf("Nexus");
            if (nexus != -1 && (begin = name2.indexOf(40)) != -1 && (end = name2.indexOf(41, ++begin)) != -1) {
                if (name2.equals("Nexus 7 (2012)")) {
                    return "Nexus 7";
                }
                return name2.substring(begin, end).trim();
            }
            String skipPrefix = "Android ";
            name2 = StringUtil.trimStart((String)name2, (String)skipPrefix);
        }
        return name2;
    }

    private static Icon getDeviceClassIcon(@Nullable Device device2) {
        if (device2 != null) {
            if (HardwareConfigHelper.isWear((Device)device2)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_WEAR;
            }
            if (HardwareConfigHelper.isTv((Device)device2)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TV;
            }
            if (HardwareConfigHelper.isAutomotive((Device)device2)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_AUTOMOTIVE;
            }
            if (DeviceArtPainter.isTablet((Device)device2)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TABLET;
            }
        }
        return StudioIcons.LayoutEditor.Toolbar.DEVICE_PHONE;
    }

    @VisibleForTesting
    public boolean updateActions(@NotNull DataContext context2) {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        Device current = configuration.getCachedDevice();
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        this.createDeviceMenuList(configuration, current);
        return true;
    }

    private void createDeviceMenuList(@NotNull Configuration configuration, @Nullable Device currentDevice) {
        Map<DeviceGroup, List<Device>> groupedDevices = DeviceUtils.getSuitableDevices(configuration);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_XL, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_TABLET, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.DESKTOP, currentDevice);
        this.addWearDeviceSection(groupedDevices, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.TV, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.AUTOMOTIVE, currentDevice);
        this.addCustomDeviceSection(currentDevice);
        this.addAvdDeviceSection(DeviceUtils.getAvdDevices(configuration), currentDevice);
        this.addGenericDeviceSection(groupedDevices.getOrDefault((Object)DeviceGroup.GENERIC, Collections.emptyList()), currentDevice);
        this.add(new AddDeviceDefinitionAction(this.myRenderContext));
    }

    private void addDeviceSection(@NotNull Map<DeviceGroup, List<Device>> groupedDevices, @NotNull DeviceGroup group2, @Nullable Device current) {
        List devices2 = groupedDevices.getOrDefault((Object)group2, Collections.emptyList());
        if (!devices2.isEmpty()) {
            this.add(new DeviceCategory(DeviceMenuAction.getGroupTitle(group2), null, DeviceMenuAction.getDeviceClassIcon((Device)devices2.get(0))));
            for (Device device2 : devices2) {
                String label = this.getLabel(device2, HardwareConfigHelper.isNexus((Device)device2));
                this.add(new SetDeviceAction(this.myRenderContext, label, this::updatePresentation, this.myDeviceChangeListener, device2, null, current == device2));
            }
            this.addSeparator();
        }
    }

    private void addWearDeviceSection(@NotNull Map<DeviceGroup, List<Device>> groupedDevices, @Nullable Device current) {
        List devices2 = groupedDevices.getOrDefault((Object)DeviceGroup.WEAR, Collections.emptyList());
        if (!devices2.isEmpty()) {
            this.add(new DeviceCategory(DeviceMenuAction.getGroupTitle(DeviceGroup.WEAR), null, DeviceMenuAction.getDeviceClassIcon((Device)devices2.get(0))));
            for (Device device2 : devices2) {
                String label = this.getLabel(device2, HardwareConfigHelper.isNexus((Device)device2));
                this.add(new SetWearDeviceAction(this.myRenderContext, label, this::updatePresentation, this.myDeviceChangeListener, device2, null, current == device2));
            }
            this.addSeparator();
        }
    }

    @NotNull
    private static String getGroupTitle(@NotNull DeviceGroup group2) {
        switch (group2) {
            case NEXUS: 
            case NEXUS_XL: {
                return "Phone";
            }
            case NEXUS_TABLET: {
                return "Tablet";
            }
            case DESKTOP: {
                return "Desktop";
            }
            case WEAR: {
                return "Wear";
            }
            case TV: {
                return "TV";
            }
            case AUTOMOTIVE: {
                return "Automotive";
            }
            case GENERIC: {
                return "Generic";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "Device";
    }

    private void addCustomDeviceSection(@Nullable Device currentDevice) {
        this.add(new SetCustomDeviceAction(this.myRenderContext, this::updatePresentation, currentDevice));
        this.addSeparator();
    }

    private void addAvdDeviceSection(@NotNull List<Device> devices2, @Nullable Device current) {
        if (!devices2.isEmpty()) {
            this.add(new DeviceCategory("Virtual Device", null, StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES));
            for (Device device2 : devices2) {
                boolean selected = current != null && current.getId().equals(device2.getId());
                String avdDisplayName = "AVD: " + device2.getDisplayName();
                this.add(new SetAvdAction(this.myRenderContext, this::updatePresentation, this.myDeviceChangeListener, device2, avdDisplayName, selected));
            }
            this.addSeparator();
        }
    }

    private void addGenericDeviceSection(@NotNull List<Device> devices2, @Nullable Device current) {
        if (!devices2.isEmpty()) {
            DefaultActionGroup genericGroup = DefaultActionGroup.createPopupGroup(() -> "_Generic Phones and Tablets");
            for (Device device2 : devices2) {
                String label = this.getLabel(device2, HardwareConfigHelper.isNexus((Device)device2));
                genericGroup.add((AnAction)new SetDeviceAction(this.myRenderContext, label, this::updatePresentation, this.myDeviceChangeListener, device2, null, current == device2));
            }
            this.add((AnAction)genericGroup);
        }
    }

    @NotNull
    public static ImmutableList<Device> getSortedDevicesInMenu(@NotNull Configuration configuration) {
        Map<DeviceGroup, List<Device>> groupedDevices = DeviceUtils.getSuitableDevices(configuration);
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.NEXUS_XL, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.NEXUS_TABLET, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.WEAR, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.TV, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.AUTOMOTIVE, Collections.emptyList()));
        builder2.addAll(DeviceUtils.getAvdDevices(configuration));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.GENERIC, Collections.emptyList()));
        return builder2.build();
    }

    private String getLabel(Device device2, boolean isNexus) {
        VirtualFile better;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (better = ConfigurationMatcher.getBetterMatch(configuration, device2, null, null, null)) != null) {
            return ConfigurationAction.getBetterMatchLabel(device2.getDisplayName(), better, configuration.getFile());
        }
        return isNexus ? HardwareConfigHelper.getNexusMenuLabel((Device)device2) : HardwareConfigHelper.getGenericLabel((Device)device2);
    }

    public static interface DeviceChangeListener {
        public void onDeviceChanged(@Nullable Device var1, @Nullable Device var2);
    }

    private static final class DeviceCategory
    extends AnAction {
        private Icon myIcon;

        public DeviceCategory(@Nullable String text2, @Nullable String description2, @Nullable Icon icon2) {
            super(text2, description2, null);
            this.myIcon = icon2;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setEnabled(false);
            p.setDisabledIcon(this.myIcon);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    }

    @VisibleForTesting
    public static class SetDeviceAction
    extends DeviceAction {
        @NotNull
        protected final DeviceChangeListener myDeviceChangeListener;
        @NotNull
        protected final Device myDevice;
        @NotNull
        private final String myTitle;
        private boolean mySelected;

        public SetDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull Consumer<Presentation> updatePresentationCallback, @NotNull DeviceChangeListener deviceChangeListener2, @NotNull Device device2, @Nullable Icon defaultIcon, boolean select2) {
            super(renderContext, null, updatePresentationCallback, SetDeviceAction.getBestIcon(title, defaultIcon));
            this.myDeviceChangeListener = deviceChangeListener2;
            this.myDevice = device2;
            this.myTitle = title;
            this.mySelected = select2;
        }

        @Nullable
        private static Icon getBestIcon(@NotNull String title, @Nullable Icon defaultIcon) {
            if (ConfigurationAction.isBetterMatchLabel(title)) {
                return ConfigurationAction.getBetterMatchIcon();
            }
            return defaultIcon;
        }

        public void update(@NotNull AnActionEvent event2) {
            super.update(event2);
            Presentation presentation = event2.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.mySelected);
            presentation.setText(this.myTitle, false);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            String wantedStateName;
            Device prevDevice = configuration.getCachedDevice();
            ConfigurationProjectState projectState = configuration.getConfigurationManager().getStateManager().getProjectState();
            String lastSelectedNonWearStateName = projectState.getNonWearDeviceLastSelectedStateName();
            String newDefaultStateName = this.myDevice.getDefaultState().getName();
            State wantedState = lastSelectedNonWearStateName != null ? this.getMatchingState(this.myDevice, lastSelectedNonWearStateName) : null;
            String string = wantedStateName = wantedState != null ? wantedState.getName() : newDefaultStateName;
            if (!wantedStateName.equals(newDefaultStateName) && projectState.isNonWearDeviceDefaultStateName() && !this.hasBetterMatchingLayoutFile(configuration, this.myDevice, newDefaultStateName)) {
                wantedStateName = newDefaultStateName;
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            }
            configuration.setDevice(this.myDevice, true);
            configuration.setDeviceState(this.getMatchingState(this.myDevice, wantedStateName));
            this.myDeviceChangeListener.onDeviceChanged(prevDevice, this.myDevice);
        }

        private boolean hasBetterMatchingLayoutFile(@NotNull Configuration configuration, @NotNull Device device2, @NotNull String stateName) {
            VirtualFile file2 = configuration.getFile();
            if (file2 == null) {
                return false;
            }
            return ConfigurationMatcher.getBetterMatch(configuration, device2, stateName, null, null) != null;
        }

        @Nullable
        private State getMatchingState(@NotNull Device device2, @NotNull String stateName) {
            return device2.getAllStates().stream().filter(state2 -> state2.getName().equalsIgnoreCase(stateName)).findFirst().orElse(null);
        }

        @Override
        @NotNull
        public Device getDevice() {
            return this.myDevice;
        }
    }

    static class SetWearDeviceAction
    extends SetDeviceAction {
        public SetWearDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull Consumer<Presentation> updatePresentationCallback, @NotNull DeviceChangeListener deviceChangeListener2, @NotNull Device device2, @Nullable Icon defaultIcon, boolean select2) {
            super(renderContext, title, updatePresentationCallback, deviceChangeListener2, device2, defaultIcon, select2);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            Device prevDevice = configuration.getCachedDevice();
            String newState = null;
            if (this.myDevice.getChinSize() != 0) {
                State state2 = this.myDevice.getState(ScreenOrientation.LANDSCAPE.getShortDisplayValue());
                if (state2 != null) {
                    newState = state2.getName();
                    configuration.setDeviceState(state2);
                } else {
                    Logger.getLogger(DeviceMenuAction.class.getName()).warning("A wear chin device must have landscape state");
                }
            } else {
                State state3 = this.myDevice.getState(ScreenOrientation.PORTRAIT.getShortDisplayValue());
                if (state3 != null) {
                    newState = state3.getName();
                    configuration.setDeviceState(state3);
                } else {
                    Logger.getLogger(DeviceMenuAction.class.getName()).warning("A wear round or square device must have portrait state");
                }
            }
            if (newState != null) {
                configuration.setDeviceStateName(newState);
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            }
            configuration.setDevice(this.myDevice, true);
            this.myDeviceChangeListener.onDeviceChanged(prevDevice, this.myDevice);
        }
    }

    static class SetCustomDeviceAction
    extends DeviceAction {
        private static final String CUSTOM_DEVICE_NAME = "Custom";
        @Nullable
        private final Device myDevice;
        @Nullable
        private Device myCustomDevice;

        public SetCustomDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull Consumer<Presentation> updatePresentationCallback, @Nullable Device device2) {
            super(renderContext, CUSTOM_DEVICE_NAME, updatePresentationCallback, null);
            this.myDevice = device2;
        }

        public void update(@NotNull AnActionEvent event2) {
            super.update(event2);
            Toggleable.setSelected((Presentation)event2.getPresentation(), (this.myDevice != null && CUSTOM_DEVICE_NAME.equals(this.myDevice.getId()) ? 1 : 0) != 0);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (this.myDevice != null) {
                Device.Builder customBuilder = new Device.Builder(this.myDevice);
                customBuilder.setTagId(this.myDevice.getTagId());
                customBuilder.setName(CUSTOM_DEVICE_NAME);
                customBuilder.setId(CUSTOM_DEVICE_NAME);
                this.myCustomDevice = customBuilder.build();
                configuration.setDevice(this.myCustomDevice, false);
            }
        }

        @Override
        @Nullable
        public Device getDevice() {
            return this.myCustomDevice;
        }
    }

    static class SetAvdAction
    extends ConfigurationAction {
        @Nullable
        private final Consumer<Presentation> myUpdatePresentationCallback;
        @NotNull
        private final Device myAvdDevice;
        private final boolean mySelected;
        @NotNull
        protected final DeviceChangeListener myDeviceChangeListener;

        public SetAvdAction(@NotNull ConfigurationHolder renderContext, @Nullable Consumer<Presentation> updatePresentationCallback, @NotNull DeviceChangeListener deviceChangeListener2, @NotNull Device avdDevice, @NotNull String displayName2, boolean select2) {
            super(renderContext, displayName2);
            this.myUpdatePresentationCallback = updatePresentationCallback;
            this.myDeviceChangeListener = deviceChangeListener2;
            this.myAvdDevice = avdDevice;
            this.mySelected = select2;
        }

        public void update(@NotNull AnActionEvent event2) {
            super.update(event2);
            Toggleable.setSelected((Presentation)event2.getPresentation(), (boolean)this.mySelected);
        }

        @Override
        protected void updatePresentation(@NotNull Presentation presentation) {
            if (this.myUpdatePresentationCallback != null) {
                this.myUpdatePresentationCallback.accept(presentation);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myAvdDevice);
            }
            configuration.setDevice(this.myAvdDevice, false);
            this.myDeviceChangeListener.onDeviceChanged(configuration.getCachedDevice(), this.myAvdDevice);
        }
    }

    static abstract class DeviceAction
    extends ConfigurationAction {
        @NotNull
        private final Consumer<Presentation> myUpdatePresentationCallback;

        DeviceAction(@NotNull ConfigurationHolder renderContext, @Nullable String title, @NotNull Consumer<Presentation> updatePresentationCallback, @Nullable Icon icon2) {
            super(renderContext, title, icon2);
            this.myUpdatePresentationCallback = updatePresentationCallback;
        }

        @Override
        protected final void updatePresentation(@NotNull Presentation presentation) {
            this.myUpdatePresentationCallback.accept(presentation);
        }

        @Nullable
        public abstract Device getDevice();
    }
}

