/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationModelModule;
import com.android.tools.idea.configurations.DeviceUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.utils.SdkUtils;
import com.android.utils.SparseIntArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ConfigurationMatcher");
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final ConfigurationManager myManager;
    @Nullable
    private final ResourceRepository myResources;
    @Nullable
    private final ResourceNamespace myNamespace;
    @Nullable
    private final VirtualFile myFile;

    public ConfigurationMatcher(@NotNull Configuration configuration, @Nullable VirtualFile file2) {
        this.myConfiguration = configuration;
        this.myFile = file2;
        this.myManager = this.myConfiguration.getConfigurationManager();
        ResourceRepositoryManager repositoryManager = this.myManager.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            this.myResources = null;
            this.myNamespace = null;
        } else {
            this.myResources = repositoryManager.getAppResources();
            this.myNamespace = repositoryManager.getNamespace();
        }
    }

    public boolean isCurrentFileBestMatchFor(@NotNull FolderConfiguration config2) {
        if (this.myResources != null && this.myNamespace != null && this.myFile != null) {
            VirtualFile match2;
            ResourceReference reference = new ResourceReference(this.myNamespace, ConfigurationMatcher.getResourceType(this.myFile), SdkUtils.fileNameToResourceName((String)this.myFile.getName()));
            List<VirtualFile> files2 = ConfigurationMatcher.getMatchingFiles(this.myResources, reference, config2, new HashSet<ResourceReference>(), true, 0);
            VirtualFile virtualFile = match2 = files2.isEmpty() ? null : files2.get(0);
            if (match2 != null) {
                return this.myFile.equals(match2);
            }
            LOG.debug("Current file is not a match for the given config.");
        }
        return false;
    }

    private static ResourceType getResourceType(@NotNull VirtualFile file2) {
        List related;
        ResourceFolderType folderType;
        String parentName;
        ResourceType type = ResourceType.LAYOUT;
        VirtualFile parent2 = file2.getParent();
        if (parent2 != null && !(parentName = parent2.getName()).startsWith("layout") && (folderType = ResourceFilesUtil.getFolderType(file2)) != null && !(related = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
            type = (ResourceType)related.get(0);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> getBestFileMatches() {
        if (this.myResources != null && this.myNamespace != null && this.myFile != null) {
            FolderConfiguration config2 = this.myConfiguration.getFullConfig();
            VersionQualifier prevQualifier = config2.getVersionQualifier();
            try {
                config2.setVersionQualifier(null);
                List<VirtualFile> list2 = ConfigurationMatcher.getMatchingFiles(this.myResources, this.myFile, this.myNamespace, ConfigurationMatcher.getResourceType(this.myFile), config2);
                return list2;
            }
            finally {
                config2.setVersionQualifier(prevQualifier);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<VirtualFile> getMatchingFiles(@NotNull ResourceRepository repository2, @NotNull VirtualFile file2, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration config2) {
        ResourceReference reference = new ResourceReference(namespace, type, SdkUtils.fileNameToResourceName((String)file2.getName()));
        return ConfigurationMatcher.getMatchingFiles(repository2, reference, config2, new HashSet<ResourceReference>(), false, 0);
    }

    @NotNull
    private static List<VirtualFile> getMatchingFiles(@NotNull ResourceRepository repository2, @NotNull ResourceReference reference, @NotNull FolderConfiguration config2, @NotNull Set<ResourceReference> seenResources, boolean firstOnly, int depth) {
        if (depth >= 50 || !seenResources.add(reference)) {
            return Collections.emptyList();
        }
        List matchingItems = repository2.getResources(reference.getNamespace(), reference.getResourceType(), reference.getName());
        if (matchingItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> output = new ArrayList<VirtualFile>();
        List matches = config2.findMatchingConfigurables((Collection)matchingItems);
        for (ResourceItem match2 : matches) {
            ResourceUrl url;
            String value2;
            if (firstOnly && !output.isEmpty()) break;
            ResourceValue resourceValue = match2.getResourceValue();
            if (resourceValue != null && (value2 = resourceValue.getValue()) != null && value2.startsWith("@") && (url = ResourceUrl.parse((String)value2)) != null && url.type == reference.getResourceType() && !url.isFramework()) {
                ResourceNamespace namespace = ResourceNamespace.fromNamespacePrefix((String)url.namespace, (ResourceNamespace)reference.getNamespace(), (ResourceNamespace.Resolver)resourceValue.getNamespaceResolver());
                if (namespace == null) continue;
                ResourceReference ref = new ResourceReference(namespace, reference.getResourceType(), url.name);
                output.addAll(ConfigurationMatcher.getMatchingFiles(repository2, ref, config2, seenResources, firstOnly, depth + 1));
                continue;
            }
            VirtualFile virtualFile = IdeResourcesUtil.getSourceAsVirtualFile(match2);
            if (virtualFile == null) continue;
            output.add(virtualFile);
        }
        return output;
    }

    @NotNull
    public List<com.android.ide.common.resources.Locale> getPrioritizedLocales() {
        ImmutableList<com.android.ide.common.resources.Locale> projectLocales = this.myManager.getLocalesInProject();
        ArrayList<com.android.ide.common.resources.Locale> locales = new ArrayList<com.android.ide.common.resources.Locale>(projectLocales.size() + 1);
        com.android.ide.common.resources.Locale current = this.myManager.getLocale();
        locales.add(current);
        for (com.android.ide.common.resources.Locale locale : projectLocales) {
            if (locale.equals((Object)current)) continue;
            locales.add(locale);
        }
        return locales;
    }

    void adaptConfigSelection(boolean needBestMatch) {
        FolderConfiguration currentConfig;
        boolean needConfigChange = true;
        boolean currentConfigIsCompatible = false;
        State selectedState = this.myConfiguration.getDeviceState();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        ConfigurationModelModule module2 = this.myConfiguration.getConfigModule();
        if (selectedState != null && editedConfig.isMatchFor(currentConfig = Configuration.getFolderConfig(module2, selectedState, this.myConfiguration.getLocale(), this.myConfiguration.getTarget()))) {
            currentConfigIsCompatible = true;
            if (!needBestMatch || this.isCurrentFileBestMatchFor(currentConfig)) {
                needConfigChange = false;
            }
        }
        if (needConfigChange) {
            List<com.android.ide.common.resources.Locale> localeList = this.getPrioritizedLocales();
            FolderConfiguration testConfig = new FolderConfiguration();
            State matchState = null;
            Device device2 = this.myConfiguration.getDevice();
            IAndroidTarget target2 = this.myConfiguration.getTarget();
            if (device2 != null && target2 != null) {
                VersionQualifier versionQualifier = new VersionQualifier(target2.getVersion().getFeatureLevel());
                block0: for (State state2 : device2.getAllStates()) {
                    testConfig.set(Configuration.getFolderConfig(module2, state2, this.myConfiguration.getLocale(), target2));
                    testConfig.setVersionQualifier(versionQualifier);
                    for (int i = 0; i < localeList.size(); ++i) {
                        com.android.ide.common.resources.Locale locale = localeList.get(i);
                        testConfig.setLocaleQualifier(locale.qualifier);
                        if (!editedConfig.isMatchFor(testConfig) || !this.isCurrentFileBestMatchFor(testConfig)) continue;
                        matchState = state2;
                        break block0;
                    }
                }
            }
            if (matchState != null) {
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setDeviceState(matchState);
                this.myConfiguration.setEffectiveDevice(device2, matchState);
                this.myConfiguration.finishBulkEditing();
            } else {
                this.findAndSetCompatibleConfig(currentConfigIsCompatible);
            }
        }
    }

    void findAndSetCompatibleConfig(boolean favorCurrentConfig) {
        int max;
        int start2;
        List<com.android.ide.common.resources.Locale> localeList = this.getPrioritizedLocales();
        ImmutableList<Device> deviceList2 = this.myManager.getDevices();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        FolderConfiguration currentConfig = this.myConfiguration.getFullConfig();
        ArrayList<ConfigMatch> anyMatches = new ArrayList<ConfigMatch>();
        ArrayList<ConfigMatch> bestMatches = new ArrayList<ConfigMatch>();
        int localeHostMatch = this.getLocaleMatch();
        ArrayList<ConfigBundle> configBundles = new ArrayList<ConfigBundle>(200);
        if (editedConfig.getLocaleQualifier() != null || localeHostMatch == -1) {
            start2 = 0;
            max = localeList.size();
        } else {
            start2 = localeHostMatch;
            max = localeHostMatch + 1;
        }
        int i = start2;
        while (i < max) {
            com.android.ide.common.resources.Locale l = localeList.get(i);
            ConfigBundle bundle2 = new ConfigBundle();
            bundle2.config.setLocaleQualifier(l.qualifier);
            bundle2.localeIndex = i++;
            configBundles.add(bundle2);
        }
        ConfigurationMatcher.addDockModeToBundles(configBundles);
        ConfigurationMatcher.addNightModeToBundles(configBundles);
        this.addRenderTargetToBundles(configBundles);
        com.android.ide.common.resources.Locale currentLocale = this.myConfiguration.getLocale();
        IAndroidTarget currentTarget = this.myConfiguration.getTarget();
        ConfigurationModelModule module2 = this.myConfiguration.getConfigModule();
        for (Device device2 : deviceList2) {
            for (State state2 : device2.getAllStates()) {
                FolderConfiguration stateConfig = Configuration.getFolderConfig(module2, state2, currentLocale, currentTarget);
                for (ConfigBundle bundle3 : configBundles) {
                    FolderConfiguration testConfig = new FolderConfiguration();
                    testConfig.set(stateConfig);
                    testConfig.add(bundle3.config);
                    if (!editedConfig.isMatchFor(testConfig)) continue;
                    anyMatches.add(new ConfigMatch(testConfig, device2, state2, bundle3));
                    if (!this.isCurrentFileBestMatchFor(testConfig)) continue;
                    bestMatches.add(new ConfigMatch(testConfig, device2, state2, bundle3));
                }
            }
        }
        if (bestMatches.isEmpty()) {
            if (favorCurrentConfig) {
                if (!editedConfig.isMatchFor(currentConfig)) {
                    LOG.warn("favorCurrentConfig can only be true if the current config is compatible");
                }
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with '%3$s'.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            } else if (!anyMatches.isEmpty()) {
                match = this.selectConfigMatch(anyMatches);
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setEffectiveDevice(match.device, match.state);
                this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
                this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
                this.myConfiguration.finishBulkEditing();
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with\n  %3$s\nwhich is compatible, but will actually be displayed with another more specific version of the layout.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            }
        } else {
            match = this.selectConfigMatch(bestMatches);
            this.myConfiguration.startBulkEditing();
            this.myConfiguration.setEffectiveDevice(match.device, match.state);
            this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
            this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
            this.myConfiguration.finishBulkEditing();
        }
    }

    private void addRenderTargetToBundles(List<ConfigBundle> configBundles) {
        IAndroidTarget target2 = this.myManager.getTarget();
        if (target2 != null) {
            int apiLevel = target2.getVersion().getFeatureLevel();
            for (ConfigBundle bundle2 : configBundles) {
                bundle2.config.setVersionQualifier(new VersionQualifier(apiLevel));
            }
        }
    }

    private static void addDockModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list2 = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle2 : addConfig) {
            int index2 = 0;
            for (UiMode mode : UiMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle2);
                b.config.setUiModeQualifier(new UiModeQualifier(mode));
                b.dockModeIndex = index2++;
                list2.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list2);
    }

    private static void addNightModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list2 = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle2 : addConfig) {
            int index2 = 0;
            for (NightMode mode : NightMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle2);
                b.config.setNightModeQualifier(new NightModeQualifier(mode));
                b.nightModeIndex = index2++;
                list2.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list2);
    }

    private int getLocaleMatch() {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != null) {
            LocaleQualifier qualifier;
            com.android.ide.common.resources.Locale locale;
            int l;
            String currentLanguage = defaultLocale.getLanguage();
            String currentRegion = defaultLocale.getCountry();
            ImmutableList<com.android.ide.common.resources.Locale> localeList = this.myManager.getLocalesInProject();
            int count2 = localeList.size();
            for (l = 0; l < count2; ++l) {
                locale = (com.android.ide.common.resources.Locale)localeList.get(l);
                qualifier = locale.qualifier;
                if (!Objects.equals(qualifier.getLanguage(), currentLanguage) || qualifier.getRegion() != null && !qualifier.getRegion().equals(currentRegion)) continue;
                return l;
            }
            for (l = 0; l < count2; ++l) {
                locale = (com.android.ide.common.resources.Locale)localeList.get(l);
                qualifier = locale.qualifier;
                if (!Objects.equals(qualifier.getLanguage(), currentLanguage)) continue;
                return l;
            }
        }
        return 0;
    }

    @NotNull
    private ConfigMatch selectConfigMatch(@NotNull List<ConfigMatch> matches) {
        FileDocumentManager documentManager;
        VirtualFile file2;
        Editor activeEditor;
        List<String> deviceIds = this.myManager.getStateManager().getProjectState().getDeviceIds();
        HashMap idRank = Maps.newHashMapWithExpectedSize((int)deviceIds.size());
        int rank = 0;
        for (String id2 : deviceIds) {
            idRank.put(id2, rank++);
        }
        Comparator<ConfigMatch> comparator2 = null;
        if (DeviceUtils.isUseWearDeviceAsDefault(this.myConfiguration)) {
            comparator2 = new WearConfigComparator(this.myConfiguration.getConfigurationManager(), idRank);
        } else {
            int apiLevel;
            IAndroidTarget projectTarget = this.myManager.getProjectTarget();
            if (projectTarget != null && (apiLevel = projectTarget.getVersion().getFeatureLevel()) >= 11 && apiLevel < 14) {
                comparator2 = new TabletConfigComparator(idRank);
            }
        }
        if (comparator2 == null) {
            comparator2 = new PhoneConfigComparator(idRank);
        }
        Collections.sort(matches, comparator2);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myManager.getProject());
        if (editorManager instanceof FileEditorManagerImpl && (activeEditor = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true)) != null && (file2 = (documentManager = FileDocumentManager.getInstance()).getFile(activeEditor.getDocument())) != null && !file2.equals(this.myFile) && file2.getFileType() == XmlFileType.INSTANCE && ResourceFilesUtil.getFolderType(this.myFile) == ResourceFilesUtil.getFolderType(file2)) {
            Configuration configuration = this.myManager.getConfiguration(file2);
            FolderConfiguration fullConfig = configuration.getFullConfig();
            for (ConfigMatch match2 : matches) {
                if (!fullConfig.equals((Object)match2.testConfig)) continue;
                return match2;
            }
        }
        return matches.get(0);
    }

    @Nullable
    public static VirtualFile getBetterMatch(@NotNull Configuration configuration, @Nullable Device device2, @Nullable String stateName, @Nullable com.android.ide.common.resources.Locale locale, @Nullable IAndroidTarget target2) {
        VirtualFile file2 = configuration.getFile();
        ConfigurationModelModule module2 = configuration.getConfigModule();
        if (file2 != null) {
            ResourceRepositoryManager repositoryManager;
            FolderConfiguration currentConfig;
            State selectedState;
            if (device2 == null) {
                device2 = configuration.getCachedDevice();
            }
            if (stateName == null) {
                State deviceState = configuration.getDeviceState();
                String string = stateName = deviceState != null ? deviceState.getName() : null;
            }
            if ((selectedState = ConfigurationFileState.getState(device2, stateName)) == null) {
                return null;
            }
            if (locale == null) {
                locale = configuration.getLocale();
            }
            if (target2 == null) {
                target2 = configuration.getTarget();
            }
            if ((currentConfig = Configuration.getFolderConfig(module2, selectedState, locale, target2)) != null && (repositoryManager = configuration.getConfigModule().getResourceRepositoryManager()) != null) {
                List types2;
                CacheableResourceRepository resources2 = repositoryManager.getAppResources();
                ResourceFolderType folderType = ResourceFilesUtil.getFolderType(file2);
                if (folderType != null && !(types2 = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
                    ResourceType type = (ResourceType)types2.get(0);
                    List<VirtualFile> matches = ConfigurationMatcher.getMatchingFiles(resources2, file2, repositoryManager.getNamespace(), type, currentConfig);
                    if (!matches.contains(file2) && !matches.isEmpty()) {
                        return matches.get(0);
                    }
                }
            }
        }
        return null;
    }

    private static class ConfigBundle {
        private final FolderConfiguration config = new FolderConfiguration();
        private int localeIndex;
        private int dockModeIndex;
        private int nightModeIndex;

        private ConfigBundle() {
        }

        private ConfigBundle(ConfigBundle bundle2) {
            this.config.set(bundle2.config);
            this.localeIndex = bundle2.localeIndex;
            this.dockModeIndex = bundle2.dockModeIndex;
            this.nightModeIndex = bundle2.nightModeIndex;
        }

        public String toString() {
            return this.config.getQualifierString();
        }
    }

    private static class ConfigMatch {
        final FolderConfiguration testConfig;
        final Device device;
        final State state;
        final ConfigBundle bundle;

        public ConfigMatch(@NotNull FolderConfiguration testConfig, @NotNull Device device2, @NotNull State state2, @NotNull ConfigBundle bundle2) {
            this.testConfig = testConfig;
            this.device = device2;
            this.state = state2;
            this.bundle = bundle2;
        }

        public String toString() {
            return this.device.getDisplayName() + " - " + this.state.getName() + " - " + this.bundle;
        }
    }

    private static class WearConfigComparator
    implements Comparator<ConfigMatch> {
        private final Map<String, Integer> mIdRank;
        private final List<String> myPreferredIds;

        private WearConfigComparator(@NotNull ConfigurationManager manager, @NotNull Map<String, Integer> idRank) {
            this.mIdRank = idRank;
            this.myPreferredIds = manager.getDevices().stream().filter(HardwareConfigHelper::isWear).map(Device::getId).collect(Collectors.toList());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            int index2;
            int index1;
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if ((index1 = this.myPreferredIds.indexOf(n1)) == (index2 = this.myPreferredIds.indexOf(n2))) return 0;
            if (index1 == -1) {
                return 1;
            }
            if (index2 != -1) return index1 - index2;
            return -1;
        }
    }

    private static class TabletConfigComparator
    implements Comparator<ConfigMatch> {
        private final Map<String, Integer> mIdRank;
        private static final String PREFERRED_ID = "Nexus 10";

        private TabletConfigComparator(Map<String, Integer> idRank) {
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            ScreenSize ss2;
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            ScreenSizeQualifier size1 = config1.getScreenSizeQualifier();
            ScreenSizeQualifier size2 = config2.getScreenSizeQualifier();
            ScreenSize ss1 = size1 != null ? size1.getValue() : ScreenSize.NORMAL;
            ScreenSize screenSize = ss2 = size2 != null ? size2.getValue() : ScreenSize.NORMAL;
            if (ss1 == ScreenSize.XLARGE) {
                ScreenOrientationQualifier orientation2;
                ScreenOrientation so2;
                ScreenOrientation so1;
                if (ss2 != ScreenSize.XLARGE) return -1;
                ScreenOrientationQualifier orientation1 = config1.getScreenOrientationQualifier();
                ScreenOrientation screenOrientation = so1 = orientation1 == null ? null : orientation1.getValue();
                if (so1 == null) {
                    so1 = ScreenOrientation.PORTRAIT;
                }
                ScreenOrientation screenOrientation2 = so2 = (orientation2 = config2.getScreenOrientationQualifier()) == null ? null : orientation2.getValue();
                if (so2 == null) {
                    so2 = ScreenOrientation.PORTRAIT;
                }
                if (so1 == ScreenOrientation.LANDSCAPE) {
                    if (so2 != ScreenOrientation.LANDSCAPE) return -1;
                    return 0;
                }
                if (so2 != ScreenOrientation.LANDSCAPE) return 0;
                return 1;
            }
            if (ss2 != ScreenSize.XLARGE) return 0;
            return 1;
        }
    }

    private static class PhoneConfigComparator
    implements Comparator<ConfigMatch> {
        private static final String PREFERRED_ID = "pixel";
        private final SparseIntArray mDensitySort = new SparseIntArray(4);
        private final Map<String, Integer> mIdRank;

        public PhoneConfigComparator(Map<String, Integer> idRank) {
            int i = 0;
            this.mDensitySort.put(Density.HIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.MEDIUM.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_400.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_560.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_420.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_360.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_280.getDpiValue(), ++i);
            this.mDensitySort.put(Density.TV.getDpiValue(), ++i);
            this.mDensitySort.put(Density.LOW.getDpiValue(), ++i);
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            int dpi1 = Density.DEFAULT_DENSITY;
            int dpi2 = Density.DEFAULT_DENSITY;
            DensityQualifier dpiQualifier1 = config1.getDensityQualifier();
            if (dpiQualifier1 != null) {
                Density value2 = dpiQualifier1.getValue();
                dpi1 = value2 != null ? value2.getDpiValue() : Density.DEFAULT_DENSITY;
            }
            dpi1 = this.mDensitySort.get(dpi1, 100);
            DensityQualifier dpiQualifier2 = config2.getDensityQualifier();
            if (dpiQualifier2 != null) {
                Density value3 = dpiQualifier2.getValue();
                dpi2 = value3 != null ? value3.getDpiValue() : Density.DEFAULT_DENSITY;
            }
            if (dpi1 != (dpi2 = this.mDensitySort.get(dpi2, 100))) return dpi1 - dpi2;
            ScreenOrientation so1 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier1 = config1.getScreenOrientationQualifier();
            if (orientationQualifier1 != null && (so1 = orientationQualifier1.getValue()) == null) {
                so1 = ScreenOrientation.PORTRAIT;
            }
            ScreenOrientation so2 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier2 = config2.getScreenOrientationQualifier();
            if (orientationQualifier2 != null && (so2 = orientationQualifier2.getValue()) == null) {
                so2 = ScreenOrientation.PORTRAIT;
            }
            if (so1 == ScreenOrientation.PORTRAIT) {
                if (so2 != ScreenOrientation.PORTRAIT) return -1;
                return 0;
            }
            if (so2 != ScreenOrientation.PORTRAIT) return 0;
            return 1;
        }
    }
}

