/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.AdaptiveIconShape;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationModelModule;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.DeviceUtils;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.rendering.EnvironmentContext;
import com.android.tools.idea.rendering.InsufficientDataException;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.idea.res.ResourceUtils;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
implements Disposable,
ModificationTracker {
    public static final String AVD_ID_PREFIX = "_android_virtual_device_id_";
    public static final String CUSTOM_DEVICE_ID = "Custom";
    private static final int UI_MODE_TYPE_MASK = 15;
    private static final int UI_MODE_TYPE_APPLIANCE = 5;
    private static final int UI_MODE_TYPE_CAR = 3;
    private static final int UI_MODE_TYPE_DESK = 2;
    private static final int UI_MODE_TYPE_NORMAL = 1;
    private static final int UI_MODE_TYPE_TELEVISION = 4;
    private static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final int UI_MODE_TYPE_WATCH = 6;
    private static final int UI_MODE_NIGHT_MASK = 48;
    private static final int UI_MODE_NIGHT_YES = 32;
    private static final int UI_MODE_NIGHT_NO = 16;
    @Nullable
    final VirtualFile myFile;
    @Nullable
    private PsiFile myPsiFile;
    @NotNull
    protected final FolderConfiguration myFullConfig = new FolderConfiguration();
    @NotNull
    protected final ConfigurationManager myManager;
    @NotNull
    protected final FolderConfiguration myEditedConfig;
    @Nullable
    private IAndroidTarget myTarget;
    @Nullable
    private String myTheme;
    @Nullable
    private Device mySpecificDevice;
    @Nullable
    private State myState;
    @Nullable
    private Device myDevice;
    @Nullable
    private String myStateName;
    @Nullable
    private String myActivity;
    @Nullable
    private Locale myLocale = null;
    @NotNull
    private UiMode myUiMode = UiMode.NORMAL;
    @NotNull
    private NightMode myNightMode = NightMode.NOTNIGHT;
    private String myDisplayName;
    private int myBulkEditingCount;
    @Nullable
    private List<ConfigurationListener> myListeners;
    protected int myNotifyDirty;
    protected int myFolderConfigDirty = 246;
    protected int myProjectStateVersion;
    private long myModificationCount;
    private float myFontScale = 1.0f;
    private int myUiModeFlagValue;
    @NotNull
    private AdaptiveIconShape myAdaptiveShape = AdaptiveIconShape.getDefaultShape();
    private boolean myUseThemedIcon = false;
    private String myWallpaperPath = null;
    private static final String NO_ACTIVITY = new String();

    protected Configuration(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @NotNull FolderConfiguration editedConfig) {
        this.myManager = manager;
        this.myFile = file2;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = Locale.create((FolderConfiguration)editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @NotNull FolderConfiguration editedConfig) {
        return new Configuration(manager, file2, editedConfig);
    }

    @NotNull
    public static Configuration create(@NotNull Configuration base, @NotNull VirtualFile file2) {
        Configuration configuration = Configuration.copyWithNewFile(base, file2);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file2);
        configuration.getEditedConfig().set(FolderConfiguration.getConfigForFolder((String)file2.getParent().getName()));
        matcher.adaptConfigSelection(true);
        return configuration;
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
        Configuration configuration = new Configuration(manager, file2, editedConfig);
        configuration.startBulkEditing();
        if (fileState != null) {
            fileState.loadState(configuration);
        }
        configuration.finishBulkEditing();
        return configuration;
    }

    @NotNull
    public static Configuration copy(@NotNull Configuration original) {
        return Configuration.copyWithNewFile(original, original.myFile);
    }

    @NotNull
    private static Configuration copyWithNewFile(@NotNull Configuration original, @Nullable VirtualFile newFile2) {
        FolderConfiguration copiedConfig = new FolderConfiguration();
        copiedConfig.set(original.getEditedConfig());
        Configuration copy = new Configuration(original.myManager, newFile2, copiedConfig);
        copy.myFullConfig.set(original.myFullConfig);
        copy.myFolderConfigDirty = original.myFolderConfigDirty;
        copy.myProjectStateVersion = original.myProjectStateVersion;
        copy.myTarget = original.myTarget;
        copy.myLocale = original.myLocale;
        copy.myTheme = original.getTheme();
        copy.mySpecificDevice = original.mySpecificDevice;
        copy.myDevice = original.myDevice;
        copy.myStateName = original.myStateName;
        copy.myState = original.myState;
        copy.myActivity = original.getActivity();
        copy.myUiMode = original.getUiMode();
        copy.myNightMode = original.getNightMode();
        copy.myDisplayName = original.getDisplayName();
        copy.myFontScale = original.myFontScale;
        copy.myUiModeFlagValue = original.myUiModeFlagValue;
        copy.myAdaptiveShape = original.myAdaptiveShape;
        copy.myUseThemedIcon = original.myUseThemedIcon;
        copy.myWallpaperPath = original.myWallpaperPath;
        return copy;
    }

    public Configuration clone() {
        return Configuration.copy(this);
    }

    public void save() {
        ConfigurationStateManager stateManager = this.myManager.getConfigModule().getConfigurationStateManager();
        if (this.myFile != null) {
            ConfigurationFileState fileState = new ConfigurationFileState();
            fileState.saveState(this);
            stateManager.setConfigurationState(this.myFile, fileState);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        return this.myManager;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public PsiFile getPsiFile() {
        if (this.myPsiFile == null && this.myFile != null) {
            this.myPsiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myManager.getProject(), (VirtualFile)this.myFile);
        }
        return this.myPsiFile;
    }

    @Nullable
    public String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null && this.myFile != null) {
            this.myActivity = (String)ApplicationManager.getApplication().runReadAction(() -> {
                XmlAttribute attribute2;
                XmlFile xmlFile;
                XmlTag rootTag;
                if (this.myPsiFile == null) {
                    this.myPsiFile = PsiManager.getInstance((Project)this.myManager.getProject()).findFile(this.myFile);
                }
                if (this.myPsiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)this.myPsiFile).getRootTag()) != null && (attribute2 = rootTag.getAttribute("context", "http://schemas.android.com/tools")) != null) {
                    return attribute2.getValue();
                }
                return null;
            });
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Slow
    @Nullable
    public Device getDevice() {
        Device cached2 = this.getCachedDevice();
        if (cached2 != null) {
            return cached2;
        }
        this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        return this.myDevice;
    }

    @Nullable
    public Device getCachedDevice() {
        return this.myDevice;
    }

    @Nullable
    public static FolderConfiguration getFolderConfig(@NotNull ConfigurationModelModule module2, @NotNull State state2, @NotNull Locale locale, @Nullable IAndroidTarget target2) {
        FolderConfiguration currentConfig = DeviceConfigHelper.getFolderConfig((State)state2);
        if (currentConfig != null && locale.hasLanguage()) {
            currentConfig.setLocaleQualifier(locale.qualifier);
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(target2, module2.getAndroidPlatform(), module2.getEnvironmentContext());
            if (layoutLib != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    private static LayoutLibrary getLayoutLibrary(IAndroidTarget target2, AndroidPlatform platform, EnvironmentContext context2) {
        try {
            return RenderService.getLayoutLibrary(target2, platform, context2);
        }
        catch (RenderingException | InsufficientDataException ignored) {
            return null;
        }
    }

    @Slow
    @Nullable
    private Device computeBestDevice() {
        for (Device device2 : this.myManager.getRecentDevices(DeviceUtils.getAvdDevices(this))) {
            ResourceRepositoryManager repositoryManager;
            String stateName = this.myStateName;
            if (stateName == null) {
                stateName = device2.getDefaultState().getName();
            }
            State selectedState = ConfigurationFileState.getState(device2, stateName);
            Module module2 = this.getModule();
            FolderConfiguration currentConfig = Configuration.getFolderConfig(this.myManager.getConfigModule(), selectedState, this.getLocale(), this.getTarget());
            if (currentConfig == null || !this.myEditedConfig.isMatchFor(currentConfig) || (repositoryManager = this.myManager.getConfigModule().getResourceRepositoryManager()) == null || this.myFile == null) continue;
            ResourceFolderType folderType = ResourceFilesUtil.getFolderType(this.myFile);
            if (folderType != null) {
                if (ResourceFolderType.VALUES.equals((Object)folderType)) {
                    LocalResourceManager resourceManager = LocalResourceManager.getInstance(module2);
                    if (resourceManager == null) continue;
                    for (PsiFile resourceFile : resourceManager.findResourceFiles(ResourceNamespace.TODO(), ResourceFolderType.VALUES)) {
                        FolderConfiguration folderConfiguration;
                        PsiDirectory parent2;
                        if (!this.myFile.equals(resourceFile.getVirtualFile()) || (parent2 = AndroidPsiUtils.getPsiDirectorySafely((PsiFile)resourceFile)) == null || !currentConfig.isMatchFor(folderConfiguration = FolderConfiguration.getConfigForFolder((String)parent2.getName()))) continue;
                        return device2;
                    }
                    continue;
                }
                List types2 = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                if (types2.isEmpty()) continue;
                ResourceType type = (ResourceType)types2.get(0);
                CacheableResourceRepository resources2 = repositoryManager.getAppResources();
                List<VirtualFile> matches = ConfigurationMatcher.getMatchingFiles(resources2, this.myFile, ResourceNamespace.TODO(), type, currentConfig);
                if (!matches.contains(this.myFile)) continue;
                return device2;
            }
            if ("Kotlin".equals(this.myFile.getFileType().getName())) {
                return device2;
            }
            if (!this.myFile.equals(this.myManager.getProject().getProjectFile())) continue;
            return device2;
        }
        return this.myManager.getDefaultDevice();
    }

    @Nullable
    public State getDeviceState() {
        if (this.myState == null) {
            Device device2 = this.getDevice();
            this.myState = ConfigurationFileState.getState(device2, this.myStateName);
        }
        return this.myState;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            return this.myManager.getLocale();
        }
        return this.myLocale;
    }

    @NotNull
    public UiMode getUiMode() {
        return this.myUiMode;
    }

    @NotNull
    public NightMode getNightMode() {
        return this.myNightMode;
    }

    @NotNull
    public String getTheme() {
        if (this.myTheme == null) {
            this.myTheme = this.myManager.computePreferredTheme(this);
        }
        return this.myTheme;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target2 = this.myManager.getTarget();
            VersionQualifier version2 = this.myEditedConfig.getVersionQualifier();
            if (target2 != null && version2 != null && version2.getVersion() > target2.getVersion().getFeatureLevel()) {
                target2 = this.myManager.getTarget(version2.getVersion());
            }
            return Configuration.getTargetForRendering(target2);
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        IAndroidTarget target2 = this.getTarget();
        if (target2 instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatTarget = (CompatibilityRenderTarget)target2;
            return compatTarget.getRealTarget();
        }
        return target2;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLocaleQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    @NotNull
    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.myManager.getStateVersion()) {
            this.syncFolderConfig();
        }
        return this.myFullConfig;
    }

    @NotNull
    public FolderConfiguration getEditedConfig() {
        return this.myEditedConfig;
    }

    public void setActivity(@Nullable String activity) {
        if (!StringUtil.equals((CharSequence)this.myActivity, (CharSequence)activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device2, boolean preserveState) {
        if (this.mySpecificDevice != device2) {
            Device prevDevice = this.mySpecificDevice;
            State prevState = this.myState;
            this.myDevice = this.mySpecificDevice = device2;
            int updateFlags = 2;
            if (device2 != null) {
                State state2 = null;
                if (preserveState && prevDevice != null) {
                    if (prevState != null) {
                        FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig((State)prevState);
                        if (oldConfig != null) {
                            String stateName = Configuration.getClosestMatch(oldConfig, device2.getAllStates());
                            state2 = device2.getState(stateName);
                        } else {
                            state2 = device2.getState(prevState.getName());
                        }
                    }
                } else if (preserveState && this.myStateName != null) {
                    state2 = device2.getState(this.myStateName);
                }
                if (state2 == null) {
                    state2 = device2.getDefaultState();
                }
                if (this.myState != state2) {
                    this.setDeviceStateName(state2.getName());
                    this.myState = state2;
                    updateFlags |= 4;
                }
            }
            this.updated(updateFlags);
        }
    }

    @Nullable
    private static String getClosestMatch(@NotNull FolderConfiguration oldConfig, @NotNull List<State> states) {
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count2 = FolderConfiguration.getQualifierCount();
        for (int i = 0; i < count2; ++i) {
            for (State state2 : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state2);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state2);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state2);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.isEmpty()) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (!list1.isEmpty()) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state2) {
        if (this.myState != state2) {
            if (state2 != null) {
                this.setDeviceStateName(state2.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state2;
            this.updated(4);
        }
    }

    public void setDeviceStateName(@Nullable String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equal((Object)stateName, (Object)this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(@NotNull Locale locale) {
        if (!Objects.equal((Object)this.myLocale, (Object)locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(@Nullable IAndroidTarget target2) {
        if (this.myTarget != target2) {
            this.myTarget = Configuration.getTargetForRendering(target2);
            this.updated(32);
        }
    }

    public void setDisplayName(@Nullable String displayName2) {
        if (!StringUtil.equals((CharSequence)this.myDisplayName, (CharSequence)displayName2)) {
            this.myDisplayName = displayName2;
            this.updated(512);
        }
    }

    public void setNightMode(@NotNull NightMode night) {
        if (this.myNightMode != night) {
            if (night == NightMode.NIGHT) {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x20);
            } else {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x10);
            }
        }
    }

    public void setUiMode(@NotNull UiMode uiMode) {
        if (this.myUiMode != uiMode) {
            int newUiTypeFlags = 0;
            switch (uiMode) {
                case NORMAL: {
                    newUiTypeFlags = 1;
                    break;
                }
                case DESK: {
                    newUiTypeFlags = 2;
                    break;
                }
                case WATCH: {
                    newUiTypeFlags = 6;
                    break;
                }
                case TELEVISION: {
                    newUiTypeFlags = 4;
                    break;
                }
                case APPLIANCE: {
                    newUiTypeFlags = 5;
                    break;
                }
                case CAR: {
                    newUiTypeFlags = 3;
                    break;
                }
                case VR_HEADSET: {
                    newUiTypeFlags = 7;
                }
            }
            this.setUiModeFlagValue(this.getUiModeFlagValue() & 0x30 | newUiTypeFlags);
        }
    }

    public void setUiModeFlagValue(int uiMode) {
        int modifiedElements = this.myUiModeFlagValue ^ uiMode;
        this.myUiModeFlagValue = uiMode;
        int updatedFlags = 0;
        if ((modifiedElements & 0x30) != 0) {
            this.myNightMode = (uiMode & 0x30) == 32 ? NightMode.NIGHT : NightMode.NOTNIGHT;
            updatedFlags |= 0x40;
        }
        if ((modifiedElements & 0xF) != 0) {
            switch (uiMode & 0xF) {
                case 5: {
                    this.myUiMode = UiMode.APPLIANCE;
                    break;
                }
                case 3: {
                    this.myUiMode = UiMode.CAR;
                    break;
                }
                case 4: {
                    this.myUiMode = UiMode.TELEVISION;
                    break;
                }
                case 6: {
                    this.myUiMode = UiMode.WATCH;
                    break;
                }
                case 2: {
                    this.myUiMode = UiMode.DESK;
                    break;
                }
                case 7: {
                    this.myUiMode = UiMode.VR_HEADSET;
                    break;
                }
                default: {
                    this.myUiMode = UiMode.NORMAL;
                }
            }
            updatedFlags |= 0x80;
        }
        if (updatedFlags != 0) {
            this.updated(updatedFlags);
        }
    }

    public int getUiModeFlagValue() {
        return this.myUiModeFlagValue;
    }

    public void setTheme(@Nullable String theme) {
        if (!StringUtil.equals((CharSequence)this.myTheme, (CharSequence)theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    public void setFontScale(float fontScale) {
        assert (fontScale > 0.0f) : "fontScale must be greater than 0";
        if (this.myFontScale != fontScale) {
            this.myFontScale = fontScale;
            this.updated(1024);
        }
    }

    public float getFontScale() {
        return this.myFontScale;
    }

    public void setAdaptiveShape(@NotNull AdaptiveIconShape adaptiveShape) {
        if (this.myAdaptiveShape != adaptiveShape) {
            this.myAdaptiveShape = adaptiveShape;
            this.updated(2048);
        }
    }

    @NotNull
    public AdaptiveIconShape getAdaptiveShape() {
        return this.myAdaptiveShape;
    }

    public void setWallpaperPath(@Nullable String wallpaperPath) {
        if (!Objects.equal((Object)this.myWallpaperPath, (Object)wallpaperPath)) {
            this.myWallpaperPath = wallpaperPath;
            this.updated(8);
        }
    }

    @Nullable
    public String getWallpaperPath() {
        return this.myWallpaperPath;
    }

    public void setUseThemedIcon(boolean useThemedIcon) {
        if (this.myUseThemedIcon != useThemedIcon) {
            this.myUseThemedIcon = useThemedIcon;
            this.updated(8);
        }
    }

    public boolean getUseThemedIcon() {
        return this.myUseThemedIcon;
    }

    protected void syncFolderConfig() {
        Device device2 = this.getDevice();
        if (device2 == null) {
            return;
        }
        State deviceState = this.getDeviceState();
        if (deviceState == null) {
            deviceState = device2.getDefaultState();
        }
        FolderConfiguration config2 = Configuration.getFolderConfig(this.myManager.getConfigModule(), deviceState, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config2);
        Locale locale = this.getLocale();
        this.myFullConfig.setLocaleQualifier(locale.qualifier);
        LayoutDirectionQualifier layoutDirectionQualifier = this.myEditedConfig.getLayoutDirectionQualifier();
        if (layoutDirectionQualifier != null && layoutDirectionQualifier != layoutDirectionQualifier.getNullQualifier()) {
            this.myFullConfig.setLayoutDirectionQualifier(layoutDirectionQualifier);
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            ConfigurationModelModule configModule = this.myManager.getConfigModule();
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(this.getTarget(), configModule.getAndroidPlatform(), configModule.getEnvironmentContext());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target2 = this.getTarget();
        if (target2 != null) {
            int apiLevel = target2.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.myManager.getStateVersion();
    }

    @Nullable
    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState = this.getDeviceState();
        if (deviceState != null && (folderConfig = DeviceConfigHelper.getFolderConfig((State)deviceState)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device2 = this.getDevice();
        if (device2 != null) {
            List states = device2.getAllStates();
            for (State state2 : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig((State)state2);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.myManager.computePreferredTheme(this);
                return;
            }
            this.myTheme = ResourceUtils.getStyleResourceUrl(this.myTheme);
        }
    }

    @NotNull
    public Density getDensity() {
        Density d;
        DensityQualifier qualifier = this.getFullConfig().getDensityQualifier();
        if (qualifier != null && (d = qualifier.getValue()) != null && d.isValidValueForDevice()) {
            return d;
        }
        return Density.MEDIUM;
    }

    @Nullable
    public State getNextDeviceState(@Nullable State from) {
        Device device2 = this.getDevice();
        if (device2 == null) {
            return null;
        }
        List states = device2.getAllStates();
        for (int i = 0; i < states.size(); ++i) {
            if (states.get(i) != from) continue;
            return (State)states.get((i + 1) % states.size());
        }
        if (from != null) {
            String name2 = from.getName();
            for (int i = 0; i < states.size(); ++i) {
                if (!((State)states.get(i)).getName().equals(name2)) continue;
                return (State)states.get((i + 1) % states.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration = this;
        synchronized (configuration) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify2 = false;
        Configuration configuration = this;
        synchronized (configuration) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify2 = true;
            }
        }
        if (notify2) {
            this.updated(0);
        }
    }

    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        ++this.myModificationCount;
        if (this.myBulkEditingCount == 0) {
            int changed = this.myNotifyDirty;
            if (this.myListeners != null) {
                for (ConfigurationListener listener2 : this.myListeners) {
                    listener2.changed(changed);
                }
            }
            this.myNotifyDirty = 0;
        }
    }

    public void addListener(@NotNull ConfigurationListener listener2) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ConfigurationListener>();
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ConfigurationListener listener2) {
        if (this.myListeners != null) {
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    @Slow
    @NotNull
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        Device device2 = this.getDevice();
        ResourceResolverCache resolverCache = this.myManager.getResolverCache();
        if (device2 != null && CUSTOM_DEVICE_ID.equals(device2.getId())) {
            resolverCache.replaceCustomConfig(theme, this.getFullConfig());
        }
        return resolverCache.getResourceResolver(this.getTarget(), theme, this.getFullConfig());
    }

    @Nullable
    public ResourceRepository getFrameworkResources() {
        IAndroidTarget target2 = this.getTarget();
        if (target2 != null) {
            return this.myManager.getResolverCache().getFrameworkResources(this.getFullConfig(), target2);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("display", (Object)this.myDisplayName).add("theme", (Object)this.myTheme).add("activity", (Object)this.myActivity).add("device", (Object)this.myDevice).add("state", (Object)this.myState).add("locale", (Object)this.myLocale).add("target", (Object)this.myTarget).add("uimode", (Object)this.myUiMode).add("nightmode", (Object)this.myNightMode).toString();
    }

    @NotNull
    public Module getModule() {
        return this.myManager.getModule();
    }

    @NotNull
    public ConfigurationModelModule getConfigModule() {
        return this.myManager.getConfigModule();
    }

    public void dispose() {
    }

    public void setEffectiveDevice(@Nullable Device device2, @Nullable State state2) {
        int updateFlags = 0;
        if (this.myDevice != device2) {
            updateFlags = 2;
            this.myDevice = device2;
        }
        if (this.myState != state2) {
            this.myState = state2;
            this.myStateName = state2 != null ? state2.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    private static IAndroidTarget getTargetForRendering(@Nullable IAndroidTarget target2) {
        if (target2 == null) {
            return null;
        }
        return StudioEmbeddedRenderTarget.getCompatibilityTarget(target2);
    }
}

