/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.TraceSignatureConverter;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J#\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\u0002\u0010\u000fR\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/codenavigation/TraceSignatureConverter;", "", "()V", "primitiveTypes", "", "Lcom/intellij/psi/PsiPrimitiveType;", "kotlin.jvm.PlatformType", "", "convertToString", "psiType", "Lcom/intellij/psi/PsiType;", "getTraceSignature", "returnType", "parameterTypes", "", "(Lcom/intellij/psi/PsiType;[Lcom/intellij/psi/PsiType;)Ljava/lang/String;", "codenavigation"})
public final class TraceSignatureConverter {
    @NotNull
    public static final TraceSignatureConverter INSTANCE = new TraceSignatureConverter();
    @NotNull
    private static final Map<PsiPrimitiveType, String> primitiveTypes;

    private TraceSignatureConverter() {
    }

    @VisibleForTesting
    @NotNull
    public final String convertToString(@NotNull PsiType psiType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        PsiType type = TypeConversionUtil.erasure((PsiType)psiType);
        if (type instanceof PsiArrayType) {
            PsiType psiType2 = ((PsiArrayType)type).getComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"type.componentType");
            object = "[" + this.convertToString(psiType2);
        } else if (type instanceof PsiPrimitiveType) {
            object = primitiveTypes.getOrDefault(type, "");
        } else if (type instanceof PsiClassType) {
            String string = type.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.getCanonicalText()");
            object = "L" + StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null) + ";";
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getTraceSignature(@Nullable PsiType returnType, @NotNull PsiType[] parameterTypes2) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes2, (String)"parameterTypes");
        return returnType == null ? "(" + ArraysKt.joinToString$default((Object[])parameterTypes2, (CharSequence)"", null, null, (int)0, null, (Function1)getTraceSignature.1.INSTANCE, (int)30, null) + ")" : "(" + ArraysKt.joinToString$default((Object[])parameterTypes2, (CharSequence)"", null, null, (int)0, null, (Function1)getTraceSignature.2.INSTANCE, (int)30, null) + ")" + this.convertToString(returnType);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PsiType.BYTE, (Object)"B"), TuplesKt.to((Object)PsiType.CHAR, (Object)"C"), TuplesKt.to((Object)PsiType.DOUBLE, (Object)"D"), TuplesKt.to((Object)PsiType.FLOAT, (Object)"F"), TuplesKt.to((Object)PsiType.INT, (Object)"I"), TuplesKt.to((Object)PsiType.LONG, (Object)"J"), TuplesKt.to((Object)PsiType.SHORT, (Object)"S"), TuplesKt.to((Object)PsiType.BOOLEAN, (Object)"Z"), TuplesKt.to((Object)PsiType.VOID, (Object)"V")};
        primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
    }
}

