/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/codenavigation/NativeNavSource;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "symbolizer", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;)V", "lookUp", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "arch", "", "codenavigation"})
public final class NativeNavSource
implements NavSource {
    @NotNull
    private final Project project;
    @NotNull
    private final NativeSymbolizer symbolizer;

    public NativeNavSource(@NotNull Project project, @NotNull NativeSymbolizer symbolizer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbolizer, (String)"symbolizer");
        this.project = project;
        this.symbolizer = symbolizer;
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location, @Nullable String arch) {
        Navigatable navigatable;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!location.isNativeCode() || location.getFileName() == null || arch == null) {
            return null;
        }
        try {
            Symbol symbol = this.symbolizer.symbolize(arch, new File(location.getFileName()), location.getNativeVAddress());
            navigatable = (Navigatable)(symbol == null ? null : new FileNavigatable(this.project, new FilePosition(new File(symbol.getSourceFile()), symbol.getLineNumber() - 1, 0)));
        }
        catch (IOException e) {
            navigatable = null;
        }
        return navigatable;
    }
}

